/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: interface.h,v 1.2 1994/01/14 11:15:19 bob Exp $
 *
 *	$Log: interface.h,v $
 * Revision 1.2  1994/01/14  11:15:19  bob
 * Ported to FreeBSD, thanx vv@sonet.kemerovo.su
 *
 * Revision 1.1  1993/10/20  16:03:10  bob
 * Initial revision
 *
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <machine/endian.h>

#ifdef __GNUC__
#define inline __inline
#else
#define inline
#endif

#ifndef __STDC__
extern char *malloc();
extern char *calloc();
#endif

extern int dflag;		/* print filter code */
extern int nflag;		/* leave addresses as numbers */
extern int Nflag;		/* resolve only local domain */

extern char *program_name;	/* used to generate self-identifying messages */

extern int link_type;
extern unsigned long netmask;
extern unsigned long localnet;
extern int snaplen;
/* global pointers to beginning and end of current packet */
extern unsigned char *packetp;
extern unsigned char *snapend;

/* ../lib/inet.c */
extern char *lookup_device();

/* ../lib/util.c */
extern void error();
extern void warning();
extern char *stripdir();
extern char *read_infile();
extern char *copy_argv();

/* ../lib/interfaces.c */
extern void bpf_ether();
extern void bpf_slip();
extern void bpf_ppp();
extern void bpf_null();

/* ../lib/bpf.c */
extern int /*   fd   */	bpf_init	(/* char *if_name, int pflag */);
extern int /* 0 fail */	bpf_stats	(/* int fd, int *recv, int *drop */);
extern int /* 0 fail */	bpf_readloop	(/* int count, int fd,
					 struct bpf_program *fcode | NULL */);

/*
 * user's function processing_ip(), must be follow -
 *
 * void
 * processing_ip( ip, length )
 *	struct ip *ip;
 *	int length;
 * {
 *	...
 * }
 *
 */
extern void processing_ip();

#define min(a,b) ((a)>(b)?(b):(a))
#define max(a,b) ((b)>(a)?(b):(a))

/* 
 * The default snapshot length.
 * In particular, it allows for an ethernet header, tcp/ip header, and
 * 14 bytes of data (assuming no ip options).
 */
#define DEFAULT_SNAPLEN 68
