#!/bin/sh
# This is a shell archive.  Save it in a file, remove anything before
# this line, and then unpack it by entering "sh file".  Note, it may
# create directories; files and directories will be owned by you and
# have default permissions.
#
# This archive contains:
#
#	etc/slipgetty.conf
#	usr/local/lib/slipgetty
#
echo x - etc/slipgetty.conf
sed 's/^X//' >etc/slipgetty.conf << 'END-of-etc/slipgetty.conf'
X#
X# Params for slipup.
X#
X#	If this file has passwords in it, protect it!
X#
X# 
X#
X# These variables are used in the main program, but set here.
X#
X$speed=		"38400";
X$debug=		"/tmp/slipgetty.debug";
X
X##
X## Edit this subroutine.  See below for subsidiary function definitions.
X##
X#
X# dialup, login, and start slip...
X#
Xsub StartRemoteSlip {
X	local($login)=		"someuser";
X	local($password)=	"secret";
X#	local(@phonelist) = (
X#		"555-1111",
X#		"555-2222",
X#		"555-3333",
X#	);
X#	srand;
X
X#	local($phone_number)=	$phonelist[rand($#phonelist+1)];
X	local($phone_number)=	"5418243";
X	local($tty)=		$_[0];
X
X	sleep(1);
X	&Send_Expect_Timeout_Repeat("ATZ\r","OK",10,2);
X	&Send_Expect_Timeout("AT&C1&D3\r","OK",10);
X	&Send_Expect_Timeout("ATMDT$phone_number\r","CONNECT",50) &&
X	sleep(1) &&
X	&System('/bin/stty','-f',$tty,'-clocal') &&
X	&Send_Expect_Timeout_Repeat("\r","ogin:",2,30) &&
X	&Send_Expect_Timeout("$login\r","word:",15) &&
X	&Send_Expect_Timeout("$password\r","nnex:",15) &&
X	&Send_Expect_Timeout("slip\r","Switching to SLIP.",15);
X	&Expect(".\r",5);
X}
X
X# The Send_Expect* subroutines are fairly straight forward.  They
X# do just what the name implies.
X#
X# Send_Expect_Timeout($S,$E,$T):
X#
X#	Sends the string $S, waits at most $T seconds looking for
X#       $E.  Returns 1 on sucess, undef on timeout or other error.
X#
X# Send_Expect_Timeout_Repeat($S,$E,$T,$N):
X#
X#	Repeatedly calls Send_Expect_Timeout at most $N times or
X#	until it suceeds.  Returns 1 on sucess, undef on failure.
X#
X
X#
X# This subroutine is responsible for ifconfig'ing the interface up
X# and seting up any routes.  The first argument $_[0] will be the
X# name of the interface (e.g. "sl0").
X#
Xsub Config {
X	#
X	# If you are using the link as a default route you should be able
X	# to just set local_addr and remote_addr here and be done.
X	#
X	local($remote_addr)=	"130.13.13.3";
X	local($local_addr)=	"130.13.13.11";
X	local($interface)=	$_[0];
X
X	&System ('/sbin/ifconfig',$interface,'down');
X	&System ('/sbin/route','-n','-q','flush') ||
X		warn "Problem flushing routes";
X	&System ('/sbin/ifconfig',$interface,'inet',$local_addr,$remote_addr,'link0','-link1','link2','up') ||
X		warn "Problem configuring interface.";
X	&System ('/sbin/route','-n','-q','add','default',$remote_addr) ||
X		warn "Problem adding route";
X	&System ('/sbin/route','-n','-q','add',$local_addr,'127.0.0.1') ||
X		warn "Problem adding route";
X}
X
X#
X# Do something to verfiy that the link is actually working.
X# E.G.  connect() to an SMTP or telnet port somewhere on the other side.
X# When implemented, this will be called every $lt_interval
X# seconds.
X#
X
X#	To test the SLIP link, try to connect to this sockaddr address.
X$lt_addr=		pack('S n C4 x8', 2, 23, 130,13,13,3);
X
X#	The link is tested every $lt_interval sec (if defined).
X$lt_interval=		300;
X
X#	After $lt_count_max failures, we hang up and try again.
X$lt_count=$lt_count_max=5;
X
Xsub TestLink {
X#	&Debug("mark...\n");
X	socket(TEST, 2, 1, 6) || &Debug("socket: $!\n");
X	if (connect(TEST, $lt_addr)) {
X		$lt_count = $lt_count_max;
X	} else {
X		&Debug("Link integrety check failed!  connect(".
X				unpack('H*',$lt_addr).": $!\n");
X		--$lt_count;
X	}
X	close(TEST);
X	$lt_count > 0;
X}
X
X1;		# return a nice status fore the "require" command...
END-of-etc/slipgetty.conf
echo x - usr/local/lib/slipgetty
sed 's/^X//' >usr/local/lib/slipgetty << 'END-of-usr/local/lib/slipgetty'
X#!/usr/bin/perl
X
X# NOTE!:  Before using this script, edit the file /etc/slipgetty.conf and
X# change the "StartRemoteSlip" subroutine to suite your situation.
X
X# This script is configured to run from init(8).  You will need to put
X# a line such as this in /etc/ttys:
X#
X# com1	"/usr/local/lib/slipgetty /etc/slipgetty.conf"	unknown	on
X
Xsub Send {
X	print @_[0];
X	&DebugL("Sent: ",@_[0]);
X}
X
Xsub Expect {
X	local($s_in) = "";
X	$wait_time = pop(@_) if ($#_ > $[);
X	&DebugL("Looking for: ", @_ );
X	local($qtime) = time + $wait_time;
X	while (time < $qtime) {
X		local($rin) = '';
X		vec($rin,fileno(TTY),1) = 1;
X		if (select($rin,undef,undef,1)) {
X			if (sysread(TTY,$s_in,1,length($s_in)) < 1) {
X				&DebugL("Error \"$!\" after: ",$s_in);
X				return undef;
X			}
X			foreach $ss (@_) {
X				if (index($s_in,$ss) >= 0) {
X					&DebugL("Found ",$ss);
X					&DebugL("   In ",$s_in);
X					return $ss;
X				}
X			}
X		}
X	}
X	&DebugL("Timeout after: ",$s_in);
X	return undef;
X}
X
Xsub Send_Expect_Timeout {
X	&Send(shift);
X	&Expect(@_);
X}
X
Xsub Send_Expect_Timeout_Repeat {
X	local($count) = pop @_;
X	while (--$count > 0) {
X		return 1 if (&Send_Expect_Timeout(@_));
X	}
X	return undef;
X}
X
X
Xsub Sctty {
X	if (syscall($SYS_setsid)) {
X		&Debug("setsid()\n");
X	} else {
X		warn ("setsid(): \"$!\"");
X	}
X	if (ioctl(TTY, $TIOCSCTTY, 0)) {
X		&Debug("Set controling tty...\n");
X	} else {
X		warn ("ioctl(TIOCSCTTY): \"$!\"");
X	}
X}
X
Xsub Hup {
X	&Debug("Caught signal!\n");
X	&System('/bin/stty','-f',$tty,'tty','-clocal');
X	&Exit(0);
X}
X
Xsub Exit {
X	&Debug("closing $tty\n");
X	&System('/bin/stty','-f',$tty,'0');
X	close(STDIN);
X	close(STDOUT);
X	close(STDERR);
X	close(TTY);
X	# sleep(10);
X	exit @_;
X}
X
Xsub StartLocalSlip {
X	&Debug("Changing line discipline...\n");
X	local($slipdisc) = pack("i",$SLIPDISC);
X	local($inumstr) = '';
X	if (!ioctl(TTY,$TIOCSETD,$slipdisc)) {
X		warn("ioctl(TIOCSETD): \"$!\"");
X		return undef;
X	}
X	if (!ioctl(TTY, $SLIOCGUNIT, $inumstr)) {
X		warn(sprintf("ioctl(SLIOCGUNIT = 0x%08x): cant find interface number, \"$!\", using \"sl0\"", $SLIOCGUNIT));
X		"sl0";
X	} else {
X		sprintf("sl%d",unpack("i",$inumstr));
X	}
X}
X
Xsub System {
X	&DebugL("System: ",@_);
X	if (system (@_) == 0) {
X		return 1;
X	} else {
X		return undef
X	};
X}
X
Xsub Debug {
X	printf STDERR @_;
X}
X
Xsub DebugL {
X	return 1 unless ($debug);
X	local($sx) = shift . "\"";
X	local($s);
X	while (defined($s = shift)) {
X		foreach $cx (split(//,$s)) {
X			if (32 <= ord($cx) && ord($cx) <= 126) {
X				$sx .= $cx
X			} else {
X				$sx .= sprintf("\\%03o",ord($cx));
X			}
X		}
X		$sx .= "\" \"" if ($#_ >= $[);
X	}
X	&Debug("$sx\"\n");
X}
X
Xsub CheckDefined {
X	local($value,$default,$name,$file) = @_;
X	$_[0] = &$name if(!$_[0] && defined(&$name));
X	unless($_[0]) {
X		$_[0] = $default;
X		warn sprintf ("\$$name (normally found in $file) is undefined using 0x%x.\n",$_[0]);
X	}
X}
X
X#
X# main
X#
X$pause=			0;	# initial retry delay;
X$debug=			0;
X$wait_time=		5;
X
X#
X# argument processing
X#
X$tty = "/dev/" . pop(@ARGV);
X$conf = shift @ARGV;
X$conf = "/etc/slipgetty.conf"
X	unless (-f $conf);
X
Xdo "sys/syscall.ph" || warn "Cant find sys/syscall.ph";
Xdo "ioctl.pl" || warn "Cant find ioctl.pl";
Xdo "sys/ioctl.ph" || do "ioctl.ph" || warn "Cant find either sys/ioctl.ph or ioctl.ph";
Xrequire $conf;
X
X$SIG{'HUP'} = 'Hup';
X
Xif ($debug) {
X	open(STDERR,">$debug");
X	chown root, staff, "$debug" ||
X		warn "Trouble chown'ing \"$debug\" to root";
X	chmod 0400, "$debug" ||
X		warn "Trouble chmod'ing \"$debug\" to 0400";
X} else {
X	open(STDERR,">/dev/null");
X}
Xopen(STDOUT,">/dev/null");	# for the benifit
Xopen(STDIN,"</dev/null");	# of posterity...
X
X#
X# Double check that the above "do" commands really worked.
X#
X&CheckDefined($SYS_setsid,147,"SYS_setsid","sys/syscall.ph");
X&CheckDefined($TIOCSETD,0x80047401,"TIOCSETD","ioctl.pl");
X&CheckDefined($TIOCSCTTY,0x20007461,"TIOCSCTTY","ioctl.pl or sys/ioctl.ph");
X&CheckDefined($SLIOCGUNIT,0x40047458,"SLIOCGUNIT","sys/if_slvar.ph");
X&CheckDefined($SLIPDISC,4,"SLIPDISC","ioctl.pl or sys/ioctl.ph");
X
X#
X# Set line flags
X#
X&System("/bin/stty -f $tty 0");
X&System("/bin/stty -f $tty $speed raw clocal");
X
X#
X# open line
X#
X&Debug("open(TTY,\"+>$tty\")\n");
Xunless (open(TTY,"+>$tty")) {
X	warn ("Cant open $tty");
X	&Exit(1);
X}
Xselect(TTY); $| = 1;
X
X&Sctty;
Xsleep 1;	# XXX ??
X
X&Debug("Dialing...\n");
X&StartRemoteSlip($tty) || &Exit(1);
X
X($interface = &StartLocalSlip) || &Exit(1);
X&Debug("Attached to $interface\n");
X&Config($interface);
X
X&Debug("sleeping...\n");
Xif ($lt_interval) {
X	sleep $lt_interval while (&TestLink);
X} else {
X	sleep;
X}
END-of-usr/local/lib/slipgetty
exit
