#ifndef lint
static char *rcsid = "$Header: /usr/src/local/xldial/RCS/xldial.c,v 1.1 1994/01/24 09:13:08 root Exp root $";
#endif


/*
 * !!! :   |,   :   gdial    !
 * $Log: xldial.c,v $
 * Revision 1.1  1994/01/24  09:13:08  root
 * Initial revision
 *
 * Revision 1.10  93/07/06  20:25:52  chech
 *      ":"
 * 
 * Revision 1.9  93/07/03  15:44:07  chech
 *    :-)
 * 
 * Revision 1.8  92/10/21  12:44:33  chech
 *   
 * 
 * Revision 1.7  92/10/01  17:33:35  chech
 *   uucp-Lock-.  lock-   defs.h
 * 
 * Revision 1.5  92/08/16  20:04:24  chech
 * version for multislip
 * 
 * Revision 1.4  92/06/08  16:55:39  olg
 * Fixed bug related to incorrect printing of interface
 * number to log file
 * 
 * Revision 1.3  1992/03/30  17:01:47  olg
 * Changes to work with new routed policy
 * (wait GARBAGE_TIME - EXPIRE_TIME before
 * releasing interface)
 *
 * Revision 1.2  1992/03/27  01:57:04  olg
 * Fixed problems with old interface routes remain, when
 * dialout interface goes down. Now send SIGQUIT to routed
 * to invalidate old routes.
 *
 * Revision 1.1  1992/03/26  01:09:34  olg
 * Initial revision
 *
 *
 */

#include "defs.h"
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/termios.h>
#include <sys/wait.h>
#include <setjmp.h>
#include <signal.h>
#include <time.h>
#include <ttyent.h>
#include <utmp.h>
extern char *sys_errlist[];

# define IS_CLOSED      0
# define IS_OPENED      1
# define IS_CONNECTED   2
# define IS_CHECKED     3

#define DIALOUT
#include "readcf.c"

jmp_buf tbuf;
jmp_buf wbuf;

FILE * ftrace;
char   *gdargv[20];		/* arg list for dialer */
struct termios  term;
char   *progname;
char   *id;
char	name [IFNAMSIZ];
int     sock, fd = -1;
pid_t   pid ;
int Debug = 0;
char *xDebug = NULL;
int huped;

void hangup (), cleanup (), keepalive ();
char   *ctime ();

main (argc, argv)
char   **argv;
{
    register struct sldialup   *slp;
    struct sl_attach sl;
    char   *tmpchat;
    int     baud, i, s, status, pp;
    short   direct = 0, leased = 0, local = 0;
    char *curphone ();

    ftrace = stdout;
    progname = *argv;
    if (argc > 1 && argv[1][0] == '-' && argv[1][1] == 'x')
    {
	Debug = atoi(&argv[1][2]);
	xDebug = argv[1];
	argv++; argc--;
    }
    if ( Debug < 0) Debug = 5;
    if (argc != 2) {
	fprintf (stderr, "Usage: %s [-xN] host-id\n", progname);
	exit (1);
    }
    id = argv[1];                                       /* init id */
    if ((slp = readcfdial (CONFIG, id)) == NULL) {
	if (error [0])
	    fprintf (stderr, "%s: %s\n", progname, error);
	else
	    fprintf (stderr, "%s: id \"%s\" not found\n", progname, id);
	exit (1);
    }

    if (Debug < 10 && fork ())      exit (0);
    pid = getpid ();
    if (Debug < 10) {
	for (i = 0; i < 40; i++)    close (i);
	open ("/dev/null", 0);                          /* stdin */
	dup (0);                                        /* stdout */
	if ((ftrace = fopen (LOG, "a")) == NULL)        /* stderr */
	    exit (2);
    } else
	ftrace = stdout;
    if ((sock = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
	panic ("socket", NULL, 1);

nextid:
    if (slp->sl_unit < 0 || slp->sl_unit > 64)          /* paranoid :) */
	panic ("invalid interface: sl%d", slp->sl_unit, 2);
    if (strncmp (slp -> sl_dialer, "dir", 3) == 0)          direct++;
    else if (strncmp (slp -> sl_dialer, "leas", 4) == 0)    leased++;
    else if (strncmp (slp -> sl_dialer, "local", 5) == 0)   local++;
    if (!direct && !leased && !local)
	initphone (slp -> sl_phone);

    if      (strcmp (slp -> sl_speed,  "2400") == 0) baud = 2400;
    else if (strcmp (slp -> sl_speed,  "4800") == 0) baud = 4800;
    else if (strcmp (slp -> sl_speed,  "9600") == 0) baud = 9600;
    else if (strcmp (slp -> sl_speed, "19200") == 0) baud = 19200;
    else if (strcmp (slp -> sl_speed, "38400") == 0) baud = 38400;
    else if (strcmp (slp -> sl_speed, "57600") == 0) baud = 57600;
    else if (strcmp (slp -> sl_speed, "76800") == 0) baud = 76800;
    else if (strcmp (slp -> sl_speed,"115200") == 0) baud = 115200;
    else {
	log ("Unknown baud rate %s", slp -> sl_speed, 0, 0);
	exit (1);
    }

    if (fd >= 0) close(fd); fd = -1;
    if (mk_lock (slp->sl_line))
	panic ("Can't lock line %s", slp->sl_line, 1);

/*    NDELAY -     :
 * 1)  dialup -   dialer
 * 2)  direct -    script-
 * 3)  leased -    script-
 * 4)  local  -    ...
 */
    if ((fd = open (slp -> sl_line, O_RDWR|O_NDELAY )) < 0)
	panic ("can't open outgoing line: %s", slp -> sl_line, 1);
    dtr (1);                /* -  BSDI */

/*   .    fork () */
    if (setsid () == -1)
	log ("setsid() failed: %s", sys_errlist[errno], 0, 0);
    if (ioctl (fd, TIOCSCTTY, 0) == -1)
	log ("TIOCSCTTY (line %s) failed: %s", slp -> sl_line,
					sys_errlist[errno], 0);

    if (ioctl (fd, TIOCGETA, &term) < 0)
	panic ("unable to get line params", NULL, 1);
    term.c_cflag = CS8 | CREAD | HUPCL | CRTSCTS;
    term.c_iflag = 0;
    term.c_oflag = 0;
    term.c_lflag = 0;
    term.c_ispeed = term.c_ospeed = baud;
    term.c_cc [VMIN]  = 1;
    term.c_cc [VTIME] = 0;
    if (ioctl (fd, TIOCSETA, &term) == -1)
	panic ("unable to set line parameters", NULL, 1);

    signal (SIGTERM, cleanup);
    signal (SIGINT,  cleanup);
    signal (SIGQUIT, cleanup);
    signal (SIGHUP,  SIG_IGN);

    for (;;) {
	dtr (1);                /* -  BSDI */
	log ("Calling system with %s", slp->sl_dialer, 0, 0);
	mark_line(slp->sl_line, id, IS_OPENED);

	if (!direct && !leased && !local) { /* make ARGV array for GDIAL */
	    i = 0;
	    if (slp -> sl_dialer [0] == '/')
		gdargv[i++] = slp -> sl_dialer;
	    else {
		gdargv[i++] = "GDIAL";
		gdargv[i++] = "-t";
		gdargv[i++] = slp -> sl_dialer;
	    }
	    if (Debug) gdargv[i++] = xDebug;
	    gdargv[i++] = slp -> sl_line;
	    gdargv[pp = i++] = curphone (0);
	    gdargv[i++] = slp -> sl_speed;
	    gdargv[i++] = NULL;
	}

	for (i = 0; ;i++) {         /* initialization loop */
	    if (slp -> sl_retries && (i >= slp -> sl_retries)) {
		log ("dial %s line %s failed completely.",
		    slp -> sl_dialer, slp -> sl_line, 0);
		if (slp = slp -> sl_nextp) {
		    close (fd);
		    rm_lock ((char *) 0);
		    id = slp -> sl_id;
		    log ("Try next id \"%s\" ...", id, 0, 0);
		    if (Debug < 10) {
/*       .. BSDI' TIOCSCTTY.
 *       setsid TIOCSCTTY  EPERM.
 */ /*     vfork     */
			while ((i = fork ()) == -1) {
			    log ("fork failed: %s; wait a moment..",
				sys_errlist[errno], 0, 0);
			    sleep (1);
			}
			if (i) _exit(0);    /*   */
			pid = getpid ();    /*  pid  log' */
		    }
		    goto nextid;
		}
		else
		    cleanup (0);
	    }
	    if (!direct && !leased && !local) { /* Dial the phone and wait CONNECT */
		if (i > 0) {
		    gdargv [pp] = curphone (1);
		    sleep (i);
		}
		if ((s = fork ()) == 0) {
		    if (slp -> sl_dialer [0] == '/') {
			execvp (slp -> sl_dialer, gdargv);
			panic ("can't exec dialer %s", slp -> sl_dialer, 255);
		    }
		    else {
			execvp (DIALER1, gdargv);
			execvp (DIALER2, gdargv);
			panic ("can't exec dialer %s", DIALER1, 255);
		    }
		}
		else if (s < 0)
		    panic ("fork failed", NULL, 1);
		else
		    wait (&status);

		if (WEXITSTATUS (status) == 255)
		{
		    rm_lock ((char *) 0);
		    exit (1);
		}
		else if (WIFSIGNALED (status)) {
		    log ("dialer got signal %d, still trying ...",
			    WTERMSIG (status), 0, 0);
		    continue;
		}
		if ((WEXITSTATUS (status) & 0x80) == 0x80) {
		    log ("dialer failed with %d, still trying ...",
			    WEXITSTATUS (status) & 0x7f, 0, 0);
		    continue;
		}
		/*   -  CLOCAL */
		if (ioctl (fd, TIOCSETA, &term) < 0)
		    panic ("unable to set line discipline", NULL, 1);
	    }   /* !direct && !leased */
	    else if (direct) {  /*    */
		if (waitcarrier (slp -> sl_line) < 0) {
		    tmpchat = "direct line CARRIER absent";
		    goto initerror;
		}
		sleep (1);
	    }
	    else if (leased || local) { /*     CHAT */
		term.c_cflag |= CLOCAL;
		ioctl (fd, TIOCSETA, &term);
		term.c_cflag &= ~CLOCAL;
		sleep (1);
	    }
	    /* Chat */
	    tmpchat = strdup (slp -> sl_chat);
	    s = chat (tmpchat);
	    free (tmpchat);
	    if (s < 0)
		tmpchat = "chat returns %d, still trying ..";
	    else if (leased && (waitcarrier (slp -> sl_line) < 0))
		tmpchat = "leased line CARRIER absent";
	    else
		break;      /* line was chated OK */
initerror:
	    log (tmpchat, s, 0, 0);
	    dropdtr ();
	}
	log ("Chat successful", 0, 0, 0);

	i = SLIPDISC;
	if (ioctl (fd, TIOCSETD, &i) == -1)
	    panic ("Can't set SLIP line disc to %s", slp -> sl_line, 1);

/* complex ATTACH & WAIT ioctl */
	sl.sl_unit = slp -> sl_unit;
	sl.sl_fill = slp -> sl_outfill;
	sl.sl_keep = slp -> sl_keepal;
	sl.sl_cnt  = slp -> sl_waiting;
	if (slp -> sl_outfill)
	    log ("out is filled (%d sec)", slp->sl_outfill, 0, 0);
	if (slp->sl_keepal) {
	    log ("input is checked (%d sec)", slp->sl_keepal, 0, 0);
	    if (slp->sl_waiting)
		log ("waiting %d keepalives per %d sec",
				slp->sl_waiting, slp->sl_keepal, 0);
	}
	huped = 0;
	signal (SIGHUP, hangup);        siginterrupt (SIGHUP, 1);
	signal (SIGUSR1, keepalive);    siginterrupt (SIGUSR1,1);
	if (ioctl (fd, SLIOCATTW, &sl) < 0) {
	    if (errno == ETIMEDOUT) {
		log ("no keepalives", 0, 0, 0);
		goto nokeeps;
	    }
	    panic ("SLIOCATTW failed", NULL, 1);
	}
	if (huped)
	    goto huped;
	if (ioctl(fd, SLIOCGUNIT, &i) < 0)
	    panic ("SLIOCGUNIT failed", NULL, 1);
	if (i != slp->sl_unit)
	    panic ("failed to attach to unit: %d got %d", slp->sl_unit, i);
	sprintf (name, "sl%d", slp->sl_unit);
	if (slp -> sl_mtu) {
	    if (ioctl (fd, SLIOCSETMTU, &(slp -> sl_mtu)) < 0)
		log ("SLIOCSETMTU to %d failed: %s",
			    slp -> sl_mtu, sys_errlist[errno], 0);
	    if (ioctl (fd, SLIOCGETMTU, &i) < 0)
		panic ("SLIOCGETMTU failed", NULL, 1);
	    log ("use max transfer unit mtu=%d", i, 0, 0);
	}

	if_up (name, &slp->sl_src, &slp->sl_dst, &slp->sl_netmask,
		     slp->sl_setmode, slp->sl_clrmode);
	log ("attach successful name=\"%s\"", name, 0, 0);

	if (!huped) mark_line (slp->sl_line, id, IS_CONNECTED);
	if (!huped) pause ();

huped:  /* Hangup */
	signal (SIGHUP, SIG_IGN);
	if (ioctl (fd, SLIOCDETACH, &i) == -1)
		panic ("SLIOCDETACH failed", NULL, 1);
nokeeps:/* no keepalives during attach */
	i = TTYDISC;
	if (ioctl (fd, TIOCSETD, &i) == -1)
	    panic ("Can't set TTY line disc to %s", slp -> sl_line, 1);

	mark_line(slp->sl_line, id, IS_CLOSED);
	sleep (1);
	dropdtr ();
    }
}

/* Return Code:
 *  0   OK
 * -1   send   error
 * -2   expect error
 */
char incorrect [] = "incorrect";    /* MAGIC WORD for all Unix'es */
chat (chatstr)
char   *chatstr;
{
    register char *cp;
    int of, rt;

    of = fcntl (fd, F_GETFL, 0);
    fcntl (fd, F_SETFL, of | O_NONBLOCK);
    cp = strtok (chatstr, " \t");
    for (;;) {
    /*** make "SEND" ***/
	if (Debug > 6)  log ("send: \t\"%s\"", cp, 0, 0);
	if (line_write (cp)) {
	    if (Debug > 6)  log ("send failed", NULL, 0, 0);
	    rt = -1;                                /* write error */
	    break;
	};
	if ((cp = strtok (NULL, " \t")) == NULL) {  /* "send" is a last item */
	    rt = 0;
	    break;
	};
    /*** make "EXPECT" ***/
	rt = 0;
	if (*cp == '\\') {                          /* count timeout */
	    for (++cp; *cp >= '0' && *cp <='9'; cp++)
		rt = rt * 10 + (*cp - '0');
	}
	if (! strcmp (cp, "*")) {                   /*   */
	    if (rt == 0) rt = 5;
	    if (Debug > 6)
		log ("expect:\t\"^%s\" (%d)", incorrect, rt, 0);
	    if (! line_read (incorrect, rt)) {      /* expect error */
		if (Debug > 6)  log ("expect failed", NULL, 0, 0);
		rt = -2;
		break;
	    }
	}
	else {
	    if (rt == 0) rt = 20;
	    if (Debug > 6)
		log ("expect:\t\"%s\" (%d)", cp, rt, 0);
	    if (line_read (cp, rt)) {               /* expect error */
		if (Debug > 6)  log ("expect failed", NULL, 0, 0);
		rt = -2;
		break;
	    }
	}
	if ((cp = strtok (NULL, " \t")) == NULL) { /* "expect" is a last item */
	    rt = 0;
	    break;
	}
    }
    fcntl (fd, F_SETFL, of);
    return (rt);
}


line_write (line)
register char  *line;
{
    register char  *cp;
    int     i,
	    n,
	    cr = -1;
    register char   c;

    ioctl (fd, TIOCFLUSH, 0);
    sleep (1);

    if (setjmp (tbuf) || setjmp (wbuf)) {
	alarm (0);
	return (1);
    }
    cp = line;
    if (!strcmp (cp, "\"\"")) {
	line_wrchr ('\r');
	return (0);
    }
    while (c = *cp++) {
	if (c == '\\') {
	    switch (*cp++) {

		case '\0':
		    --cp;
		    continue;

		case '\\':
		    c = '\\';
		    break;

		case 's':
		    c = ' ';
		    break;

		case 'd':
		    sleep (2);
		    continue;

		case 'n':
		    c = '\n';
		    break;

		case 'r':
		    c = '\r';
		    break;

		case 'c':
		    if (*cp == '\0')
			cr = 0;
		    continue;

		default:
#define isoctal(x)  ((x >= '0') && (x <= '7'))
		    if (isoctal (cp[-1])) {
			i = 0;
			n = 0;
			--cp;
			while (isoctal (*cp) && ++n <= 3)
			    i = i * 8 + (*cp++ - '0');
			line_wrchr (i);
			continue;
		    }
	    }
	}
	line_wrchr (c);
    }
    if (cr)
	line_wrchr ('\r');
    return 0;
}

void timeout () {
    signal (SIGALRM, timeout); siginterrupt (SIGALRM, 1);
    longjmp (tbuf, 1);
}

line_read (expect, timout)
char   *expect;
{
    register char  *mp,
		   *bp;
    char    c;
    int     match,
	    n;
    char    buf[512];

    if (setjmp (tbuf)) {
	goto exit;
    }

    signal (SIGALRM, timeout);
    alarm (timout);
    match = 0;
    mp = expect;
    bp = buf;
    for (;;) {
        n = read (fd, &c, 1);
	if (n < 0) {
	    if (errno != EWOULDBLOCK) 
		break;
	    n = 0;
	}
	if (n == 0) {
	    sleep (1);
	    signal (SIGALRM, timeout);
	    if (--timout == 0)
		break;
	    alarm (timout);
	    continue;
	}
	if (bp - buf >= 512)
	    break;
	*bp++ = c;
	if (c == *mp && match == 0) {
	    match++;
	    mp++;
	}
	else
	    if (c != *mp && match) {
		match = 0;
		mp = expect;
	    }
	    else
		if (c == *mp && match)
		    mp++;
	if (*mp == '\0') {
	    alarm (0);
	    return 0;
	}
    }

exit:
    alarm (0);
    return (1);
}

line_wrchr (c)
char    c;
{
    int     i;

    i = alarm (4);
    signal (SIGALRM, timeout);
    if (write (fd, &c, 1) != 1) {
	alarm (0);
	longjmp (wbuf, 2);
    }
    alarm (i);
}

void hangup () {
    signal (SIGHUP, SIG_IGN);
    huped = 1;
    log ("link failed, reconnecting ...", 0, 0, 0);
    return;
}

void keepalive (sig) 
{

    signal (sig, SIG_IGN);
    huped = 1;
    log ("keepalive timeout, trying to reconnect ...", 0, 0, 0);
    signal (sig, keepalive);
    return;
}

void cleanup (sig) {
    int     ret, lines;

    signal (sig, SIG_IGN);
    ret = ioctl (fd, SLIOCDETACH, &lines);
    close (fd);                 /*       - */
    rm_lock((char *)0);
    mark_line(0,0,0);

    if (ret == 0) {                         /*  ioctl  */
	log ("slip link detach, present lines %d",
	    lines == -1 ? 0 : lines, 0, 0);
	if (lines == 0)                     /*      */
	    if_down (name);                 /*   */
    }
    if (sig)
	log ("program terminated by signal %d", sig, 0, 0);
    else
	log ("program completely stoped", 0, 0, 0);
    exit (2);
}

panic (fmt, arg, exitcode)
char   *fmt,
       *arg;
{
    time_t tm;
    char   *s;

    rm_lock((char *)0);
    time (&tm);
    s = ctime (&tm) + 4;                /*    */
    s[strlen (s) - (1 + 5)] = '\0';     /*    */
    fprintf (ftrace, "%s: id=%s pid=%05d (%s) ", progname, id, pid, s);
    fprintf (ftrace, fmt, arg);
    fprintf (ftrace, ": %s\n", sys_errlist[errno]);
    fclose (ftrace);
    exit (exitcode);
}

log (fmt, arg1, arg2, arg3)
char   *fmt, *arg1, *arg2, *arg3;
{
    time_t tm;
    char   *s;

    time (&tm);
    s = ctime (&tm) + 4;                /*    */
    s[strlen (s) - (1 + 5)] = '\0';     /*    */
    fprintf (ftrace, "%s: id=%s pid=%05d (%s) ", progname, id, pid, s);
    fprintf (ftrace, fmt, arg1, arg2, arg3);
    fprintf (ftrace, "\n");
    fflush (ftrace);
}

int phnum, phcur;       /*  ,   */
char *ph [64];          /*   64  */
initphone (phone)       /*    */
register char *phone;
{
    static char phbuf [MAXCFLINE];
    register char *p, *q;

    phnum = phcur = 0;
    strncpy (phbuf, phone, MAXCFLINE - 1);
    for (p = phbuf; q = strchr (p, '|'); p = q) {
	*q++ = '\0';
	ph [phnum++] = p;
    }
    ph [phnum++] = p;
}

char *curphone (next)   /*    */
{
    if (next && (++phcur == phnum)) phcur = 0;
    return (ph [phcur]);
}


void alarmed() {}
waitcarrier (line)  /*   */
char *line;
{
    register fd1 = -1;

    if (Debug)
	log ("wait CARRIER...", 0, 0, 0);
    term.c_cflag &= ~CLOCAL;
    ioctl (fd, TIOCSETA, &term);
    signal(SIGALRM, alarmed); alarm (90);
    fd1 = open (line, O_RDWR);
    alarm (0); signal (SIGALRM, SIG_DFL);
    close (fd1); errno = 0;
    return (fd1);
}

dtr (on)
register on;
{
    errno = 0;                                          /* paranoid */
    if (ioctl (fd, on ? TIOCSDTR : TIOCCDTR, 0) == -1)
	log ("TIOC%s failed: %s", on ? "SDTR" : "CDTR",
	    sys_errlist[errno], 0);                     /* paranoid */
    errno = 0;
}
dropdtr () {
    dtr (0); sleep (2);
    dtr (1); sleep (2);
}

/*
 * UTMP/WTMP :
 * 1)    :
 *  :UPPERCASE_ID   (OPENED)
 * 2)     LL  :
 *  :&UPPERCASE_ID  (CHECKED)
 * 3)    (dialup  1.5 LL):
 *  :lowercase_id   (CONNECTED)
 */

#define UTSIZE  (sizeof(struct utmp))
logwtmp (ut)
register struct utmp *ut;
{
    struct stat buf;
    register int fd;

    if (((fd = open (_PATH_WTMP, O_WRONLY|O_APPEND, 0)) >= 0) &&
	    (fstat(fd, &buf) == 0)) {
	if (write (fd, ut, UTSIZE) != UTSIZE)
	    ftruncate (fd, buf.st_size);
	close (fd);
    }
}

logutmp (ut)
register struct utmp *ut;
{
    register int fd, wrok;
    struct utmp up;
    struct stat buf;

    if (((fd = open (_PATH_UTMP, O_RDWR)) < 0) || (fstat(fd, &buf) < 0))
	return(0);
    /*      utmp */
    for (wrok = 0; read (fd, &up, UTSIZE) == UTSIZE; ) {
	if (up.ut_name[0] && !strncmp (up.ut_line, ut -> ut_line, UT_LINESIZE))
	{                                       /*   */
	    lseek (fd, -(long)UTSIZE, SEEK_CUR);/*    */
	    if (wrok == 0) {                    /*    ? */
		write (fd, ut, UTSIZE);         /*  ... */
		wrok = 1;
	    }
	    else {                              /*    */
		bzero (&up, UTSIZE);            /*  */
		write (fd, &up, UTSIZE);
	    }
	}
    }
    /*    -    /etc/ttys */
    if ((wrok == 0) && (wrok = tty_slot (ut -> ut_line))) {
	lseek (fd, (long)(wrok * UTSIZE), SEEK_SET);
	write (fd, ut, UTSIZE);
    }
    /*    -     */
    if (wrok == 0) {
	if (buf.st_size % UTSIZE)
	    ftruncate (fd, UTSIZE * (buf.st_size / UTSIZE));
	lseek (fd, 0L, SEEK_END);
	write (fd, ut, UTSIZE);
    }
    close (fd);
}

tty_slot (name)
register char *name;
{
    register struct ttyent *ttyp;
    register int slot;

    setttyent ();
    for (slot = 1; ttyp = getttyent (); ++slot) {
	if (!strcmp (ttyp->ty_name, name)) {
	    endttyent ();
	    return (slot);
	}
    }
    endttyent ();
    return (0);
}

mark_line(l, n, type)
register char *l, *n;
{
    register char *p, *q;
    static char LINE [UT_LINESIZE];
    static char NAME [UT_LINESIZE];
    struct utmp ut;

    if ((LINE [0] == '\0') && type != IS_OPENED)
	return;

    switch (type) {
	case IS_OPENED:
	    if (*l = '/') l += sizeof ("/dev/") - 1; /*  :) */
	    strncpy (LINE, l, UT_LINESIZE);
	    strncpy (NAME, n, UT_NAMESIZE);
	    strncpy (ut.ut_line, LINE, UT_LINESIZE);
	    strncpy (ut.ut_host, "OPENED", UT_HOSTSIZE);
	    p = ut.ut_name;
	    *p++ = ':';   /*  __  */
	    for (q = NAME; (p < ut.ut_name + UT_NAMESIZE) && q; p++, q++) {
		*p = *q;
		if (islower (*p)) *p = toupper (*p);
	    }
	    break;
	case IS_CHECKED:
	    strncpy (ut.ut_host, "CHECKED", UT_HOSTSIZE);
	    strncpy (ut.ut_line, LINE, UT_LINESIZE);
	    p = ut.ut_name;
	    *p++ = ':';   /*  __  */
/****       *p++ = '&';   /*  __ */
	    for (q = NAME; (p < ut.ut_name + UT_NAMESIZE) && q; p++, q++) {
		*p = *q;
		if (islower (*p)) *p = toupper (*p);
	    }
	    break;
	case IS_CONNECTED:
	    strncpy (ut.ut_host, "CONNECTED", UT_HOSTSIZE);
	    strncpy (ut.ut_line, LINE, UT_LINESIZE);
	    p = ut.ut_name;
	    *p++ = ':';   /*  __  */
	    for (q = NAME; (p < ut.ut_name + UT_NAMESIZE) && q; p++, q++) {
		*p = *q;
		if (isupper (*p)) *p = tolower (*p);
	    }
	    break;
	case IS_CLOSED:
	    strncpy (ut.ut_line, LINE, UT_LINESIZE);
	    bzero (ut.ut_name, UT_NAMESIZE);
	    bzero (ut.ut_host, UT_HOSTSIZE);
	    break;

    }
    time (&ut.ut_time);
    logutmp (&ut);
    logwtmp (&ut);
}
