/*
 * /   LCK .
 *   UUCP KIAE    . alex
 */

#include <stdio.h>
#include "defs.h"
#include <sys/stat.h>
# define FAIL            -1
# define SUCCESS         0
# define SAME            0
# define MAXFULLNAME     255
# define NAMESIZE        255
# define CNULL           (char *) 0
# define LCKMODE 0444    /* File mode for _lock files */
# define MAXLOCKS 16     /* Maximum number of _lock files */

int Debug;
#define DEBUG(l, f, s) if (Debug >= l) fprintf(stderr, f, s); else
#define ASSERT(e, s1, s2, i1) if (!(e)) {perror("ASSERT:");panic(s1, s2, 1);}else



char *Lock_file[MAXLOCKS];
char *Lock_Directory = LOCKDIR;
int N_locks = 0;
char *malloc();

/*LINTLIBRARY*/

/*
 *	This routine will attempt to create a _lock file (file).
 *	It makes sure that the _lock file is valid if it already exists.
 *
 *	return codes:  SUCCESS  |  FAIL
 */
mk_lock(hfile)
char *hfile;
{
	register char *p;
	register int i;
	static char tempfile[NAMESIZE];
	char file[NAMESIZE];
	static int pid = -1;
	extern int errno;
	struct stat stdbuf;
	if ( p = strrchr(hfile,'/') )
	    hfile = ++p;

	if (pid < 0) {
		pid = getpid();
		sprintf(tempfile, "%s/LTMP.%d", Lock_Directory, pid);
	}
	sprintf(file, "%s/LCK..%s", Lock_Directory, hfile);
# ifdef LOCK_UPPER
	if ( strncmp("tty",hfile,3) == 0 )
	{
		/* [A-Z] -> [a-z] */
		file[strlen(file)-1] |= 040;
	}
# endif
	if ( stat(Lock_Directory,&stdbuf) < 0 )
	{
		register int i;
		i = umask(0);
		mkdir(Lock_Directory,0775);
		umask(i);
	}
	i = 0;
	while (one_lock(pid, tempfile, file) == -1) { /* _lock file exists */
		register int fd;
		fd = open(file, 0);
		if (fd >= 0) {
# ifdef LOCKASCII
			char spid[12];
			int upid, ret;
			ret = read(fd, spid, 12);
			close(fd);
			upid = atoi(spid);
			if (ret == 11 && ( kill(upid, 0) == 0
				|| errno != ESRCH))
				return FAIL; /* process is still running */
# else /* LOCK-BINARY */
			int upid, ret;
			ret = read(fd, &upid, sizeof upid);
			close(fd);
			if (ret == sizeof upid && (kill(upid, 0) == 0
				|| errno != ESRCH))
				return FAIL; /* process is still running */
# endif /*  */
		}
		DEBUG(1,"DEAD LOCK %s\n", file);
		(void) unlink(file);
		sleep(5);	/* avoid a possible race */
		ASSERT(i++ < 5, "CAN'T GET LOCKFILE", tempfile, errno);
	}

	for (i = 0; i < N_locks; i++) {
		if (Lock_file[i] == NULL)
			break;
	}
	ASSERT(i < MAXLOCKS, "TOO MANY LOCKS", CNULL, i);
	if (i >= N_locks)
		i = N_locks++;
	p = malloc((unsigned)(strlen(file)+1));
	ASSERT(p != NULL, "CAN NOT ALLOCATE FOR", file, 0);
	strcpy(p, file);
	Lock_file[i] = p;

	return SUCCESS;
}

/*
 *	remove all _lock files in list or name
 */
rm_lock(name)
register char *name;
{
	register int i;
	char file[MAXFULLNAME];

	if (name != NULL) {
		sprintf(file, "%s/LCK..%s", Lock_Directory, name);
# ifdef LOCK_UPPER
		if ( strncmp("tty",name,3) == 0 )
		{
			/* [A-Z] -> [a-z] */
			file[strlen(file)-1] |= 040;
		}
# endif
		name = file;
	}
  /*  INUSE   --  SV  
	else if ( pfree_tty )
		(*pfree_tty)();
 */

	for (i = 0; i < N_locks; i++) {
		if (Lock_file[i] == NULL)
			continue;
		if (name == NULL || strcmp(name, Lock_file[i]) == SAME) {
			unlink(Lock_file[i]);
			free(Lock_file[i]);
			Lock_file[i] = NULL;
		}
	}
}

/*
 *	makes _lock a name on behalf of pid. Tempfile must be in the same
 *	file system as name.
 */
one_lock(pid, tempfile, name)
int pid;
char *tempfile, *name;
{
	register int fd, ret;
	fd = creat(tempfile, LCKMODE);
	if (fd < 0) {
		DEBUG(1,"Can't creat temp file %s ", tempfile);
		DEBUG(1,"-- errno %d\n", errno);
		return FAIL;
	}
# ifdef LOCKASCII
	{
		char spid[12];
		sprintf(spid, "%10d\n", pid);
		ret = write(fd, spid, 11);
		(void) close(fd);
		if ( ret != 11)
		{
			DEBUG(1,"Temp file write failed -- errno %d\n", errno);
			(void) unlink(tempfile);
			return FAIL;
		}
	}
# else  /* LOCK-BINARY */
	ret = write(fd, (char *)&pid, sizeof(int));
	(void) close(fd);
	if (ret != sizeof(int))
	{
		DEBUG(1,"Temp file write failed -- errno %d\n", errno);
		(void) unlink(tempfile);
		return FAIL;
	}
# endif /*  */
	if (link(tempfile, name) < 0) {
		(void) unlink(tempfile);
		return FAIL;
	}
	unlink(tempfile);
	return SUCCESS;
}

