#ifndef lint
static char *rcsid = "$Header: /usr2/olg/new/slipdist/sldial/RCS/if.c,v 1.1 1992/03/26 01:09:28 olg Exp olg $";
#endif


/*
 * $Log: if.c,v $
 * Revision 1.1  1992/03/26  01:09:28  olg
 * Initial revision
 *
 *
 */

#include "defs.h"

if_down (dev)
	char *dev;
{
	struct ifreq ifreq;

	if (dev == NULL || *dev == '\0')
		return;
	strcpy (ifreq.ifr_name, dev);
	if (ioctl(sock, SIOCGIFFLAGS, (char *)&ifreq) < 0) {
        	panic ("ioctl (get interface %s flags)", dev, 1);
        }
	ifreq.ifr_flags &= ~IFF_UP;	
	if (ioctl(sock, SIOCSIFFLAGS, (char *)&ifreq) < 0) {
        	panic ("ioctl (set interface %s flags down)", dev, 1);
        }
}

if_up (dev, src, dst, mask, sflags, cflags)
	char *dev;
	struct sockaddr_in *src, *dst, *mask;
	u_short sflags, cflags;
{
	struct ifreq ifreq;
	struct ifaliasreq adreq;

	if (dev == NULL || *dev == '\0')
		return;
    /* clear previous addr for interface */
	bzero ((caddr_t) &ifreq, sizeof (ifreq));
	strncpy (ifreq.ifr_name, dev, sizeof (ifreq.ifr_name));
	if ((ioctl(sock, SIOCDIFADDR, (char *)&ifreq) < 0) &&
	    errno != EADDRNOTAVAIL) {	/* means no previous addr for interface */
       		panic ("ioctl (SIOCDIFADDR %s)", dev, 1);
        } 
    /* set new addr */
	bzero ((caddr_t) &adreq, sizeof (adreq));	
	strncpy (adreq.ifra_name, dev, sizeof (adreq.ifra_name));
	bcopy ((caddr_t) src,  (caddr_t) &adreq.ifra_addr, sizeof (*src));
	bcopy ((caddr_t) dst,  (caddr_t) &adreq.ifra_broadaddr, sizeof (*dst));
	bcopy ((caddr_t) mask, (caddr_t) &adreq.ifra_mask, sizeof (*mask));
	if (ioctl(sock, SIOCAIFADDR, (char *)&adreq) < 0) {
		switch (errno) {

		case EEXIST:
			break;

		default:
        		panic ("ioctl (SIOCAIFADDR %s)", dev, 1);
		}
        } 
    /* set zero metric */
	ifreq.ifr_metric = 0;
	if (ioctl(sock, SIOCSIFMETRIC, (char *)&ifreq) < 0) {
        	panic ("ioctl (set interface %s metric)", dev, 1);
        }
   /* set flags for interface */
	if (ioctl(sock, SIOCGIFFLAGS, (char *)&ifreq) < 0) {
        	panic ("ioctl (get interface %s flags up)", dev, 1);
        }
	ifreq.ifr_flags |= IFF_UP | sflags;
	ifreq.ifr_flags &= ~cflags;
	if (ioctl(sock, SIOCSIFFLAGS, (char *)&ifreq) < 0) {
        	panic ("ioctl (set interface %s flags up)", dev, 1);
        }
}

