/*-
 * Copyright (c) 1993, 1994 RELCOM Corp. Igor Chechik.
 */

/*	BSDI $Id: if_slvar.h,v 1.5 1993/03/08 19:52:33 karels Exp $	*/

/*
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)if_slvar.h	7.7 (Berkeley) 5/7/91
 *
 * $Header: /bsdi/MASTER/BSDI_OS/sys/net/if_slvar.h,v 1.5 1993/03/08 19:52:33 karels Exp $
 */

/*
 * Definitions for SLIP interface data structures
 * 
 * (This exists so programs like slstats can get at the definition
 *  of sl_softc.)
 */

#define SLIPLINES           16      /* ??? */
struct sl_line {            /* structure per tty line attached with dev */
	struct  sl_softc   *l_sc;   /* pointer to sl_softc [] */
	struct  sl_line    *l_nxt;  /* pointer to next msline in linked list */
	struct  tty        *l_ttyp; /* pointer to tty structure */
#ifdef INET                         /* XXX */
	struct  slcompress *l_comp; /* tcp compression data */
#endif
	u_char *l_mp;           /* pointer to next available buf char */
	u_char *l_ep;           /* pointer to last available buf char */
	u_char *l_buf;          /* input buffer */
	u_int   l_bytessent;
	u_int   l_bytesrcvd;
	u_int   l_pktin;
	u_int   l_pktout;
	long    l_lasttime;     /* last time a char arrived */
	long    l_starttime;    /* last time a char arrived */
	u_int   l_keepalive;    /* time to decide link hang */
	u_int   l_outfill;      /* time to send ESCAPE when output idle */
	long    l_abortcount;   /* number of abort esacpe chars */
	int     l_keepcnt;      /* number of waiting keepalives */
	u_int   l_flags;        /* see below */
};

/* internal flags for sl_line structure */
#define SC_KEEPTEST     0x010   /* keepalive receive test */
#define SC_KEEPUP       0x020   /* line is up - keeptest OK */
#define SC_KEEPWAIT     0x040   /* wait a number of keepalives */
#define SC_ESCAPE       0x100   /* have been sent an abort request */
#define SC_ABORT        0x200   /* have been sent an abort request */
#define SC_OUTWAIT      0x400   /* waiting for output fill */

struct sl_softc {
	struct	ifnet sc_if;		/* network-visible interface */
	struct	ifqueue sc_fastq;	/* interactive output queue */
	caddr_t	sc_bpf;			/* bpf magic cookie */
	struct  sl_line *sc_lst;        /* the current line in list */
	int     sc_num;                 /* the current number of active lines */
};

struct sl_attach {
	int     sl_unit;        /* interface unit */
	int     sl_fill;        /* outfill timeout (sec) */
	int     sl_keep;        /* keepalive timeout (sec) */
	int     sl_cnt;         /* number of waiting FRAME_END's */
};

/* visible flags sc_if.if_flags */
#define SC_COMPRESS     IFF_LINK0  /* compress TCP traffic */
#ifdef BSD_1_0
#define SC_NOICMP       IFF_LINK1  /* supress ICMP traffic */
#define SC_AUTOCOMP     IFF_LINK2  /* auto-enable TCP compression */
#define SC_BPFILTER     IFF_LINK3  /* enable bpfilter */
#define LLC_MASK        (IFF_LINK0|IFF_LINK1|IFF_LINK2|IFF_LINK3)
#else
#define SC_AUTOCOMP     IFF_LINK1  /* auto-enable TCP compression */
#define SC_BPFILTER     IFF_LINK2  /* enable bpfilter */
#define LLC_MASK        (IFF_LINK0|IFF_LINK1|IFF_LINK2)
#endif

/* this stuff doesn't belong here... */
#define SLIOCATTACH     _IOW('t', 80, int)      /* attach unit by num */
#define SLIOCDETACH     _IOR('t', 81, int)      /* detach unit */
#define SLIOCGUNIT      _IOR('t', 82, int)      /* get slip unit number */
#define SLIOCGFLAGS     _IOR('t', 83, int)      /* get line flags */
#define SLIOCSFLAGS     _IOW('t', 84, int)      /* set line flags */
#define SLIOCSKEEPAL    _IOW('t', 85, int)      /* set keepalive */
#define SLIOCSOUTFILL   _IOW('t', 86, int)      /* set out fill time */
#define SLIOCGKEEPAL    _IOR('t', 87, int)      /* get keepalive time */
#define SLIOCGOUTFILL   _IOR('t', 88, int)      /* get out fill time */
#define SLIOCGETMTU     _IOR('t', 89, short)    /* get max trans unit */
#define SLIOCSETMTU     _IOW('t', 90, short)    /* set max trans unit */
#define SLIOCATTW       _IOW('t', 91, struct sl_attach) /* complex attach */
#define SLIOCWAIT       _IOW('t', 92, struct sl_attach) /* complex attach */

/* nor does this stuff; put it in slip.h later. */

/*
 * definitions of the pseudo- link-level header attached to slip
 * packets grabbed by the packet filter (bpf) traffic monitor.
 */
#define SLIP_HDRLEN 16

#define SLX_DIR 0
#define SLX_CHDR 1
#define CHDR_LEN 15

#define SLIPDIR_IN 0
#define SLIPDIR_OUT 1


