/*
 * support.h
 * Various support routines.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __support_h
#define	__support_h

/*
 * Some systems need specific exports for funcions to be shared.
 */
#if defined(__WIN32__)

#if defined(__BORLANDC__)
#define EXPORT(t)	t __export
#define IMPORT(t)	extern t __import
#elif defined(__MSC)
#define EXPORT(t)	t __export
#define IMPORT(t)	extern __declspec(dllimport) t
#endif

#else
#define EXPORT(t)       t
#define IMPORT(t)       extern t
#endif

/* For user defined properties */
typedef struct _userProperty {
        char*                   key; 
        char*                   value; 
        struct _userProperty*   next;
} userProperty;

IMPORT(userProperty*) userProperties;

extern void		setProperty(void*, char*, char*);
extern void		classname2pathname(char*, char*);
extern struct _object*	makeJavaCharArray(char*, int);
extern long		do_execute_java_method(void*, object*, char*, char*, struct _methods*, int, ...);
extern object*		execute_java_constructor(void*, char*, classes*, char*, ...);
extern jlong		currentTime(void);

#endif
