/* slib.h
 * Macro'ise the shared library calls to be 'portable'.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __slib_h
#define __slib_h

#if defined(HAVE_DLFCN_H) 
#include <dlfcn.h>
#endif

#if defined(__WIN32__)
#define	dlinit()
#define dlopen(s, m)    LoadLibrary(s)
#define dlsym(l, s)     GetProcAddress(l, s)
#endif 

#if defined(HAVE_LIBDLD)
#define	dlinit()							\
        {								\
                static int init_dld = 0;				\
                if (init_dld == 0) {					\
                        init_dld = 1;					\
                        if (dld_init("/usr/local/bin/kaffe") != 0) {	\
                                return (-1);				\
                        }						\
                }							\
        }
#define dlopen(s, m)    !dld_link(s)
#define dlsym(l, s)     dld_get_func(s)
#endif

/* If we don't have an init function, define an empty one */
#if !defined(dlinit)
#define	dlinit()
#endif

#endif
