/*
 * lookup.h
 * Various lookup calls for resolving objects, methods, exceptions, etc.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __lookup_h
#define __lookup_h

struct _dispatchTable;

typedef struct _callInfo {
	int			in;
	int			out;
	struct _dispatchTable*	dtable;
	int			offset;
	int			idx;
	int			mtag;
	char*			type;
	char			rettype;
} callInfo;

typedef struct _createInfo {
	struct _classes*	class;
} createInfo;

typedef struct _fieldInfo {
	struct _classes*	class;
	int			size;
	int			offset;
	bool			isref;
} fieldInfo;

typedef struct _exceptionInfo {
	int			handler;
	struct _classes*	class;
} exceptionInfo;

void	getMethodSignatureClass(constIndex, constants*, callInfo*);
void	getClass(constIndex, constants*, createInfo*);
void	getField(constIndex, bool, constants*, fieldInfo*);
methods* findMethod(classes*, strpair*);
void	findExceptionInMethod(uintp, classes*, exceptionInfo*);
bool	findExceptionBlockInMethod(uintp, classes*, methods*, exceptionInfo*);
methods* findMethodFromPC(uintp);

#endif
