/* codeproto.h
 * Code prototypes.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __codeproto_h
#define __codeproto_h

void _start_basic_block(uintp, uintp);
void _end_basic_block(uintp, uintp);

void move_long_const(slots*, jlong);
void move_double_const(slots*, jdouble);

void add_int(slots*, slots*, slots*);
void sub_int(slots*, slots*, slots*);
void mul_int(slots*, slots*, slots*);
void div_int(slots*, slots*, slots*);
void rem_int(slots*, slots*, slots*);
void and_int(slots*, slots*, slots*);
void or_int(slots*, slots*, slots*);
void xor_int(slots*, slots*, slots*);

void ashr_int(slots*, slots*, slots*);
void lshr_int(slots*, slots*, slots*);
void lshl_int(slots*, slots*, slots*);

void cmp_int(slots*, slots*, slots*);

void pusharg_int(slots*);
void pusharg_int_const(jint);
void pusharg_long(slots*);
void pusharg_float(slots*);
void pusharg_double(slots*);
void popargs(int);

void return_int(slots*);
void return_long(slots*);
void return_float(slots*);
void return_double(slots*);

void call_ref(uintp);
void softcall_badarrayindex(void);

label* build_code_ref(uint8*, uintp);

#endif
