/*
 * external.c
 * Handle method calls to other languages.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#define	DBG(s)

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#if defined(MACH_O_RLD_H)
#include <mach-o/rld.h>
#endif
#include "gtypes.h"
#include "access.h"
#include "object.h"
#include "constants.h"
#include "classMethod.h"
#include "slots.h"
#include "external.h"
#include "errors.h"
#include "exception.h"
#include "slib.h"
#include "paths.h"
#if defined(NO_SHARED_LIBRARIES)
#include "../lib/external_wrappers.h"
#endif

#if defined(NO_SHARED_LIBRARIES)
#define	STUB_PREFIX		""
#define	STUB_PREFIX_LEN		0
#define	STUB_POSTFIX		""

/*
 * Some version of dlsym need an underscore, some don't.
 */
#elif defined(INTERPRETER)

#if defined(HAVE_DYN_UNDERSTORE)
#define	STUB_PREFIX		"_Kaffe_"
#define	STUB_PREFIX_LEN		7
#else
#define	STUB_PREFIX		"Kaffe_"
#define	STUB_PREFIX_LEN		6
#endif
#define	STUB_POSTFIX		"_stub"

#elif defined(TRANSLATOR)

#if defined(HAVE_DYN_UNDERSTORE)
#define	STUB_PREFIX		"_"
#define	STUB_PREFIX_LEN		1
#else
#define	STUB_PREFIX		""
#define	STUB_PREFIX_LEN		0
#endif
#define	STUB_POSTFIX		""

#endif

static void* libHandle[MAXLIBS];
char libraryPath[MAXLIBPATH];

void
initNative(void)
{
#if !defined(NO_SHARED_LIBRARIES)
	char lib[MAXLIBPATH];
	char* ptr;
	char* nptr;

	ptr = getenv(LIBRARYPATH);
	if (ptr == 0) {
#if defined(DEFAULT_LIBRARYPATH)
		ptr = DEFAULT_LIBRARYPATH;
#else
		fprintf(stderr, "No library path set.\n");
		return;
#endif
	}
	strcpy(libraryPath, ptr);

	dlinit();

	/* Find the default library */
	for (ptr = libraryPath; ptr != 0; ptr = nptr) {
		nptr = strchr(ptr, PATHSEP);
		if (nptr == 0) {
			strcpy(lib, ptr);
		}
		else {
			strncpy(lib, ptr, nptr - ptr);
			lib[nptr-ptr] = 0;
			nptr++;
		}
		strcat(lib, DIRSEP);
		strcat(lib, NATIVELIBRARY);
		strcat(lib, LIBRARYSUFFIX);

		if (loadNativeLibrary(lib) == 0) {
			return;
		}
	}
	fprintf(stderr, "Failed to locate native library in path:\n");
	fprintf(stderr, "\t%s\n", libraryPath);
	fprintf(stderr, "Aborting.\n");
	fflush(stderr);
	exit(1);
#endif
}

int
loadNativeLibrary(char* lib)
{
#if !defined(NO_SHARED_LIBRARIES)
	int i;
	int j;
#if defined(NeXT)
	const char* filenames[2];
	struct mach_header* new_header;
	
	filenames[0]=lib;
	filenames[1]=NULL;
#endif

	/* Find a library handle */
	for (i = 0; i < MAXLIBS; i++) {
		if (libHandle[i] == 0) {
			goto open;
		}
	}
	return (-1);

	/* Open the library */
	open:
#if defined(NeXT)
	libHandle[i] = rld_load(NULL,&new_header,filenames,NULL);
#else
	libHandle[i] = dlopen(lib, 1);
#endif
	if (libHandle[i] == 0) {
		return (-1);
	}

	/* Eliminate duplicates */
	for (j = 0; j < i; j++) {
		if (libHandle[j] == libHandle[i]) {
			libHandle[i] = 0;
			break;
		}
	}

#endif
	return (0);
}

void
native(methods* m)
{
	char stub[MAXSTUBLEN];
	char* ptr;
	int i;
	void* func;

	/* Construct the stub name */
	strcpy(stub, STUB_PREFIX);
	ptr = m->class->name;
	for (i = STUB_PREFIX_LEN; *ptr != 0; ptr++, i++) {
		if (*ptr == '/') {
			stub[i] = '_';
		}
		else {
			stub[i] = *ptr;
		}
	}
	stub[i] = '_';
	stub[i+1] = 0;
	strcat(stub, m->pair->s1);
	strcat(stub, STUB_POSTFIX);

DBG(	printf("Method = %s.%s%s\n", m->class->name, m->pair->s1, m->pair->s2);)
DBG(	printf("Native stub = '%s'\n", stub);fflush(stdout);		)

#if !defined(NO_SHARED_LIBRARIES)
#if !defined(NeXT)
	/* Find the native method */
	for (i = 0; i < MAXLIBS && libHandle[i] != 0; i++) {
		func = dlsym(libHandle[i], stub);
		if (func != 0) {
			/* Fill it in */
			m->ncode = func;
			return;
		}
	}
#else
	rld_lookup(NULL,stub,&func);
	if (func != 0) {
		/* Fill it in */
		m->ncode = func;
		return;
	}
#endif
#else
	/*
	 * If we don't support shared libraries, fall back on the
	 * wrapped up native method table.
	 */
	for (i = 0; native_name[i] != 0; i++) {
		if (strcmp(native_name[i], stub) == 0) {
			m->ncode = native_func[i];
			return;
		}
	}
#endif
	fprintf(stderr, "Failed to locate native function:\n\t%s.%s%s\n", m->class->name, m->pair->s1, m->pair->s2);
	fflush(stderr);

        throwException(UnsatisfiedLinkError);
}

/*
 * Return the library path.
 */
char*
getLibraryPath(void)
{
	return (libraryPath);
}
