/*
 * exception.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __exception_h
#define __exception_h

typedef struct _jexception {
	u4	start_pc;
	u4	end_pc;
	u4	handler_pc;
	char*	catch_type;
} jexception;

#if defined(INTERPRETER)
#include <setjmp.h>
struct _object;
struct _methods;
typedef struct _vmException {
	u4			pc;
	struct _object*		mobj;
	struct _methods*	meth;
	jmp_buf			jbuf;
	struct _vmException*	prev;
} vmException;
#endif

struct _exceptionFrame;
struct _object;

void		throwException(struct _object*);
void		throwExternalException(struct _object*);
struct _object*	buildStackTrace(struct _exceptionFrame*);

#if defined(__WIN32__)
#define SIG_T   void(*)()
#else
#define SIG_T   void*
#endif

#endif
