/*
 * m68k/threads.h
 * m68k thread handling.
 *
 * Copyright (c) 1996 Matthias Hopf <mshopf@informatik.uni-erlangen.de>
 *
 * Permission granted for Tim Wilkinson to include this source in his
 * Kaffe system, Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef __m68k_threads_h
#define __m68k_threads_h

/**/
/* Thread handling */
/**/

/* NOTE! a5 is asumed to be the frame pointer (only for frame counting). */

/*
 * Stack of waiting thread:
 *       +  12   pc  (return address)
 *       +  8    a4  ()
 *       +  4    a5  (frame pointer)
 *       +  0    a6
 * remaining registers are scratched.
 */

#define USE_INTERNAL_THREADS

#define THREADSTACKSIZE         (32 * 1024)

#define M68K_THREADSWITCH(to, from)                      \
		    asm("                                \
		    pea 1f                               \n\
		    move.l a4, -(a7)                     \n\
		    move.l a5, -(a7)                     \n\
		    move.l a6, -(a7)                     \n\
		    move.l a7, (%0)                      \n\
		    move.l %1, a7                        \n\
		    move.l (a7)+,a6                      \n\
		    move.l (a7)+,a5                      \n\
		    move.l (a7)+,a4                      \n\
		    rts                                  \n\
		 1: nop                                " \
		    : : "a" (& from->restorePoint), "a" (to->restorePoint) : "cc","memory", \
			"d0","d1","d2","d3","d4","d5","d6","d7","a0","a1","a2","a3")

#define M68K_THREADINIT(to, func)                        \
		  asm("                                  \
		  moveq #0, d0                           \n\
		  move.l %2, -(%0)                       \n\
		  move.l d0, -(%0)                       \n\
		  move.l d0, -(%0)                       \n\
		  move.l d0, -(%0)                     " \
		  : "=a" (to->restorePoint) : "0" (to->stackEnd), "g" (func) : "d0", "cc")

#define M68K_THREADINFO(ee)                                     \
		do {                                            \
			void** ptr;                             \
			int i;                                  \
			asm("move.l a5, %0" : "=r" (ptr));      \
			for (i = 0; i != 2; i++) {              \
				ptr = (void**)*ptr;             \
			}                                       \
			(ee)->restorePoint = 0;                 \
			(ee)->stackEnd = (void*)ptr;            \
			(ee)->stackBase = (ee)->stackEnd - threadStackSize;\
			(ee)->flags = THREAD_FLAGS_NOSTACKALLOC;\
		} while(0)

#define M68K_THREADFRAMES(tid, cnt)                             \
		do {                                            \
			void** ptr;                             \
			cnt = 0;                                \
			if (tid == currentThread) {             \
				asm("move.l a5,%0" : "=r" (ptr));\
			}                                       \
			else {                                  \
				ptr = ((void***)tid->PrivateInfo->restorePoint)[1];\
			}                                       \
			while (*ptr != 0) {                     \
				cnt++;                          \
				ptr = (void**)*ptr;             \
			}                                       \
		} while (0)

#define THREADSWITCH(to, from)    M68K_THREADSWITCH(to, from)
#define THREADINIT(to, func)      M68K_THREADINIT(to, func)
#define THREADINFO(ee)            M68K_THREADINFO(ee)
#define THREADFRAMES(tid,cnt)     M68K_THREADFRAMES(tid, cnt)

#endif
