/*
 * i386/win32/bc/md-thread.c
 * Windows'95 (Borland C) i386 thread specific functions.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include "config.h"
#include "gtypes.h"
#include "object.h"
#include "thread.h"
#include "md.h"

extern thread* currentThread;

void
threadSwitch(ctx* to, ctx* from)
{
	asm {
		lea esi,t1
		push esi
		mov esi,from
		mov edi,to
		pushad
		mov DWORD PTR [esi.restorePoint],esp
		mov esp,DWORD PTR [edi.restorePoint]
		popad
		ret
	t1:	nop

	}
}

void
threadInit(ctx* to, void* func)
{
	asm {
		mov esi, func
		mov edi, to
		mov edi, [edi.stackEnd]
		mov DWORD PTR [edi-4],esi
		mov DWORD PTR [edi-8],0
		mov DWORD PTR [edi-12],0
		mov DWORD PTR [edi-16],0
		mov DWORD PTR [edi-20],0
		mov DWORD PTR [edi-24],0
		mov DWORD PTR [edi-28],0
		mov DWORD PTR [edi-32],0
		mov DWORD PTR [edi-36],0
	}
	to->restorePoint = to->stackEnd - 36;
}

void
threadInfo(ctx* ee)
{
	void** sptr;
	int i;
	asm {
		mov sptr,ebp
	}
	for (i = 0; i != 4; i++) {
		sptr = (void**)*sptr;
	}
	ee->restorePoint = 0;	
	ee->stackEnd = (uint8*)sptr;
	ee->stackBase = ee->stackEnd - threadStackSize;
	ee->flags = THREAD_FLAGS_NOSTACKALLOC;
}

int
threadFrames(thread* tid)
{
	void** sptr;
	int cnt = 0;
	if (tid == currentThread) {
		asm {
			mov sptr,ebp
		}
	}
	else {
		sptr = ((void***)tid->PrivateInfo->restorePoint)[2];
	}
	while (*sptr != 0) {
		cnt++;
		sptr = (void**)*sptr;
	}
	return (cnt);
}
