/*
 * java.lang.Thread.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <native.h>
#include "java.lang/Thread.h"
#include "java.lang/ThreadGroup.h"
#include "../../kaffevm/gtypes.h"
#include "../../kaffevm/thread.h"

struct Hjava_lang_Thread*
java_lang_Thread_currentThread()
{
	return ((struct Hjava_lang_Thread*)currentThread);
}

/*
 * Yield processor to another thread of the same priority.
 */
void
java_lang_Thread_yield()
{
	yieldThread();
}

/*
 * Put current thread to sleep for a time.
 */
void
java_lang_Thread_sleep(long long time)
{
	sleepThread(time);
}

/*
 * Start this thread running.
 */
void
java_lang_Thread_start(struct Hjava_lang_Thread* this)
{
	startThread((thread*)this);
}

/*
 * Is this thread alive?
 */
long /* bool */
java_lang_Thread_isAlive(struct Hjava_lang_Thread* this)
{
	return (aliveThread((thread*)this));
}

/*
 * Number of stack.  One for the moment.
 */
long
java_lang_Thread_countStackFrames(struct Hjava_lang_Thread* this)
{
	return (framesThread((thread*)this));
}

/*
 * Change thread priority.
 */
void
java_lang_Thread_setPriority0(struct Hjava_lang_Thread* this, long prio)
{
	setPriorityThread((thread*)this, prio);
}

/*
 * Stop a thread in its tracks.
 */
void
java_lang_Thread_stop0(struct Hjava_lang_Thread* this, struct Hjava_lang_Object* obj)
{
	killThread((thread*)this);
}

void
java_lang_Thread_suspend0(struct Hjava_lang_Thread* this)
{
	suspendThread((thread*)this);
}

void
java_lang_Thread_resume0(struct Hjava_lang_Thread* this)
{
	resumeThread((thread*)this);
}
