/*
 * object.h
 * Object representation.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __object_h
#define __object_h

#include "gtypes.h"

struct _methodTable;
struct _classes;
struct _thread;
						/* Lock info */
typedef struct _syncObject {
	struct _thread*		holder;
	int			count;
	struct _thread*		muxWaiters;
	struct _thread*		cvWaiters;
} syncObject;

typedef struct _object {
	struct _methodTable*	mtable;
	uint32			idx;
	uint32			size;
	syncObject		lock;
	char			data[0];
} object;

#define	OBJECT_MTABLE		0
#define	OBJECT_IDX		4
#define	OBJECT_SIZE		8
#define	OBJECT_DATA		28

struct _classes;

object*			alloc_object(struct _classes*, bool);
struct _classes*	alloc_class(void);
object*			alloc_array(int, int);
object*			alloc_objectarray(int, char*);
object*			alloc_multiarray(int*, char*);

#endif
