/*
 *  isis_globals.h,v 1.11 1993/01/07 22:39:23 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990, 1991, 1992 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#ifndef _globals_h
#define _globals_h

#include "isis.h"

#ifndef EXTERN
#define EXTERN extern
#endif

EXTERN  RoutingModuleState              routingModuleState;

/*
 *	The ID of this intermediate system 
 */
EXTERN SystemID6		systemID;

/*
 *	The area addresses configured for this system
 */
EXTERN AreaAddrList	systemAreaAddrs;

/*
 *	Maximum size of L1 and L2 LSPs and SNPs originated by this
 *	system.
 */
EXTERN u_short 	origL1LSPBufSize;
EXTERN u_short 	origL2LSPBufSize;
EXTERN u_short	dataLinkBlocksize;	/* TODO: on per circuit ? */

/*
 *	Type of system. Should only have value L1IS or L2IS
 */
EXTERN SystemType	systemType;

/*
 *	Holding timer (in seconds)
 */
EXTERN u_short	sysHoldingTimer;

/*
 *	Rate (in seconds) for transmitting ISH and IIH pdus
 */
EXTERN u_short  sysISHInterval;                 /* system wide default */
EXTERN u_short  sysIIHInterval;                 /* system wide default */
EXTERN u_short  sysDRIIHInterval;               /* for designated router */
EXTERN u_short  sysPollESHelloRate;
EXTERN u_short  sysDefaultESHelloTimer;

/*
 *	Parameters which control the flooding and generation of LSPs
 */
EXTERN u_short	minLSPGenInterval;		/* min time between generations of an LSP */
EXTERN u_short	maxLSPGenInterval;		/* max time between generations of an LSP */
EXTERN u_short	minBLSPXmitInterval;	/* transmission on broadcast circuit */
EXTERN u_short	minLSPXmitInterval;		/* transmission on pt 2 pt circuit */
EXTERN u_short	BLSPThrottle;			/* max # of LSPs to xmit per circuit
										   per minBLSPXmitInterval */
EXTERN u_short	maximumAge;				/* number of seconds fore LSP expired*/
EXTERN u_short	completeSNPInterval;
EXTERN u_short	partialSNPInterval;
EXTERN u_short	zeroAgeLifetime;
EXTERN u_short  waitingTime;                    /* time to stay in overload state */

#define	minBroadcastLSPXmitInterval	33 /* milliseconds */

/*
 *	The list of circuits configured into the system
 */
EXTERN CircuitEntry	*circuitList[MaximumCircuits];

/*
 *	Logging device
 */
EXTERN Logger debugLog;
EXTERN int		dumpDBinterval;

/*
 *	LSPs for this system
 */
LSPGroup	*L1LSP, *L2LSP;
AgeList		*normalLSPAge, *deletedLSPAge;

/*
 *	Multicast addresses
 */
EXTERN MACAddress	AllL1ISmac, AllL2ISmac, AllESmac;

/*
 * Our task (whatever it is at the time).
 */
EXTERN task *isis_task;

/* 
 * Preferences for gated (L1 higher preference than L2).
 */
EXTERN pref_t isis_preference[3];

/* 
 * Mode of operation (set by parser).
 */
EXTERN int ip_supported;
EXTERN int clnp_supported;

/*
 * Import and export policy (set by parser).
 */
EXTERN adv_entry *isis_import_list;
EXTERN adv_entry *isis_export_list;

#endif /* _globals_h */


/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3
 * 
 * 	Copyright (c) 1990,1991,1992,1993 by Cornell University
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * 	Authors:
 * 
 * 		Jeffrey C Honig <jch@gated.cornell.edu>
 * 		Scott W Brim <swb@gated.cornell.edu>
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */
