TITLE	FNFS Status Display
SUBTTL	Specifics
PAGE	62,132
NAME	FNFSStat

COMMENT	*

	Agricon International Inc.	David C. Brown IV	May 25, 1993

	This program is intended to obtain the data on packets transmitted
	and received by the FNFS program. It then prints a list of the
	success and failure of such packets.

	FNFS needs a pointer to the storage space in ES:DI and then it must
	be called via an interrupt through the DOS multiplex interrupt fct.

	*

;****** Manfiest constants ***************************************************
;*****************************************************************************

lf	equ	0ah
cr	equ	0dh

MPXISR	equ	2fh
EXIT	equ	4ch
DOSCALL	equ	21h

;****** Structures & Records *************************************************
;*****************************************************************************

stattab	STRUC
rpcfail	dw	0	; # RPC failures since startup (RX)
rpcxidf	dw	0	; # bad RPC exchange ID's since startup (RX)
udpbsum	dw	0	; # bad UDP checksums since startup (RX)
udpblen	dw	0	; # incorrect UDP packet lengths since startup (RX)
udptot	dw	0	; Total # UDP packets RECEIVED since startup
ipbdsum	dw	0	; # bad IP checksums since startup (Frags or complete)
ipfrgs	dw	0	; # IP fragments RECEIVED since startup
ipbdlen	dw	0	; # incorrect IP packet lengths since startup (RX)
rxfails	dw	0	; Total failures to receive packet (timeouts)
txfails	dw	0	; Total transmission failures (driver rejects)
sndfrgs	dw	0	; # IP fragments SENT since startup
sndip	dw	0	; # IP packets SENT since startup
statptr	dd	0	; FAR pointer to 256 byte function call count table
stattab	ENDS

;****** Segments *************************************************************
;*****************************************************************************

Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
BUFFER	ENDS

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
fnfsstat	stattab	<>

rpcstr	db	cr,lf,'***** RPC Errors:         ',0
rpcstr2	db	cr,lf,'      RPC bad exchange ID:',0
udpstr	db	cr,lf,'***** UDP packets:',cr,lf,'      Bad checksums: ',0
udpstr2	db	'   bad lengths: ',0
udpstr3	db	'   Total UDP packets: ',0
ipstr	db	cr,lf,'***** IP packets:',cr,lf,'      Bad checksums: ',0
ipstr2	db	'   Fragmented packets: ',0
txrxstr	db	cr,lf,'***** Transmit/receive failures: ',0
sndfrg	db	cr,lf,'***** Transmitted IP fragments: ',0
sndips	db	cr,lf,'***** Total IP packets sent: ',0
Resdata	ENDS

Stack	SEGMENT	WORD	STACK	'STACK'
	dw	2048 dup (?)
Stack	ENDS

extrn	barfwrd:near,barflin:near,barfchr:near,barflf:near

Restext	SEGMENT	PARA	PUBLIC	'TEXT'

	ASSUME	cs:ResGroup,ds:ResGroup,ss:Stack,es:nothing

main	PROC	NEAR
	mov	di,ResGroup
	mov	ds,di
	mov	es,di
	lea	di,[fnfsstat]
	mov	ax,1169h
	int	MPXISR

	lea	ax,[rpcstr]
	push	ax
	call	barflin
;push	[fnfsstat].rpcfail
mov	ax,[fnfsstat].rpcfail
	call	barfwrd
	lea	ax,[rpcstr2]
	push	ax
	call	barflin
;push	[fnfsstat].rpcxidf
mov	ax,[fnfsstat].rpcxidf
	call	barfwrd

	lea	ax,[udpstr]
	push	ax
	call	barflin
;push	[fnfsstat].udpbsum
mov	ax,[fnfsstat].udpbsum
	call	barfwrd
	lea	ax,[udpstr2]
	push	ax
	call	barflin
;push	[fnfsstat].udpblen
mov	ax,[fnfsstat].udpblen
	call	barfwrd
	lea	ax,[udpstr3]
	push	ax
	call	barflin
;push	[fnfsstat].udptot
mov	ax,[fnfsstat].udptot
	call	barfwrd

	lea	ax,[ipstr]
	push	ax
	call	barflin
;push	[fnfsstat].ipbdsum
mov	ax,[fnfsstat].ipbdsum
	call	barfwrd
	lea	ax,[udpstr2]
	push	ax
	call	barflin
;push	[fnfsstat].ipbdlen
mov	ax,[fnfsstat].ipbdlen
	call	barfwrd
	lea	ax,[ipstr2]
	push	ax
	call	barflin
;push	[fnfsstat].ipfrgs
mov	ax,[fnfsstat].ipfrgs
	call	barfwrd

	lea	ax,[txrxstr]
	push	ax
	call	barflin
;push	[fnfsstat].rxfails
mov	ax,[fnfsstat].rxfails
	call	barfwrd
	mov	al,'/'
	call	barfchr
;push	[fnfsstat].txfails
mov	ax,[fnfsstat].txfails
	call	barfwrd

	lea	ax,[sndfrg]
	push	ax
	call	barflin
;push	[fnfsstat].sndfrgs
mov	ax,[fnfsstat].sndfrgs
	call	barfwrd
	lea	ax,[sndips]
	push	ax
	call	barflin
;push	[fnfsstat].sndip
mov	ax,[fnfsstat].sndip
	call	barfwrd

	call	barflf

mov	ax,word ptr [fnfsstat+2].statptr	; Just print out pointer
call	barfwrd					; to stats table.
mov	ax,word ptr [fnfsstat].statptr
call	barfwrd
call	barflf

;lea	ax,[sepstr]				; Dump out entire stats table
;push	ax
;call	barflin
;les	di,[fnfsstat].statptr
;mov	cx,256
;show:	lodsb
;call	barfhex
;loop	show
;call	barflf

	xor	ax,ax
	mov	ah,EXIT
	int	DOSCALL
main	ENDP
Restext	ENDS
	END	main
