TITLE	PC support of NFS
SUBTTL	RPC interface level
PAGE	60,132
NAME	RPClow

COMMENT	@

	Agricon International Inc	David C. Brown IV	October 21,1992

	See files COPYING and COPYWRT for copyright information. Copyright (C)
	Agricon International Inc. 1993

	The idea with these procedures is to provide the link between the local
	high-level calls and the high-level network layers. The next level down
	worries about the packet interfaces and the fields needed to get the
	packet sent or see if it was valid. Here we simply resolve the destination
	addresses and ports. We map the given data into a series of calls and
	then take the replies and pass them back up. Later there may be some
	intelligence to move data to different requestors. Presently we just
	deal with a single atomic request/reply transaction.

	@

;***** Equates *****************************************************************
;*******************************************************************************

;***** Manifest constants ******************************************************

PMAPSRC	equ	69h	; the port we are using to transmit

DOSPRT	equ	9
DOSCALL	equ	21h

cr	equ	0dh
lf	equ	0ah

;***** RPC constants **********************************************************

RPCTX		equ	0	; for RPC calls TO a target
RPCRX		equ	2	; Incoming RPC call
RPCVERSION	equ	2	; Present RPC version supported
RPC_ACCEPT	equ	1	; RPC accepted the request

;------ Moderate flamage: Although the assembler *claims* to support
;	constants with 33 bits, it overflows each time anything to do
;	with these big numbers is attempted. HP-41CV triumphs over
;	Microsloth again.

PORTMAPPER	equ	100000	; Connects us to the port mapper.
PORTMAPPERH	equ	1
PORTMAPPERL	equ	34464
PORTMAPVER	equ	2	; This is just winging it now...
PORTMAPFCT	equ	3

;***** NFS constants **********************************************************

AUTH_UNIX	equ	1	; RPC authority ID flags
AUTH_NULL	equ	0
NFS_PROG	equ	100003	; RPC request for NFS
NFS_PROGH	equ	1	; see remark above regarding portmap
NFS_PROGL	equ	34467
NFS_VER		equ	2
MOUNTD		equ	100005	; RPC mount request
MOUNTDH		equ	1
MOUNTDL		equ	34469
MD_VER		equ	1	; version 1 of the mount daemon
MD_MOU		equ	17	; function mount? whatever...
NFS_PORT	equ	2049	; nfs daemon's port
MNT_PORT	equ	654	; mount daemon's port
PM_PORT		equ	111	; port mapper's listen port
NFS_STAT	equ	17


;***** Structures **************************************************************
;*******************************************************************************

; This structure can be used to pick apart RPC replies. Normally though there
; isn't much here more helpful than the last field --RPC_RETCOD

RPCHEAD	STRUC
RPC_XID		dd	0		; unique ID for this transaction
RPC_STATUS	dd	RPC_ACCEPT	; Flag signals this is an rpc reply
RPC_LENGTH	dd	0		; Number of credit groups in RPC header
RPC_AUTHSH	dd	AUTH_NULL	; At least the AUTH_NULL instance...
RPC_AUTNLT	dd	0		; The obligatory NULL field separator.
RPC_RETCOD	dd	0		; the actual procedure's return code.
RPCHEAD	ENDS

; This is pretty static for now. Later we can cut out unneeded AUTH shorts
; and any extra GIDs. Then we'll deal with the hostname stuff.

NFSREQ	STRUC
AUTH_FLDTX	dd	AUTH_UNIX
AUTH_SIZTX	dd	?
HOSTID		dd	0ff0bcb2ah	; already in network order
HOSTNAML	dd	13h
HOSTNAM		db	'megalon.agricon.com',0
UIDTX		dd	0
GIDTX		dd	0
NGRSTX		dd	8
GRSTX		dd	0,0,2,3,4,5,20,31
AUTNLTX		dd	AUTH_NULL
ZEROTX		dd	0
NFSREQ	ENDS

; Static mount request structure

MOUNT	STRUC
MOUNTR	db	size NFSREQ dup (0)	; Just write over NFS_[PROG,VER,FCT]
MTPTLEN	dd	4			; counted bytes of mount point path
MTPTH	db	'/usr'			; Note: no null termination
MOUNT	ENDS

; outgoing RPC request structure

RPCSND	STRUC
RPCXID	dd	?
RPCCALL	dd	RPCTX
RPCVER	dd	RPCVERSION
RPCPROG	dd	PORTMAPPER
PRGVER	dd	PORTMAPVER
PRGFCT	dd	PORTMAPFCT
NULL1	dd	0
NULL2	dd	0
NULL3	dd	0
NULL4	dd	0
RPCSND	ENDS

; portmapper request structure

PMAP	STRUC
TARGPRG	dd	NFS_PROG
TARGVER	dd	NFS_VER
TARGFCT	dd	NFS_STAT
NULLTRM	dd	0
PMAP	ENDS

SUBTTL	Segments
PAGE+

;***** Macros ******************************************************************
;*******************************************************************************

; convert a longword from network order into host order. AX:DX used.

htond	MACRO
	xchg	ah,dl	;; whether AX or DX is more significant is unimportant.
	xchg	dh,al	;; engine swaps w/ caboose, then middle cars swap.
	ENDM

;***** Segments ****************************************************************
;*******************************************************************************

Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
	extrn	TXpktb:byte
BUFFER	ENDS

; Simple data to test out the functions. Included is a static structure to
; request a port from the host's port mapper. This is simple enough for starters
; yet actually provides meaningful test for our routines.

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'

	public	mountport,nfsport

xid		dd	0deadbeefh
sourceport	dw	PMAPSRC	; portmapper program's source port
destport	dw	PM_PORT	; portmapper program's destination port
mountport	dw	MNT_PORT	; mountd destination port
nfsport		dw	NFS_PORT	; nfs daemon's destination port

; RPC statistics

	PUBLIC	rpcfail, rpcxidf

	even
rpcfail	dw	0	; The RPC failed (host rejected, etc.)
rpcxidf	dw	0	; An incorrect RPC XID was in the packet.
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

; Strings and other things not needed after startup should go here

data	SEGMENT	WORD	PUBLIC	'DATA'
badmap	db	'Error reaching portmapper. Exiting.',cr,lf,'$'
data	ENDS

	extrn	ippkttx:near,ippktrx:near

Restext	SEGMENT	PARA	PUBLIC	'TEXT'

	ASSUME	cs:ResGroup,ds:ResGroup,ss:ResStack,es:BUFFER

	PUBLIC	mapmountd,mapnfsd,rpcvrfy,htonds,rpcsetup

; Take the incoming packet and remove the RPC information. We only check
; against the most recent XID and drop the packet if it doesn't match. This
; is because there can't be more than one pending RPC transaction at present.
; In the future we may need to change this. The calling function will receive
; the updated packet byte count and a pointer to the data from the remote
; procedure's return code onward. On entry, AX must contain the number of bytes
; in the packet (not counting IP, UDP or ethernet headers of course.)

rpcvrfy	PROC	NEAR
	push	dx
	sub	ax,size RPCHEAD	; ensure we got enough data.
	jnb	rplysz
	inc	[rpcfail]
	jmp	rpcout
rplysz:	add	ax,4		; deduct procedure's return code from count
	push	ax		; save packet byte count
	push	es		; first pass the far address to the source.
	push	di
	push	es		; now pass the near address.
	push	di
	mov	ax,size RPCHEAD / 4	; the number of LONGWORDS to convert is
	push	ax		; and the number of longwords
	call	htonds

	mov	ax,word ptr es:[di].RPC_XID	; ensure xid matches the
	mov	dx,word ptr es:[di].RPC_XID+2	; one before. Do long math.
	cmp	ax,word ptr [xid]
	jnz	badrpcxid
	cmp	dx,word ptr [xid+2]
	jz	rpcckop
badrpcxid:
	inc	[rpcxidf]
	jmp short rpcxbd
rpcckop:
	cmp	word ptr es:[di].RPC_STATUS,RPC_ACCEPT	; longwords, what
	jnz	badrpcsta				; a pain...
	cmp	word ptr es:[di+2].RPC_STATUS,0
	jz	rpcxit
badrpcsta:
	inc	[rpcfail]
rpcxbd:	stc
rpcxit:	pop	ax
rpcout:	lea	di,[di].RPC_RETCOD	; we exit pointing to the return
	pop	dx			; code no matter what.
	ret
rpcvrfy	ENDP

; convert a contigous region of longwords from host format to network format.
; The count of the LONGWORDS (not bytes!) is passed on the stack, as are far
; pointers to the source and destination addresses. Registers are used so
; the conversion may be done in-place if desired.

htonds	PROC	NEAR
	push	bp
	mov	bp,sp
	push	cx
	push	dx
	push	di
	push	es
	push	si
	push	ds
	mov	cx,[bp+4]	; longword count --last parameter passed
	les	di,[bp+6]	; destination address
	lds	si,[bp+0ah]	; source --first parameter passed

nwstrl:	lodsw		; get the words from the source and
	mov	dx,ax
	lodsw
	xchg	ah,al	; because we loaded dx, then ax we do an implicit
	xchg	dh,dl	; highword/lowword swap on save. Fix the bytes
	stosw		; within the words and we'll be done.
	mov	ax,dx	; Now write them back without goofing this up.
	stosw
	loop	nwstrl	; keep going...

	pop	ds
	pop	si
	pop	es
	pop	di
	pop	dx
	pop	cx
	pop	bp
	ret	10
htonds	ENDP

; This procedure performs a portmap request.

pmapreq	PROC	NEAR
	lea	di,es:[TXpktb]
;
;------ First make up the RPC header for our desired function
;
	mov	ax,PORTMAPFCT / 65535	; RPC request: what portmap must do.
	push	ax
	mov	ax,PORTMAPFCT MOD 65535
	push	ax
	mov	ax,PORTMAPVER / 65535	; RPC request: version ? of portmap
	push	ax
	mov	ax,PORTMAPVER MOD 65535
	push	ax
	mov	ax,PORTMAPPERH	; RPC request: to the portmapper daemon
	push	ax
	mov	ax,PORTMAPPERL
	push	ax
	call	rpcsetup		; build the beginning of our RPC call
	call	nullcrg			; clear out unneeded credit groups
;
;------ Now comes the "user specific" data. Things the called program will want.
;
	push	bp		; A mini stack frame. It's easier to do
	mov	bp,sp		; it now and clear it b/c most of the
	push	si		; other stuff doesn't modify registers
	push	cx

	lea	di,[di+size RPCSND]		; point to the user data area.
	lea	si,[bp+4]
	mov	cx,6				; update: TARGPRG,
	cli					;         TARGVER
	rep movs word ptr [di],word ptr ss:[si]	;         TARGFCT
	sti

	pop	cx
	pop	si
	pop	bp

	xor	ax,ax
	mov	word ptr es:[di].NULLTRM,ax	; don't forget the trailing 0
	mov	word ptr es:[di+2].NULLTRM,ax

	lea	di,es:[TXpktb]
	push	es
	push	di
	push	es
	push	di
	mov	ax,size RPCSND + size PMAP / 4
	push	ax
	call	htonds			; convert request to host order.
;
;------ Now we are ready to send it!
;
	push	[destport]			; port to use for tx...
	push	[sourceport]			; port the partner monitors
	mov	ax,size RPCSND + size PMAP	; How much "user" data...
	push	ax
	call	ippkttx				; off it goes!
	jc	pmap_xit			; wait for input?
;
;------ Now it seems most reasonable to me that the tx builder should manage
;	the received reply. Who would know better about the necessary RPC fields
;	and the return code. If all is good pass the balance of the data to the
;	user.
;
	call	ippktrx		; now we camp out for our little bundle of joy...
	jc	pmap_xit	; did we time out before success?
	call	rpcvrfy		; check the RPC fields & boil down facts.
	jnc	pmp_fin		; AX has packet size, ES:DI the data
pmap_xit:
	push	dx
	push	ds
	mov	dx,data
	mov	ds,dx
	lea	dx,[badmap]
	mov	ah,DOSPRT
	int	DOSCALL
	pop	ds
	pop	dx
pmp_fin:
	ret	12
pmapreq	ENDP

; set up the fields in an outgoing RPC request. Since they are longwords,
; copy them over and then convert them en-masse. 3 parameters must be
; passed: the program, version and function being requested.

rpcsetup	PROC	NEAR
	push	bp
	mov	bp,sp
	push	di
	push	si
	push	dx

	call	updxid				; first, update the exchange ID
	mov	ax,word ptr [xid]		; now get it for the RPC field
	mov	dx,word ptr [xid+2]
	mov	word ptr es:[di].RPC_XID,ax
	mov	word ptr es:[di].RPC_XID+2,dx

	xor	dx,dx				; the balance of the call is
	mov	ax,RPCTX			; longwords of 0, 1 or 2
	mov	word ptr es:[di].RPCCALL,ax
	mov	word ptr es:[di].RPCCALL+2,dx

	mov	ax,RPCVERSION			; Now we've finished the
	mov	word ptr es:[di].RPCVER,ax	; RPC header proper.
	mov	word ptr es:[di].RPCVER+2,dx

	xchg	cx,dx			; save CX and prepare to copy over
	lea	di,[di].RPCPROG		; word parameters
	lea	si,[bp+4]		; copy them off the stack, beware of
	mov	cx,6			; the interrupt bug for 2 prefixes...
	cli
	rep movs word ptr [di],word ptr ss:[si]
	sti
	mov	cx,dx			; restore CX contents

	pop	dx
	pop	si
	pop	di
	pop	bp
	ret	12
rpcsetup	ENDP

; Many times an RPC call has no need to send credit groups or authority shorts.
; Zero them out with this function. It expects es:di to point to the proper
; buffer.

nullcrg	PROC	NEAR
	push	di
	push	cx
	xor	ax,ax
	lea	di,[di].NULL1				; fill in the NULLs
	mov	cx,(size RPCSND - offset NULL1) / 2	; don't use & flags.
	rep stosw
	pop	cx
	pop	di
	ret
nullcrg	ENDP

; manage the londword math behind the exchange ID.

updxid	PROC	NEAR
	add	word ptr [xid],1
	adc	word ptr [xid+2],0
	ret
updxid	ENDP

; Call up the port mapper on the host and get the mount daemon's port. If the
; rpc call fails, return. If it gives 0 then use the default port. (Actually
; shouldn't it use defaults anyway? We leave that up to whoever called us.)

mapmountd	PROC	NEAR
	mov	ax,MD_MOU / 65535	; Another function I don't know about?
	push	ax
	mov	ax,MD_MOU MOD 65535
	push	ax
	mov	ax,MD_VER / 65535	; The version I can handle...
	push	ax
	mov	ax,MD_VER MOD 65535
	push	ax
	mov	ax,MOUNTDH	; seek the mount daemon's port
	push	ax
	mov	ax,MOUNTDL
	push	ax
	call	pmapreq	; The initiator will know what to receive so it
	jnc	moun1a	; makes the RPQ request & checks the eventual reply.
moun1f:	ret
moun1a:	cmp	ax,8	; Do the return code & port remain in the packet?
	jl	moun1f
	mov	ax,es:[di]	; check the actual return code
	or	ax,es:[di+2]
	jnz	moun1f
	mov	ax,es:[di+6]	; now get the port
	and	ax,ax		; if the port isn't reasonable use the default
	jz	moun1f
	xchg	ah,al		; convert to host order!
	mov	[mountport],ax
	ret
mapmountd	ENDP

; Map out the NFS daemon's port

mapnfsd	PROC	NEAR
	mov	ax,NFS_STAT / 65535	; Just what function did we want?
	push	ax
	mov	ax,NFS_STAT MOD 65535
	push	ax
	mov	ax,NFS_VER / 65535	; it's version for sanity across
	push	ax			; different revisions & arguments.
	mov	ax,NFS_VER MOD 65535
	push	ax
	mov	ax,NFS_PROGL	; Remote program we wish to reach
	push	ax
	mov	ax,NFS_PROGH
	push	ax
	call	pmapreq		; how do we reach NFS?
	jnc	nfsm1a	; makes the RPQ request & checks the eventual reply.
nfsm1f:	ret
nfsm1a:	cmp	ax,8	; Do the return code & port remain in the packet?
	jl	nfsm1f
	mov	ax,es:[di]	; check the actual return code
	or	ax,es:[di+2]
	jnz	nfsm1f
	mov	ax,es:[di+6]	; now get the port
	and	ax,ax		; if the port isn't reasonable use the default
	jz	nfsm1f
	xchg	ah,al		; convert to host order!
	mov	[nfsport],ax
	ret
mapnfsd	ENDP
Restext	ENDS
	END
