TITLE	Misc. Functions for NFS project
SUBTTL	Tools for DOS interface
PAGE	60,132
NAME	nfstools

COMMENT	@

	Agricon International Inc	November 17, 1992	David C. Brown IV

	See files COPYING and COPYWRT for copyright information. Copyright (C)
	Agricon International Inc. 1993

	This module has some simple functions to convert DOS format date & time
	to or from UNIX format. The idea is trivial but is complicated by the
	fact that longword/longword multiplies and divides are needed but aren't
	directly supported on the 80286 and older processors. Since those machines
	are to be NFS clients, it is important to accommodate them.

	@

;****** EQUATES ***************************************************************
;******************************************************************************

SECPERHR	equ	3600	; If you can read you already know these things
MINPERHR	equ	60	; they are just here to put WORDs into code not
HRPERDAY	equ	24	; plain numbers, hopefully enhancing readability
MONTHS		equ	12	; Next field is fixed point number:
DAYPERYR	equ	16d4h	; 365.25 decimal, last 4 bits are for fraction.
LEAPMAGIC	equ	3	; manipulates year after it's in DOS format
LEAPOFFS	equ	43200	; THE EPOC is 1/2 year into leap cycle. Adjust
SECTO80L	equ	42496	; Low word of seconds since THE EPOC to 1980
SECTO80H	equ	4814	; high word of above.
SECTO80		equ	315532800	; Seconds to 1980, since THE EPOC

;****** RECORDS ***************************************************************
;******************************************************************************

dosdate	RECORD	YRFLD:7,MOFLD:4,DAYFLD:5	; DOS encoded date since 1980
dostime	RECORD	HRFLD:5,MINFLD:6,SECFLD:5	; DOS encoded time, since 00:00

;****** SEGMENTS **************************************************************
;******************************************************************************

Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
BUFFER	ENDS

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

Restext	SEGMENT	PARA	PUBLIC	'TEXT'

	public	time2DT, DT2time

	ASSUME	cs:ResGroup,ds:ResGroup,ss:NOTHING,es:NOTHING

; converts the UNIX time_t longword on the stack into DOS date/time format.
; Result is returned with date in DX and time in AX

public	time2DT						;XXX


time2DT	PROC	NEAR
	push	bp
	mov	bp,sp
	sub	sp,4		; temporary storage
	push	bx
	push	cx
	push	di
	push	es
;
;------	THE EPOCH (January 1, 1970) is 1/2 through the leap year cycle. Offset
;	the given date to account for this. Now division by 365.25 handles leap
;	year automatically.
;
	mov	ax,[bp+4]
	add	ax,LEAPOFFS	; First, bump up seconds count in low word
	mov	[bp+4],ax	; and save.
	jnc	hifine
	inc	word ptr [bp+6]	; if we carried into high word fix it.
hifine:
;
;------	Longword divide is done incrementally because remainder would be
;	> 64K.
;
	mov	cx,SECPERHR
	xor	dx,dx		; clear highword
	mov	ax,[bp+6]
	div	cx		; MSN of quotient
	mov	[bp-2],ax
	mov	ah,dl		; bump low nybble of quotient into new
	mov	dl,dh		; divisor, bump high nybble (if any) then
	xor	dh,dh		; uppermost nybble must be 0. Bring in the
	mov	al,[bp+5]	; the next nybble of the original dividend.
	div	cx
	mov	[bp-3],al	; will fit, largest possible quotient is 18
	mov	ah,dl		; again, shuffle down to next nybble in
	mov	dl,dh		; longword. Just like in conventional
	xor	dh,dh		; longhand division.
	mov	al,[bp+4]	; finally the LSN
	div	cx
	mov	[bp-4],al	; quotient (hours since 1,1,1970) complete...
;
;------ Now take the modulus of hours and find minutes & seconds
;
	mov	ax,dx		; modulus of hours must be minutes of today.
	mov	cx,MINPERHR
	div	cl		; mod => sec -> ah, quotient => minutes -> al
	shr	ah,1		; convert ah to seconds / 2
	mov	cl,offset MINFLD
	mov	dl,ah		; save seconds & align minutes.
	xor	ah,ah
	shl	ax,cl		; mov the minutes into DOS encoded pos.
	or	al,dl		; Now we only need hours of today.
	push	ax		; save for a bit...
	mov	ax,[bp-2]
	mov	cl,HRPERDAY
	div	cl
	mov	bh,al		; save day temporarily
	mov	al,[bp-3]	; work 1 nybble at a time, as before
	div	cl
	mov	bl,al
	mov	al,[bp-4]
	div	cl
	mov	[bp-3],al	; save days elapsed since 1,1,1970
	mov	[bp-2],bx
;
;------	Convert to modulus into fraction of a 24 hour period
;
	xor	al,al		; Modulus X 16 / 24 => 1 nybble fract. days
	mov	cl,4		; Nybble moves are a real nuisance!
	shr	ax,cl
	mov	cl,HRPERDAY	; As we were...
	div	cl		; result will always be < 16
	xchg	ah,al		; the qoutient is really the fraction!
	add	ax,256 - (24/2)	; this trick should round up
	mov	bl,ah		; but be faster than test/jump
;
;------ Now divide by days/year to get days since THE EPOC (modulus) & years
;
	mov	dl,[bp-1]	; recover number of dayss and align such that
	mov	ax,[bp-3]	; we will have upper nybble in dx
	xor	dh,dh
	mov	cl,4
pmte4:	shl	ax,1		; bump everybody up 1 nybble to represent
	rcl	dl,1		; fractional bits.
	loop	pmte4
	or	al,bl		; add in fraction of days from before.
	mov	cx,DAYPERYR	; 365.25 days by representing bit 6 as 0.25 days.
	div	cx
	sub	ax,10		; DOS dates start at 1980, THE EPOC at 1970, fix.
;
	mov	bl,dl		; save day fraction
	and	bl,0fh		; we only have 4 bits precision here.
	mov	cl,4
	shr	dx,cl		; convert to integer days
	xchg	ax,dx		; let AX = days for month conversion coming up
	mov	cl,(offset YRFLD)
	shl	dx,cl		; move year into DOS position
	mov	di,ds		; SCASW instruction is micro-coded to ES only
	mov	es,di
	inc	ax		; change days from zero base to 1 base.
	test	dh,LEAPMAGIC	; if zero => leap year
	jnz	yrisok
	cmp	al,31+29	; Compensate month table for Feb 29
	jl	yrisok
	jg	bkyr
	mov	ax,5dh		; special case of Feb 29 is easier to
	jmp short finyr		; handle outright.
bkyr:	dec	ax
yrisok:	lea	di,[daynums]	; address lookup table of day of year
dy2mo:	scasw
	jg	dy2mo
	sub	ax,[di-4]	; subtract offset of days *to* this month
	mov	dl,al		; install into place
	mov	cl,offset MOFLD	; and we've got day of month. (except for
	mov	ax,di		; leap years.) Build up DOS' format field
	sub	ax,offset daynums + 2	; convert offset into actual month.
	shr	al,1
	shl	ax,cl
finyr:	or	dx,ax		; Year/month/day is done!
;
; now convert day fraction into hours and finish time conversion
;
	mov	al,bl
	xor	ah,ah		; straightforward multiply 24 * fract.
	mov	cl,HRPERDAY
	mul	cl
	and	al,0f0h
	mov	cl,OFFSET HRFLD - 4	; align but remember to chop 4
	shl	ax,cl			; bits since we had a FRACTION
	pop	bx
	or	ax,bx		; stick in the minute/second info.

	pop	es
	pop	di
	pop	cx
	pop	bx
	mov	sp,bp		; deallocate local storage
	pop	bp
	ret	4
;
;------ Table of the day of year each month begins
;
		dw	-1	; Hack. 1st month flunks index on 1st try,
				; others overshoot & need to back up 1 word
				; AND account for Intel's postincrement.

daynums:	dw	0, 31, 59, 90, 120, 151, 181
		dw	212, 243, 273, 304, 334, 365

time2DT	ENDP

; Convert the date and time passed on the stack from DOS format to UNIX
; Time is passed first, date is passed second (lower address):
;
;	time2DT(short date, short time);
;

DT2time	PROC	NEAR
	push	bp
	mov	bp,sp
	sub	sp,2		; local variable to flag leap year
	push	bx
	push	cx
	push	di

	mov	ah,[bp+7]	; Byte containing the hour field
	and	ax,MASK HRFLD
	mov	cl,offset HRFLD - 8
	shr	ah,cl
	xchg	al,ah		; streamline the shr instruction
	mov	cx,SECPERHR	; convert hours to seconds
	mul	cx
	mov	bx,ax		; save LSW of product
	mov	ax,[bp+6]
	and	ax,MASK MINFLD
	mov	cl,offset MINFLD
	shr	ax,cl		; restore position
	mov	cl,60
	mul	cl		; convert min. to sec
	add	ax,bx		; and update count
	adc	dx,0		; while arranging registers
	mov	bl,[bp+6]
	and	bx,MASK SECFLD
	shl	bl,1		; DOS saves with sec/2
	add	ax,bx		; update tally
	adc	dx,0
	push	dx		; safe keeping. Arranged for easy
	push	ax		; longword math
	mov	ah,[bp+5]	; Byte with years
	and	ax,MASK YRFLD
	shr	ax,OFFSET YRFLD - 8
	xchg	ah,al		; complete shift operation
	mov	bx,ax		; save a copy
	mov	cl,4		; Non-zero remainder => leapyear
	div	cl
	mov	[bp-2],ah	; save remainder
	mov	ax,bx
	mov	cx,1e1h		; upper word of sec/year
	mul	cx		; crude double-word multiply
	xchg	bx,ax		; overflow is possible deep into future
	mov	cx,87e0h	; LSW of sec/year
	mul	cx
	add	dx,bx		; add back in upper word
	add	ax,SECTO80L
	adc	dx,SECTO80H
	pop	bx
	add	ax,bx		; now add in seconds of today
	pop	bx
	adc	dx,bx
	push	dx		; save again
	push	ax
	mov	bx,[bp+4]
	and	bx,MASK MOFLD
	cmp	bx,3 SHL (OFFSET MOFLD)	; Fixup for Jan/Feb in leap years
	jge	notfeb			; Extra day isn't added until March.
	mov	byte ptr [bp-2],0ffh	; remove leap year fixup
notfeb:	mov	cl,OFFSET MOFLD - 1
	shr	bx,cl		; leave as word offset
	lea	di,[daynums]	; Index into table zero based.
	mov	ax,[bx+di-2]	; get days elapsed to this month
	mov	bl,[bp+4]	; byte having days
	and 	bx,MASK DAYFLD
	add	ax,bx
	test	byte ptr [bp-2],0ffh
	jz	doleap		; Calculate with days based at
	dec	ax		; zero, not one.
doleap:	mov	cx,5180h
	mov	bx,ax		; save a copy
	mul	cx		; convert to seconds
	add	dx,bx		; simulates upper word of 1:5180h
	pop	bx
	add	ax,bx		; now for the grand total!
	pop	bx
	adc	dx,bx

	pop	di
	pop	cx
	pop	bx
	mov	sp,bp
	pop	bp
	ret	4
DT2time	ENDP

; Just try out the modules and then get rid of this part.
ifdef	STANDALONE
stub	PROC	NEAR
	mov	ax,63c0h	; 12:30pm
	push	ax
	mov	ax,190fh	; August 15, 1992
	push	ax
	call	DT2time
	mov	ax,2abdh		; Should be September 21, 1992
	push	ax
	mov	ax,4eb3h		; at 0:25:22 local.
	push	ax
	call	time2DT
stub	ENDP
endif
Restext	ENDS
	END	;stub		; uncomment if standing alone
