/*
 * Agricon International Inc.
 *
 * December 9, 1993		David C. Brown IV
 *
 * The manifest constants and data structures for our NFS testing interface
 * are defined here.
 *
 */

/* room for 8 letters, 3 letter extension, period & null terminator. */

#define ETN	11
#define MAXPTH	67

/* Manifest constants for working the user interface */

#define STAT	'S'
#define CD	'C'
#define FF	'1'
#define FN	'N'
#define OPN	'O'
#define RD	'R'
#define WR	'W'
#define VIRG	'V'		// create/truncate a file => first time!
#define UNM	'U'
#define CLSE	'E'		// End file transaction
#define FSK	'P'		// Point to a new location
#define DLT	'X'
#define REN	'M'
#define MDR	'D'
#define RDR	'K'
#define SAT	'A'
#define GAT	'I'

#define MKDIR	3
#define RMDIR	1
#define	CHDIR	5
#define NFSCL	6
#define NFSRD	8
#define NFSWR	9
#define NFSSTAT	0x0c
#define ATTSET	0x0e
#define ATTGET	0x0f
#define FREN	0x11
#define UNLNK	0x13
#define USED	0x16
#define VIRGIN	0x17		// create/truncate a file => first time!
#define	FFST	0x1b
#define	FNXT	0x1c
#define POINT	0x21
#define MOUNT	0x22		// Steal these two functions to allow
#define UNMT	0x23		// controlled mounting & unmounting.

/* Character management constants */

#define CTLD	4
#define CTLH	8
#define CTLL	12
#define CTLU	21
#define CTLV	22
#define CTLW	23
#define CTLZ	26
#define DEL	127

/* System data block: houskeeping for find first/next operations */

struct sdb {
	unsigned char	drive;		// Letter of drive to search
	char		patt[ETN];	// search pattern
	unsigned char	fndattr;	// sought file's attributes
	int		dirent, clutr;	// offset into dir. & inode
	char		unk1[4];
	  };

/* Found file directory entry block */

struct fouent {
	char		founame[ETN];		// result of query
	unsigned char	fouattr, extr[10];	// attributes & ?
	unsigned short	m_time, m_date, clust;	// modification, not creation
	unsigned long	fousize;		// size in bytes
	};

/* System file table entries */

struct sft {
	unsigned int	handles, o_mode;	// # handles on this file,
	unsigned char	sf_attr;		// open mode & attributes of it
	unsigned int	dev;
	char far	*devdrv;			// file's dev. driver
	unsigned int	strclst, sf_time, sf_date;	// starting cluster,
	unsigned long	sf_size, pos;			// create info & cur
	unsigned int	relclst, absclst, dirsect;	// pos, last clust. acc.
	unsigned char	sf_dir;				// SFT entry #
	char		sf_name[ETN];		// FCB name
	};

/* Current directory structures, DOS VERSION SPECIFIC !!!!! */

struct cds3 {
	char		path[MAXPTH];	// drive spec. incl. colon & null
	unsigned int	flags;
	char far	*dpb, *redir;
	unsigned int	reqpar, rootoff;	// char count to path's root \
	} ;				// global instance to test programs.

struct cds4 {
	char		path[MAXPTH];	// drive spec. incl. colon & null
	unsigned int	flags;
	char far	*dpb, *redir;
	unsigned int	reqpar, rootoff;	// char count to path's root \
        char		trailer[8];
	} ;				// global instance to test programs.

/* Swapable data area */

struct sda3 {
	unsigned char	cef, inDOS;	// Crit. Err & DOS busy flags

	unsigned char	errdrv;		// drive that caused the error.
	unsigned char	locus;		// locus of last critical error
	unsigned int	exterr;		// extended code of last error.
	unsigned char	act, errcls;	// sugg. action & class of last err.
	char far	*dd;		// pointer of last error

	char far	*curdta;	// CURRENT disk transfer buffer
	unsigned int	curpsp;		// current psp (process)
	unsigned int	spon23, retcod;	// INT 23h SP, last proc's ret. code
	unsigned char	curdrv, xbrflg;	// current drive, extended break flag

	char		bfd1[22];	// excess bytes...

	unsigned char	dayom, month;	// day of month & month
	unsigned int	yr80, elday;	// year - 1980, days since 1980
	unsigned char	dow, bfd2[93];	// day of week, Sun = 0. Excess...

	char		fname1[128], fname2[128];	// rename buffers

	struct sdb	fffn;		// buffer for find first/next
	struct fouent	ffile;		// buffer for found file's user data
	struct cds3	drvcds;

/* Buffer for FCB style names 1 & 2 and some excess bytes */

	char		nm1fcb[11], pad1, nm2fcb[11], bfd3[9];

	unsigned char	dirsrch;	// search attr. FOR DIRECTORIES
	unsigned char	fcbtype;	// ff => extended FCB
	unsigned char	lookatt, fo_mod; // search attr. (find first/next)
					 // and file open mode (read/write)
	char		bfd4[44];	// excess bytes...

/* pointers to current SFT, drive being accessed & caller's FCB */

	char far	*cursft, *cdrvcds, *clrfcb;
	char		bfd5[2];

	unsigned int	tmphnd;		// temporary handle storage
	char far	*jftent;	// job file table in process' handle

	unsigned int	nm1cso, nm2cso; // offset into DOS' CS for 1 & 2nd f-names
	char		bfd6[18];
	unsigned long	curofs;		// current offset into file
	char		bfd7[12];
	unsigned long	apnd;		// # bytes appenede to file
	char far	*dskbf, *sftptr;	// disk buf & SFT entry ptrs.
	unsigned int	savbx, savds;	// bx, dx saves during INT 21h calls
	unsigned int	regtemp;	// caller's temp reg storage
	unsigned long	reent;		// caller's prev frame on INT 21h re-ent
	struct sdb	srcren;		// rename operations find first/next
	struct fouent	setren;		// file being renamed
/*
 *	criterr	db	331 dup(?)	; DOS' critical error stack
 *	diskstk	db	384 dup(?)	; DOS' disk I/O stk (NOT ALL DSK CALLS!)
 *	charstk	db	384 dup(?)	; DOS' character I/O stack (fct 1 - 0Ch)
 */
	} ;	/* global instance of the swappable data area. */

struct sda4 {
	unsigned char	cef, inDOS;	// Crit. Err & DOS busy flags

	unsigned char	errdrv;		// drive that caused the error.
	unsigned char	locus;		// locus of last critical error
	unsigned int	exterr;		// extended code of last error.
	unsigned char	act, errcls;	// sugg. action & class of last err.
	char far	*dd;		// pointer of last error

	char far	*curdta;	// CURRENT disk transfer buffer
	unsigned int	curpsp;		// current psp (process)
	unsigned int	spon23, retcod;	// INT 23h SP, last proc's ret. code
	unsigned char	curdrv, xbrflg;	// current drive, extended break flag

	char		bfd1[24];	// excess bytes...

	unsigned char	dayom, month;	// day of month & month
	unsigned int	yr80, elday;	// year - 1980, days since 1980
	unsigned char	dow, bfd2[103];	// day of week, Sun = 0. Excess...

	char		fname1[128], fname2[128];	// rename buffers

	struct sdb	fffn;		// buffer for find first/next
	struct fouent	ffile;		// buffer for found file's user data
	struct cds4	drvcds;

/* Buffer for FCB style names 1 & 2 and some excess bytes */

	char		nm1fcb[11], pad1, nm2fcb[11], bfd3[9];

	unsigned char	dirsrch;	// search attr. FOR DIRECTORIES
	unsigned char	fcbtype;	// ff => extended FCB
	unsigned char	lookatt, fo_mod; // search attr. (find first/next)
					 // and file open mode (read/write)
	char		bfd4[47];	// excess bytes...

/* pointers to current SFT, drive being accessed & caller's FCB */

	char far	*cursft, *cdrvcds, *clrfcb;
	char		bfd5[2];

	unsigned int	tmphnd;		// temporary handle storage
	char far	*jftent;	// job file table in process' handle

	unsigned int	nm1cso, nm2cso; // offset into DOS' CS for 1 & 2nd f-names
	char		bfd6[24];
	unsigned long	curofs;		// current offset into file
	char		bfd7[12];
	unsigned long	apnd;		// # bytes appenede to file
	char far	*dskbf, *sftptr;	// disk buf & SFT entry ptrs.
	unsigned int	savbx, savds;	// bx, dx saves during INT 21h calls
	unsigned int	regtemp;	// caller's temp reg storage
	unsigned long	reent;		// caller's prev frame on INT 21h re-ent

        char            bfd8[9];
        char		spopnop, spopnat, spopnmo;
        char            bfd9[29];

	struct sdb	srcren;		// rename operations find first/next
	struct fouent	setren;		// file being renamed
/*
 *	criterr	db	331 dup(?)	; DOS' critical error stack
 *	diskstk	db	384 dup(?)	; DOS' disk I/O stk (NOT ALL DSK CALLS!)
 *	charstk	db	384 dup(?)	; DOS' character I/O stack (fct 1 - 0Ch)
 */
	} ;	/* global instance of the swappable data area. */
