/*
 * Agricon International Inc.
 *
 * October 12, 1992		David C. Brown IV
 *
 * This program provides a test interface for the NFS client/requestor
 * program. It solicits input from the user and then forms that into the
 * proper DOS network redirector calls. DOS system data structures are
 * emulated and a call is made to our network redirector stub under test.
 * The results are reported back to the user.
 *
 * Compile: cl -c -Lr -Zp nfstest.c    !!! The Zp is very important !!!
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "nfstest.h"

/* A few macros to help deal with segmented addresses */

#define GETSEG(A)	(unsigned short)((unsigned long)(A) >> 16)
#define GETOFF(A)	(unsigned short)((unsigned long)(A) & 0xffffL)

/* Storage constants */

#define BSIZ	0xc000 /* 49152 */

struct sft SFT1;
struct cds3 CDS1;
struct cds4 CDS4;
struct sda3 SDA1;
struct sda4 SDA4;

/* a global place to examine registers after the network redirection */

unsigned int	AX, BX, CX, DX, SI, DI, ES;
unsigned short	bytes;
char far	fish1[BSIZ];	/* global buffer for file transfers */
char		radfile[14], dver = 3;
char		mountpnt[] = "/usr/HOME\\";

/* function prototypes */

extern	int	dosiface(unsigned short, ...);
extern	int	initstat(struct sda3  far *, struct cds3 far *);
unsigned int	toytty();

/*
 * We initialize our simulated DOS data structures and then call the packet driver.
 * From there we contact the server and mount the exported file system. The user
 * can simulate DOS requests to the network redirector via this interface.
 */

main(argc, argv)

int  argc;
char *argv[];

{
	char		fct, path[MAXPTH], *j;
	int		res, i;
	unsigned long	disp;
	FILE		*rad;

/* Print copyright of Microsoft C libraries */
	printf("This C program contains library functions copyrighted by\n"
		" Microsoft Corp. who assume no liability from the use of\n"
		" this program.\n");

        if (argc > 1)
            dver = atoi(argv[1]);

	/* Initialize the simulated CDS and SDA */

	if (dver < 4) {
		strcpy(CDS1.path, mountpnt);
		CDS1.flags = 0x80;
		CDS1.rootoff = strlen(mountpnt) - 1; // Don't count canonical '\\'

		SDA1.cdrvcds = (char far *)&CDS1;
		SDA1.cursft = (char far *)&SFT1;
		SDA1.curdta = fish1;		// simulated disk transfer area
		initstat(&SDA1, &CDS1);		// Set up simulated DOS data areas
	} else {
		strcpy(CDS4.path, mountpnt);
		CDS4.flags = 0x80;
		CDS4.rootoff = strlen(mountpnt) - 1;

		SDA4.cdrvcds = (char far *)&CDS4;
		SDA4.cursft = (char far *)&SFT1;
		SDA4.curdta = fish1;
		initstat((struct sda3 far *)&SDA4, (struct cds3 far *)&CDS4);
	}
	pointsft();			// Set ES:DI to fool our verifier.
	dosiface(MOUNT);		// Mount the file system

	/* Solicit user requests to test the interface */

	while ((fct = getch()) != 'Q')
		switch (fct) {

			/* Display information about file system */

			case STAT:
			    res = dosiface(NFSSTAT);
			    printf("clusters/sector(AX):\t%hu\n"
				"clusters(BX):\t%hu\nbytes/sector(CX):\t%hu\n"
				"available(DX):\t%hu\n", AX, BX, CX, DX);
			    break;

			/* Find first file matching a given pattern */

			case FF:
			    printf("fully-qualified path w/o mount point: ");
			    gets(path);
			    if (dver < 4) {
				strcpy(SDA1.fname1, mountpnt);
				strcat(SDA1.fname1, path);
				printf("attributes in ASCII hex: ");
				scanf("%hx", &SDA1.lookatt);
			    } else {
				strcpy(SDA4.fname1, mountpnt);
				strcat(SDA4.fname1, path);
				printf("attributes in ASCII hex: ");
				scanf("%hx", &SDA4.lookatt);
			    }

			    /* set up search pattern */

			    j = path;
                            while (*j)	// seek end of path
                                j++;
			    j--;

			/* back up to name start & convert global chars */

                            while (*j != '\\' && j >= path)
                                j--;
			    j++;

			/* first, zero out the string */

                            if (dver < 4) strcpy(SDA1.nm1fcb, "            ");
                            else strcpy(SDA4.nm1fcb, "            ");
                            i = 0;

			/* copy all chars up to '.' & expand '*' to '?'s */

                            while (*j != '.' && i < 8)
				if (dver < 4) if (*j == '*') {
					j++;
					while (i < 8)
					    SDA1.nm1fcb[i++] = '?';
				    } else
					SDA1.nm1fcb[i++] = *j++;
				else if (*j == '*') {
					j++;
					while (i < 8)
					    SDA4.nm1fcb[i++] = '?';
				    } else
					SDA4.nm1fcb[i++] = *j++;
			    if (*j == '.') {
				i = 8;
				j++;
			    }
			    while (*j && i < 12)
				if (dver < 4) if (*j == '*') {
					j++;
					while (i < 12)
					    SDA1.nm1fcb[i++] = '?';
				    } else
					SDA1.nm1fcb[i++] = *j++;
				else if (*j == '*') {
					j++;
					while (i < 12)
					    SDA4.nm1fcb[i++] = '?';
				    } else
					SDA4.nm1fcb[i++] = *j++;
			    if ((res = dosiface(FFST)) == 0x18)
				printf("no more files\n");
			    else if (!res) {
				dumpSDB();
				dumpfouent();
			    } else printf("file not found\n");
			    fflush(stdin);
			    break;

			/* Find next file matching pattern */

			case FN:
			    if ((res = dosiface(FNXT)) == 0x18)
				printf("no more files\n");
			    else if (!res) {
				dumpSDB();
				dumpfouent();
                            } else printf("file not found\n");
			    break;

			/* Change to the requested directory */

			case CD:
			    if (dver < 4)
				strsda(SDA1.fname1, SDA1.nm1fcb);
			    else
				strsda(SDA4.fname1, SDA4.nm1fcb);
			    if (dosiface(CHDIR))
				printf("directory not found\n");
			    else {
				if (dver < 4)
                                    strcpy(CDS1.path, SDA1.fname1);
				else
                                    strcpy(CDS4.path, SDA4.fname1);
				printf("%s\n", (dver < 4) ? CDS1.path : CDS4.path);
			    }
                            break;

			/* unmount the file system */

			case UNM:
			    dosiface(UNMT);
			    break;

			/* Create a new file or truncate existing file */

			case VIRG:
			case OPN:
			    if (dver < 4)
				strsda(SDA1.fname1, SDA1.nm1fcb);
			    else
				strsda(SDA4.fname1, SDA4.nm1fcb);
			    printf("attributes in ASCII hex: ");
			    scanf("%hx", &i);
			    pointsft();
			    if (!dosiface((fct == OPN) ? USED : VIRGIN, i))
				dumpSFT();
			    else printf("file not %sed\n", fct == OPN ? "open" : "creat");
			    break;

			/* Read from the presently open file */

			case RD:
			    printf("[S]creen or [F]ile capture? ");
			    fct = getch();
			    CX = BSIZ;				// Get full file.
			    pointsft();
			    bytes = dosiface(NFSRD);
			    res = 0;
			    if (toupper(fct) == 'S')
				while (CX--)
				    putchar(fish1[res++]);
			    else {
				printf("Type the destination file's name: ");
				fflush(stdin);
				scanf("%s", radfile);
				printf("\n");
				rad = fopen(radfile, "w");
				if (!rad)
				    break;
				fwrite(fish1, sizeof (char), bytes, rad);
				fclose(rad);
			    }
			    printf("%hu bytes read\n", bytes);
			    break;

			/* Write into the presently open file */

			case WR:
			    printf("[K]eyboard or [F]ile? ");
			    fct = getch(); putchar('\n');
			    if (toupper(fct) == 'K') {
				printf("^D to end\n");
				bytes = toytty();
				printf("\n\t** That's %hd characters **\n", bytes);
			    } else {
				printf("File name to be sent: ");
				fflush(stdin);
				scanf("%s", radfile);
				printf("\n");
				rad = fopen(radfile, "r");
				if (!rad)
				    break;

			/* Get the file's size & don't transfer more than BSIZ */

				fseek(rad, 0L, SEEK_END);
				bytes = ftell(rad);
				fseek(rad, 0L, SEEK_SET);
				if (bytes > BSIZ) bytes = BSIZ;
				fread(fish1, sizeof(char), bytes, rad);
				fclose(rad);
			    }
			    CX = bytes;			/* Pass reg. param. */
			    pointsft();
			    bytes = dosiface(NFSWR);
			    printf("%hu bytes written\n", bytes);
			    break;

			/* Seek to the given offset */

			case FSK:
			    printf("New file offset (from end, in decimal): ");
			    scanf("%lu", &disp);
			    printf("\n");
			    CX = GETSEG(disp);
			    DX = GETOFF(disp);
			    pointsft();
			    dosiface(POINT);
			    break;

			/* Close the presently open file */

			case CLSE:
			    pointsft();
			    dosiface(NFSCL);
			    break;

			/* Make a directory at an arbitrary point */

			case MDR:
			    if (dver < 4) {
				strsda(SDA1.fname1, SDA1.nm1fcb);
				if (dosiface(MKDIR))
				    printf("directory not created\n");
				else printf("%s created\n", SDA1.fname1);
			    } else {
				strsda(SDA4.fname1, SDA4.nm1fcb);
				if (dosiface(MKDIR))
				    printf("directory not created\n");
				else printf("%s created\n", SDA4.fname1);
			    } break;

			/* Delete a directory or file */

			case RDR:
			case DLT:
			    if (dver < 4) {
				strsda(SDA1.fname1, SDA1.nm1fcb);
				if (dosiface((fct == DLT) ? UNLNK: RMDIR))
				    printf("%s not deleted\n", SDA1.fname1);
				else printf("%s deleted\n", SDA1.fname1);
			    } else {
				strsda(SDA4.fname1, SDA4.nm1fcb);
				if (dosiface((fct == DLT) ? UNLNK: RMDIR))
				    printf("%s not deleted\n", SDA4.fname1);
				else printf("%s deleted\n", SDA4.fname1);
			    } break;

			/* Rename the given file */

			case REN:
			    printf("present ");
			    if (dver < 4) {
				strsda(SDA1.fname1, SDA1.nm1fcb);
				printf("new ");
				strsda(SDA1.fname2, SDA1.nm2fcb);
				if (dosiface(FREN))
				    printf("%s not renamed\n", SDA1.fname1);
				else printf("%s now %s\n", SDA1.fname1, SDA1.fname2);
			    } else {
				strsda(SDA4.fname1, SDA4.nm1fcb);
				printf("new ");
				strsda(SDA4.fname2, SDA4.nm2fcb);
				if (dosiface(FREN))
				    printf("%s not renamed\n", SDA4.fname1);
				else printf("%s now %s\n", SDA4.fname1, SDA4.fname2);
			    }
			    break;

			/* Set or get the given file's attributes */

			case SAT:
			case GAT:
			    if (dver < 4)
				    strsda(SDA1.fname1, SDA1.nm1fcb);
			    else
				    strsda(SDA4.fname1, SDA4.nm1fcb);
			    if (fct == SAT) {
				printf("attributes in ASCII hex: ");
				scanf("%hx", &i);
				printf("\n");
			    }
			    dosiface((fct == SAT) ? ATTSET : ATTGET, i);
			    if (fct == GAT)
				printf("attributes = 0x%2.2x\n", AX);
			    break;

			case '?':
			    clue();
			    break;

			default:
			    fprintf(stderr, "Unrecognized function: %c\n", fct);
		}
}

/* Simply convert null-terminated name into FCB style name w/o '.' */

fillfcb(fcb, name)

char *fcb;
char *name;

{
    char *j = name;
    int  i = 0;

    while (*j)				// seek end of path
	j++;
    do j--;				// back up to name start
    while (*j != '\\' && j >= name);
    j++;
    strcpy(fcb, "            ");	// Clear FCB first...
    while (i < 12)			// FCB style name
	if (*j == '.') {
	    j++;
	    i = 8;
	} else
	    fcb[i++] = *j++;
    printf("what we will send: '%-11.11s'\n", fcb);
}

/*
 * Put the address of the SFT into the global processor register images to
 * simulate DOS' register variable calls.
 */

pointsft()

{
    ES = GETSEG(&SFT1);
    DI = GETOFF(&SFT1);
}

/*
 * Prompting the user in this way occurs often so use a function. It prompts,
 * prepends the host portion of the path and then converts the name to FCB
 * format as well.
 */

strsda(asciizname, fcbname)

char *asciizname;
char *fcbname;

{
    char path[MAXPTH];

    printf("fully-qualified name w/o mount point: ");
    fflush(stdin);
    gets(path);
    strcpy(asciizname, mountpnt);

    /* Don't append a trailing '\\' if going to root dir. */

    if (*path != '\\' || path[1])
	strcat(asciizname, path);
    fillfcb(fcbname, path);
}

/* Just print out the SDB we find in the SDA with some order. */

dumpSDB()

{
	if (dver < 4)
	printf("\t\tSDB:\ndrive:\t%c\npattern:\t%-8.8s.%-3.3s\n"
	    "attribute:\t%hx\ninode #:\t%hx\nNFS COOKIE:\t%hx\n",
	    (SDA1.fffn.drive & 0x7f) + 'A', SDA1.fffn.patt, &SDA1.fffn.patt[8],
	    (unsigned short)SDA1.fffn.fndattr, SDA1.fffn.clutr, SDA1.fffn.dirent);
	else
	printf("\t\tSDB:\ndrive:\t%c\npattern:\t%-8.8s.%-3.3s\n"
	    "attribute:\t%hx\ninode #:\t%hx\nNFS COOKIE:\t%hx\n",
	    (SDA4.fffn.drive & 0x7f) + 'A', SDA4.fffn.patt, &SDA4.fffn.patt[8],
	    (unsigned short)SDA4.fffn.fndattr, SDA4.fffn.clutr, SDA4.fffn.dirent);
}

char *months[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
			"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

struct dosdate {
	unsigned day:5;
	unsigned mon:4;
	unsigned year:7;
		};

struct dostime {
	unsigned sec:5;
	unsigned min:6;
	unsigned hours:5;
		};

/* Just print out the found entries in some order */

dumpfouent()

{
	struct dosdate ddate;
	struct dostime dtime;

	if (dver < 4) {
		printf("\t\tFound entry\nname:\t%-8.8s.%-3.3s\n"
			"attribute:\t%hx\nm_time:\t\t%hx", SDA1.ffile.founame,
			&SDA1.ffile.founame[8], (unsigned int)SDA1.ffile.fouattr,
			SDA1.ffile.m_time);
		dtime = *((struct dostime *)&SDA1.ffile.m_time);
		ddate = *((struct dosdate *)&SDA1.ffile.m_date);
	} else {
		printf("\t\tFound entry\nname:\t%-8.8s.%-3.3s\n"
			"attribute:\t%hx\nm_time:\t\t%hx", SDA4.ffile.founame,
			&SDA4.ffile.founame[8], (unsigned int)SDA4.ffile.fouattr,
			SDA4.ffile.m_time);
		dtime = *((struct dostime *)&SDA4.ffile.m_time);
		ddate = *((struct dosdate *)&SDA4.ffile.m_date);
	}
	printf("\t%hd:%hd:%hd\n", dtime.hours, dtime.min, dtime.sec * 2);

	/* Zero-based month index. If illogical, force to January */

	ddate.mon -= 1;
	if (ddate.mon < 0 || ddate.mon > 11)
		ddate.mon = 0;
	if (dver < 4) {
		printf("m_date:\t\t%hx\t%s %hd, %hd\n", SDA1.ffile.m_date,
			months[ddate.mon], ddate.day, ddate.year + 1980);
		printf("cluster:\t%hx\nsize:\t\t%lu\n", SDA1.ffile.clust,
			SDA1.ffile.fousize);
	} else {
		printf("m_date:\t\t%hx\t%s %hd, %hd\n", SDA4.ffile.m_date,
			months[ddate.mon], ddate.day, ddate.year + 1980);
		printf("cluster:\t%hx\nsize:\t\t%lu\n", SDA4.ffile.clust,
			SDA4.ffile.fousize);
	}
}

dumpSFT()

{
	struct dosdate ddate;
	struct dostime dtime;

	printf("\"%-11.11s\"\thandle: %hd\tmode: 0x%4.4hx\tattribute: 0x%4.4hx\n",
	    SFT1.sf_name, SFT1.handles, SFT1.o_mode, SFT1.sf_attr);
	printf("device: %c\tdevdrv: %4.4hu:%4.4hu\n", '@' + ((char)SFT1.dev & 0x1f),
		(unsigned short)((unsigned long)SFT1.devdrv >> 8),
		(unsigned short)((unsigned long)SFT1.devdrv & 0xff));
	printf("Clusters: start=0x%hx\trelative=0x%hx\tabsolute=0x%hx\n",
	    SFT1.strclst, SFT1.relclst, SFT1.absclst);
	ddate = *((struct dosdate *)&SFT1.sf_date);

	/* Zero-based month index. If illogical, force to January */

	ddate.mon -= 1;
	if (ddate.mon < 0 || ddate.mon > 11)
		ddate.mon = 0;
	printf("date: 0x%4.4hx\t(%s %hu, %hu)\n", SFT1.sf_date, months[ddate.mon],
		ddate.day, ddate.year + 1980);
	dtime = *((struct dostime *)&SFT1.sf_time);
	printf("time: 0x%4.4hx\t(%hu:%hu:%hu)\n", SFT1.sf_time, dtime.hours,
		dtime.min, dtime.sec * 2);
	printf("Size/position:	%ld/%ld\n", SFT1.sf_size, SFT1.pos);
	printf("directory sector: %hu\tentry #: 0x%hx\n",
	    SFT1.dirsect, (unsigned)SFT1.sf_dir);
}

/* Back up, erase character and back up over blank space */

rubout()

{
    putchar(CTLH);
    putchar(' ');
    putchar(CTLH);
}

/* Print the given character to the screen with certain formatting conventions */

emitchar(fct)

unsigned char fct;

{
    if (fct == '\n' || fct == '\r') {
	putchar(fct);
	return;
    }
    if (fct < 27)
	printf("^%c", fct + '@');
    else if (fct < ' ' || fct > '~')
	printf("0x%2.2hx", (int)fct);
    else putchar(fct);
}

/* Provide a key to commands available */

clue()

{

    printf("S: status\tM: rename\nC: Chdir\tX: delete\n");
    printf("1: find first\tK: remove dir\n");
    printf("N: find next\tD: make dir\nO: open\t\tA: set attributes\nR: read\t");
    printf("\tI: get attributes\nW: write\nV: Create\nU: unmount\n");
    printf("E: close\nP: seek\n");
}

/*
 * Process characters from the keyboard with limited line format control such
 * as kill-word, erase-line, literal-next-character and backspacing. Returns the
 * total number of bytes saved.
 */

unsigned int toytty()


{
    char fct;
    unsigned int bytes = 0;

    do {
	fct = getch();
	if (fct == CTLV) {	/* ^V: literal next char */
	    fct = getch();
	    fish1[bytes++] = fct;
	    emitchar(fct);
	    fct = 0;		/* conceal previous value */
	    continue;
	} else switch (fct) {
	    case CTLU:		/* ^U */
		putchar('\n');
		while (bytes > 0 && fish1[bytes] != '\n')
		bytes--;
		break;

	    case CTLW:		/* ^W */
		while (--bytes > 0 &&  fish1[bytes] != ' ' && 
		    fish1[bytes] != '\t' && fish1[bytes] != CTLL)
		    rubout();
		bytes++;
		break;

	    case CTLH:		/* ^H */
	    case DEL:		/* ^? */
		bytes--;
		rubout();
		break;

	    default:
		emitchar(fct);
		fish1[bytes++] = fct;
        }
    } while(fct != CTLD && bytes < BSIZ);

    return(bytes);
}
