TITLE	NFS options parser
SUBTTL	Option file reader
NAME	NFSOPTIONS
PAGE	60,132

COMMENT	@

	Agricon International Inc	March 22, 1993	David C. Brown IV

	See files COPYING and COPYWRT for copyright information. Copyright (C)
	Agricon International Inc. 1993

	This program module handles reading the given options file. It seeks
	tokens which may be delimited by whitespace (blank, tab, newline) or
	the characters :;= as well.

	These tokens are either the names of certain load-time modifiable
	options, or the values to be assigned to those options. Comments are
	permitted inside the file. Any line that begins with # is ignored up
	to the newline character that ends it. The entire file is read and
	any public values accessable to this module are changed accordingly.

	@

;****** Manifest Constants ******************************************************
;********************************************************************************

DOSCALL	equ	21h
FCREAT	equ	3ch		; create file and return handle
FOPEN	equ	3dh		; open existing file & return handle
FCLOSE	equ	3eh		; close file & return handle
FREAD	equ	3fh		; read from handle
FWRITE	equ	40h		; write to handle
FUNLNK	equ	41h		; delete file
FSEEK	equ	42h		; seek handle
FATT	equ	43h		; manage attributes
EXIT	equ	4ch		; Exit with a return code
DOS_STR	equ	9		; DOS' most basic string printing function

; Other manifest constants

newline	equ	0ah		; standard UNIX newline char.
return	equ	0dh		; the carriage return for our DOS console
tab	equ	9
bksp	equ	8
cr	equ	return
lf	equ	newline

MAXGROUPS	equ	8	; Total number of group entries allowed
MAXTOKENLEN	equ	256	; Longest token allowed in bytes

;****** Structures **************************************************************
;********************************************************************************

;****** Macros ******************************************************************
;********************************************************************************

; Force uppercase text characters, leave other characters alone
; Note this only works for the ASCII collating sequence. NOT EBCDIC

toupper	MACRO		; The character is assumend to be in AL
	LOCAL	done
	cmp	al,'a'
	jl	done	;; Below lowercase a, leave it alone
	cmp	al,'z'
	jg	done	;; likewise if above a lowercase z
	and	al,0dfh
done:
	ENDM

; This macro test the character in AL to see if it is a whitespace character.
; Tabs, spaces, carriage returns and line feeds will pass the test, form feeds
; ARE NOT tested.

; Result: ZF set if character in AL is whitespace

iswhite	MACRO		; The character to be tested is assumed in AL
	LOCAL	wout
	cmp	al,' '
	jz	wout
	cmp	al,tab
	jz	wout
	cmp	al,newline	;; Handle either newlines or carriage returns
	jz	wout
	cmp	al,return
wout:
	ENDM

; Simply clear the zero flag if the end of the file was reached

feof	MACRO
	test	[eof],0ffh
	ENDM

;****** Segments ****************************************************************
;********************************************************************************

Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
BUFFER	ENDS

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
ifndef	STANDALONE
	extrn	cannedip:dword,credits:word,hostid:dword
	extrn	hostname:byte,drive_no:byte
	extrn	mountp:byte
else
credits		dd	100, 0				; UID/GID
		dd	4				; count of groups
		dd	0, 0, 20, 31, 0, 0, 0, 0	; space for credit groups
hostid		dd	32768
cannedip	db	80h,0e3h,0a4h,0c2h,80h,0e3h,0a4h,0c1h
hostname	db	'megalon.agricon.com',0,16 dup (0)
drive_no	db	5
mountp		db	'/usr',0,59 dup (0)
endif
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

SUBTTL Discardable section

;***** Data Segment ************************************************************
;*******************************************************************************

data	SEGMENT	WORD	PUBLIC	'DATA'

	PUBLIC	grptr, grnums

fhandle		dw	0

grptr		dw	offset ResGroup:[credits+12]	; start of group entries

; switch label storage

delims		db	tab,newline,return,'=;: ',0
delimlen	equ	$-delims
eof		db	0
charbuf		db	0
token		db	MAXTOKENLEN dup (?)
hostipstr	db	'hostip',0
myipstr		db	'myip',0
drivestr	db	'drive',0
uidstr		db	'uid',0
hostidstr	db	'hostid',0
mynmstr		db	'myname',0
mountstr	db	'mount',0
gidstr		db	'gid',0
crgroup		db	'group',0

grnums		db	MAXGROUPS	; # of group entries read.

; Here's the ASCIIZ name for the file. The default is CONFIG.NFS but we can
; override this later via the command line. That's why 64 chars are reserved.

	PUBLIC	cfgfile
cfgfile		db	'config.nfs'
		db	64 - ($ - offset cfgfile) dup (0)
data	ENDS

;***** Stack Segment ***********************************************************
;*******************************************************************************

ifdef	STANDALONE
stack	SEGMENT	PARA	STACK	'STACK'
	dw	64 dup (?)
stack	ENDS
endif

;***** Code Segment ************************************************************
;*******************************************************************************

trans	SEGMENT	PARA	PUBLIC	'CODE'

	PUBLIC	strcpy, atoi, cvtip

ifndef	STANDALONE
	ASSUME	cs:trans,ds:data,ss:ResStack,es:ResGroup
else
	ASSUME	cs:trans,ds:data,ss:stack,es:ResGroup
endif

; Compare the character in AL against our list of accepted delimiters

; Result: ZF clear if character in AL is in delimiter string

isdelim	PROC	NEAR
	push	cx
	push	di
	push	es
	mov	di,data
	mov	es,di
	lea	di,[delims]	; The list of delimiters
	mov	cx,delimlen	; Limit on number of delimiters to check
	repnz scasb
	and	cx,cx		; CX = 0 implies no matches
	pop	es
	pop	di
	pop	cx
	ret
isdelim	ENDP

; Get another character from the file via DOS' read function. No effort is
; made to buffer the input because DOS already provides a small buffer. The
; character is returned in AL. If there was some problem CF will be set. If
; EOF occurs then the EOF flag will be set

getchar	PROC	NEAR
	push	dx
	push	cx
	push	bx
	mov	bx,[fhandle]	; Our options file
	mov	cx,1		; Just get one character
	lea	dx,[charbuf]	; Where to put it
	mov	ah,FREAD
	int	DOSCALL
	jc	rdout		; problem accessing file?
	and	al,al		; If al == 0 then EOF; set flags
	jnz	rdvlid
	mov	[eof],0ffh
rdvlid:	mov	al,[charbuf]	; get character just read into AL
rdout:	pop	bx
	pop	cx
	pop	dx
	ret
getchar	ENDP

; Copy the far-addressed string passed as parameter 2 into the far-addressed
; string passed as parameter 1.
;
;	strcpy(char far *dest, char far *source);

strcpy	PROC	NEAR
	push	bp
	mov	bp,sp
	push	di
	push	es
	push	si
	push	ds
	lds	si,[bp+4]
	les	di,[bp+8]
strmov:	test	byte ptr [si],0ffh	; End of the string?
	jz	strdid
	movsb				; continue copying
	jmp	strmov
strdid:	movsb				; Don't forget '\0' at end!
	pop	ds
	pop	si
	pop	es
	pop	di
	pop	bp
	ret	8
strcpy	ENDP

; Compare the two far-addressed strings on the stack. If they differ return
; zero flag clear, otherwise return zero flag set. We can't use the Intel cmpsb
; primative since we want to ignore letter case here.
;
; stricmp(char far *str1, char far *str2);

stricmp	PROC	NEAR
	push	bp
	mov	bp,sp
	push	di
	push	es
	push	si
	push	ds
	lds	si,[bp+4]		; string 2
	les	di,[bp+8]		; string 1
cmpstr:	test	byte ptr [si],0ffh
	jz	cmpdid
	lodsb				; get char from string 2
	toupper				; force to upper case for comparison
	mov	ah,al			; save in ah
	xchg	di,si			; Now address string 1
	lods byte ptr es:[si]
	xchg	di,si			; restore addresses
	toupper				; force string 1 to uppercase
	sub	ah,al			; chars match?
	jz	cmpstr
cmpdid:	pop	ds
	pop	si
	pop	es
	pop	di
	pop	bp
	ret	8
stricmp	ENDP

; Convert the far addressed string into a longword. Return the result in
; DX:AX. Pointer in DS:SI points to next non-numeric character.
;
; long atoi(char far *);

atoi	PROC	NEAR
	push	bp
	mov	bp,sp
	push	cx
	push	bx
	push	di
	xor	ax,ax			; Zero out the longword registers
	mov	dx,ax
	mov	cx,ax			; zero out upper part of CX
	mov	bx,10
	lds	si,[bp+4]		; load far address of string
nxtdig:	mov	cl,byte ptr [si]	; get the next digit
	inc	si
	sub	cl,'0'			; convert ASCII to binary
	jl	atoix			; Is the number an ASCII digit?
	cmp	cl,9
	jg	atoix
	push	ax			; x86 MUL won't do DX:AX * # so we
	mov	ax,dx			; carefully partition the multiply
	mul	bx			; Shift results over by power of 10
	mov	di,ax			; Save modulo 65536 value...
	pop	ax			; recover accumulated values
	mul	bx			; finish off multiply
	add	ax,cx			; now add in the newest digit
	adc	dx,di			; compute sum. Note MUL * 10 always OK
	jmp	nxtdig			; keep going
atoix:	dec	si			; compensate for Intel's post-increment
	pop	di
	pop	bx
	pop	cx
	pop	bp
	ret	4
atoi	ENDP

; Take the ASCII ip address and convert it into a longword. The string is
; read right to left, and periods delimit it into 4 fields. All 4 fields need
; to be present if the number is to be scaled correctly. The destination's
; far address (longword) is passed on the stack first, and the far address
; of the ip string is passed next.
;
; cvtip(unsigned long far *ipaddr, char far *ipstr);

cvtip	PROC	NEAR
	push	bp
	mov	bp,sp
	push	dx
	push	di
	push	es
	push	si
	push	ds
	xor	ax,ax
	mov	dx,ax
	lds	si,[bp+4]		; The ip string
	les	di,[bp+8]		; The ip result
cvtnxt:	test	byte ptr [si],0ffh	; End of string yet?
	jz	didcvt
	mov	dh,dl			; *ipaddr <<= 8;
	mov	dl,ah
	mov	ah,al
	xor	al,al			; clear out LSN
	mov	es:[di+2],dx		; Save the work so far
	mov	es:[di],ax
	push	ds
	push	si
	call	atoi			; Convert the next subnet
	add	ax,es:[di]		; and accumulate
	adc	dx,es:[di+2]		; *ipaddr += atoi(ipstr);
	cmp	byte ptr [si],'.'	; Step over period delimiter
	jnz	didcvt
	inc	si
	jmp	cvtnxt
didcvt:	xchg	dh,dl			; Convert the values into network
	xchg	ah,al			; order!
	mov	es:[di],dx		; Save final value, network ordered.
	mov	es:[di+2],ax
	pop	ds
	pop	si
	pop	es
	pop	di
	pop	dx
	pop	bp
	ret	8
cvtip	ENDP

; Read another token from the input stream. Return a far pointer to the token.
; Pointer will be in DS:SI

gettoken	PROC	NEAR
	push	di
	push	es
	mov	di,ds
	mov	es,di
whltok:	feof			; end of file?
	jnz	toked		; while (!feof(infile)) {
	lea	di,[token]
skpwht:	call	getchar		;     while (iswhite(c = getchar()))
	jz	toked		; deal with EOF if it comes up
	iswhite
	jz	skpwht		;         continue;
	cmp	al,'#'		;     if (c == '#')
	jnz	vlidtk
cmmnt:	call	getchar		; We have a comment, skip over it.
	jz	toked		; be ready in case file ends
	cmp	al,newline	;         while ((c = getchar()) != '\n')
	jz	vlidtk
	cmp	al,return
	jnz	cmmnt		;             continue;
	jmp	whltok
vlidtk:	call	isdelim
	jnz	toked
	stosb
	call	getchar
	jz	toked		; deal with EOF if encountered.
	jmp	vlidtk
toked:	xor	ax,ax
	mov	[di],al
	cmp	di,offset token
	lea	si,[token]
	jnz	tokok
	mov	si,ax
tokok:	pop	es
	pop	di
	ret
gettoken	ENDP

parseparams	PROC	NEAR
	push	es
	mov	ax,ResGroup
	mov	es,ax
prslp:	feof		; Check for end of file.
	jz	pprm1
	jmp	parok
pprm1:	call	gettoken	; read in a full token. Token's pointer in DS:SI
	and	si,si
	jnz	pprm2		; Token wasn't found
	jmp	parok
pprm2:	push	ds
	push	si
	lea	ax,[hostipstr]
	push	ds
	push	ax
	call	stricmp
	jnz	tst01
	call	gettoken
	mov	ax,ResGroup
	push	ax
	lea	ax,[cannedip+4]
	push	ax
	push	ds
	push	si
	call	cvtip
	jmp	prslp

tst01:	push	ds
	push	si
	lea	ax,[myipstr]
	push	ds
	push	ax
	call	stricmp
	jnz	tst02
	call	gettoken
	mov	ax,ResGroup
	push	ax
	lea	ax,[cannedip]
	push	ax
	push	ds
	push	si
	call	cvtip
	jmp	prslp

tst02:	push	ds
	push	si
	lea	ax,[drivestr]
	push	ds
	push	ax
	call	stricmp
	jnz	tst03
	call	gettoken
	mov	al,byte ptr [si]
	sub	al,'@'
	mov	es:[drive_no],al
	jmp	prslp

tst03:	push	ds
	push	si
	lea	ax,[uidstr]
	push	ds
	push	ax
	call	stricmp
	jnz	tst04
	call	gettoken
	push	ds
	push	si
	call	atoi
	mov	word ptr es:[credits],ax
	jmp	prslp

tst04:	push	ds
	push	si
	lea	ax,[hostidstr]
	push	ds
	push	ax
	call	stricmp
	jnz	tst05
	call	gettoken
	push	ds
	push	si
	call	atoi
	xchg	ah,al		; convert to network longword
	xchg	dh,dl
	mov	word ptr es:[hostid],dx
	mov	word ptr es:[hostid+2],ax
	jmp	prslp

tst05:	push	ds
	push	si
	lea	ax,[mynmstr]
	push	ds
	push	ax
	call	stricmp
	jnz	pprm6
	call	gettoken
	push	es
	lea	ax,[hostname]
	push	ax
	push	ds
	push	si
	call	strcpy
	jmp	prslp
;
;------ Set the desired path to our mount point
;
pprm6:	push	ds		; The token to be tested
	push	si
	lea	ax,[mountstr]	; The keyword
	push	ds
	push	ax
	call	stricmp		; The test.
	jnz	pprm7
	call	gettoken
	push	es		; Far pointer to mount point
	lea	ax,[mountp]
	push	ax
	push	ds		; Far pointer to token
	push	si
	call	strcpy
	jmp	prslp
;
;------ Set credit groups
;
pprm7:	push	ds		; Token to be tested
	push	si
	lea	ax,[crgroup]
	push	ds		; the keyword
	push	ax
	call	stricmp		; Nonzero means failure
	jnz	pprm8
	call	gettoken
	dec	[grnums]	; Only room for a few group entries
	jge	grok		; so don't record more than that
	jmp	prslp
grok:	inc	byte ptr es:[credits+8]
	push	ds
	push	si
	call	atoi
	push	di
	mov	di,[grptr]	; current group entry to be set
	mov	es:[di],ax	; Copy over the group number.
	mov	es:[di+2],dx
	add	[grptr],4
	pop	di
	jmp	prslp
;
;------ Set the initial GID field
;
pprm8:	push	ds		; Token's far pointer
	push	si
	lea	ax,[gidstr]
	push	ds		; keyword's far pointer
	push	ax
	call	stricmp
	jnz	tstlp
	call	gettoken
	push	ds
	push	si
	call	atoi		; convert to binary & save
	mov	word ptr es:[credits+4],ax
tstlp:	jmp	prslp
parok:	pop	es
	ret
parseparams	ENDP

; Open the configuration file for reading via DOS' function calls

fopen	PROC	NEAR
	lea	dx,[cfgfile]	; ASCIIZ file name
	mov	ah,FOPEN
	mov	al,0		; No special modes
	int	DOSCALL
	jc	didopn
	mov	[fhandle],ax	; handle if successful
didopn:	ret
fopen	ENDP

; Close the file we were reading.

fclose	PROC	NEAR
	mov	bx,[fhandle]
	mov	ah,FCLOSE
	int	DOSCALL
	ret
fclose	ENDP

	PUBLIC	opts

opts	PROC	NEAR
ifdef	STANDALONE
	mov	ax,data
	mov	ds,ax
endif
	call	fopen
	jc	optfld
	call	parseparams
	call	fclose
ifdef	STANDALONE
optfld:	mov	ah,EXIT
	mov	al,2
	int	DOSCALL
else
optfld:	ret
endif
opts	ENDP
trans	ENDS
	END	opts
