TITLE Host Directory Parsing Module
SUBTTL Map NFS calls onto RPC
NAME   DCBNFS
PAGE   60,132

COMMENT @

	See files COPYING and COPYWRT for copyright information. Copyright (C)
	Agricon International Inc. 1993

	The functions in this module are concerned with tracking down entries
	from the host based on elements of a path. They deal with the path
	one entry at a time so that NFS does not need to worry about path
	separators and other things. Usually a string pointer is passed on
	the stack that is used to resolve the path one entry at a time. Many
	functions take far pointers so that they may update a structure as
	requested.

	Starting with this layer we resolve calls into an NFS specific sequence.
	Lower layers will merge this into an RPC format and finally TCP/IP
	or UDP protocols.

	@

;***** Equates *****************************************************************
;*******************************************************************************

ETN	equ	11		; Standard DOS name of 8 chars. + 3 char ext.
MAXPTH	equ	67		; Maximum path allowed, with 3 chars. overhead
NFSHANDLEN	equ	32

TRIAL	equ	3		; How many retries?

cr	equ	0dh
lf	equ	0ah

;***** NFS Equates *************************************************************

VDIR	equ	2	; Directory flag
VREG	equ	1	; file flag

NFS_NULL	equ	0
NFS_LOOK	equ	4
NFS_RDDIR	equ	16

;***** Structures **************************************************************
;*******************************************************************************

;***** NFS data structures *****************************************************

; Beware: the real NFS dirent structure is variable length. Copy them into
; this fixed-length structure to simplify location of the NFS_COOKIE field.
; if the name is > 11 characters we truncate it.

NFS_DIRENT	STRUC
inode		dd	0deadbeefh
nfsnamelen	db	13
nfsname		db	'hosehead.',cr,lf,'$',0
nfscookie	dw	20
NFS_DIRENT	ENDS

NFS_ATTRH	STRUC
NFS_HANDLE	db	NFSHANDLEN dup (?)
nfspad1		db	0,0,0		; network order data
nfstype		db	VDIR
nfspad2		dw	0		; network order high part of mode
nfsmode		dw	0
nfslinks	dd	1		; unsed
nfsids		dd	0,0		; uid/gid unused
nfssize		dd	0		; file size in bytes
nfsbsize	dd	0		; blocksize unused
nfsrdev		dd	0		; raw device id unused
nfsfsid		dd	0,0		; file system quadword unused
nfsinode	dd	0		; inode unused
nfsatime	dd	63c0190fh	; Access time unused.
		dd	0
nfsmtime	dd	63c0190fh	; August 15, 1992 @ 12:30pm
		dd	0
nfsctime	dd	63c0190fh	; creation time unused
		dd	0
NFS_ATTRH	ENDS

;***** External Data/Functions *************************************************
;*******************************************************************************

	; You can sneak external fct. declarations out here because the
	; assembler is told they are near calls. Data doesn't always work
	; that well because the assembler may make the wrong decision in
	; computing the offsets or selecting a segment register. Only a
	; problem with multiple segments and GROUP directives.

	extrn	htonds:near,nfsheader:near,nfsreqst:near
	extrn	TXFAIL:abs,RXFAIL:abs,RPCVFL:abs,RPCSIZ:abs

SUBTTL Segments
PAGE+

;**** Segments resident after TSR ********************************************
;*****************************************************************************

;**** Resident code **********************************************************
;	This segment is declared first so the linker will load it first. It is
;	where the routines that service the interrupts go. The TSR is started
;	only in the event of an interrupt. The startup code comes later and
;	is jettisoned.


Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
	extrn	TXpktb:byte
BUFFER	ENDS

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
	extrn	mounthandle:word,RootOffs:word
	extrn	curdirh:word,OurCDS:dword

	PUBLIC	lowmask

lowmask	db	0	; Zero if we don't do letter case conversion
nettry	db	TRIAL
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

SUBTTL Resident code
PAGE+

;**** Resident interrupt handling code **************************************
;****************************************************************************

;	Every effort has been made to keep segments "pure" --in other words,
;	segments that are to be executed are not written in this code. This
;	is to allow compatibility with protected environments. It is unlikely
;	that this TSR will be ported to such an environment, but portions of
;	it may be adaptable to other uses. The overhead of writing with this
;	in mind will pay off in those cases.

Restext	SEGMENT	PARA	PUBLIC	'TEXT'

	PUBLIC	nfs_readdir,nfs_lookup,descend
	PUBLIC	backup,CDdescend
	ASSUME	cs:ResGroup,ds:ResGroup,ss:ResStack,es:NOTHING

; Provide some NFS specific service calls. Here we read a directory entry and
; return the result. A parameter/value structure is used for the data.
; Arguments are: a pointer to the current directory handle, to be used for
; NFS server calls, the NFS_COOKIE to indicate the next directory entry we want,
; and a pointer for the entry to be returned once it is found.

; nfs_readdir(struct far nfs_dir *, NFS_COOKIE, struct far nfs_attrh *);

nfs_readdir	PROC	NEAR
	push	bp
	mov	bp,sp			; typical stack-frame stuff
	push	si
	push	ds
	push	di
	push	es
	push	cx
	mov	[nettry],TRIAL		; Allow this many retries
;
;------ Prepare the packet with an NFS header
;
	mov	di,BUFFER
	mov	es,di
nfsrdh:	mov	di,offset BUFFER:TXpktb
	push	[bp+6]			; get the current directory handle
	push	[bp+4]
	xor	ax,ax			; now the function longword
	push	ax
	mov	ax,NFS_RDDIR
	push	ax
	call	nfsheader
	mov	ax,32		; minimum acceptable reply size
	push	ax
	xor	ax,ax		; copy the NFS cookie into the packet.
	stosw			; this is really just an offset into the
	mov	ax,[bp+8]	; current directory for the next entry.
	xchg	ah,al		; convert it into network format.
	stosw
	xor	ax,ax
	stosw
	mov	ax,48+256	; maximum entry size we accept.
	xchg	ah,al
	stosw
	call	nfsreqst
	jnc	nfsrdt
;
	cmp	ax,TXFAIL	; Transmit failures aren't retried.
	jz	rdnogo
	dec	[nettry]	; Receiver/RPC's get TRIAL chances
	jnz	nfsrdh
rdnogo:	xor	ax,ax
	stc
	jmp short nfsrdx

nfsrdt:	push	es		; convert the fields so that they're
	push	di		; easier to read.
	push	es
	push	di
	mov	ax,3
	push	ax
	call	htonds
	cmp	word ptr es:[di],1	; any more entries?
	jz	nfsrdmore
	xor	ax,ax
	jmp short nfsrdx
nfsrdmore:
	lea	di,[di+8]		; skip to name length field
	cmp	word ptr es:[di],ETN+1	; larger than we can have in DOS?
	jle	nfsrdvlid
	mov	ax,es:[di]	; skip over the name...
	add	ax,7		; promote to longword boundary also
	and	ax,0fffch	; skip over our current namesize longword
	add	di,ax
	mov	ax,es:[di+2]	; get the NFS_COOKIE: offset for next entry.
	xchg	ah,al		; convert to host format
	mov	[bp+8],ax	; Specify that as the entry to find.
	jmp	nfsrdh		; try another one.

nfsrdvlid:
	mov	si,es		; reference the entry string.
	mov	ds,si
	lea	si,[di-4]	; point back to inode field.
	les	di,[bp+0ah]	; ES for destination...
	movsw			; copy over the inode
	movsw
	mov	cx,[si]		; name length (already host converted.)
	mov	ax,cx
	lea	si,[si+4]	; skip over name length field now.
	stosb			; store the length of the name too.
	rep movsb		; copy the actual string.
	xor	al,al		; terminate with a null.
	stosb
	lea	si,[si+3]	; round to nearest lword bound. & skip
	and	si,0fffch	; 1/2 lword farther. This converts to
	mov	ax,[si+2]	; psuedo host format.
	mov	di,[bp+0ah]	; write to fixed size nfs_dirent struct
	lea	di,[di].nfscookie
	xchg	ah,al		; finish conversion
	stosw			; save the NFS COOKIE.
	mov	ax,[bp+0ah]	; return pointer to data

nfsrdx:	pop	cx
	pop	es
	pop	di
	pop	ds
	pop	si
	pop	bp
	ret	0ah
nfs_readdir	ENDP

; This function will take the file name given and search the current
; directory for the attributes of that name. It will fill the structure
; given via a pointer with those attributes & the NFS handle for that file.
;
; nfs_lookup(char *file, NFS_ATTRH far *curdirh, NFSATTRH far *foundh);

nfs_lookup	PROC	NEAR
	push	bp
	mov	bp,sp
	push	cx
	push	si
	push	ds
	push	di
	push	es
	mov	[nettry],TRIAL

;!!!!!! BEWARE this function's name collides with the NFS call.

	mov	di,BUFFER		; We need to point to the outgoing
	mov	es,di			; packet for the nfs routines.
lkretr:	mov	di,offset BUFFER:TXpktb
	push	[bp+8]			; pass the given directory handle.
	push	[bp+6]
	xor	ax,ax			; give the NFS function desired.
	push	ax
	mov	ax,NFS_LOOK
	push	ax
	call	nfsheader		; Set up the function call & RPC
;
;------ Copy the name we wish referenced, insert its length in network order.
;
	xor	ax,ax		; initialize the length field to zero. This
	stosw			; saves going back & setting msw which = 0
	stosw			; for DOS lookups, & increments di for us.
	push	di
	mov	si,[bp+4]		; reference passed string parameter
nlkstr:	lods	byte ptr ss:[si]
	and	al,al
	jz	nlkszc			; copy up to the null from the stack.
	stosb				; Leave out the null terminator.
	jmp	nlkstr
nlkszc:	mov	ax,di
	mov	cx,di			; save copy of packet length too.
	pop	di
	sub	ax,di
	xchg	ah,al			; network order, as always.
	mov	es:[di-2],ax
	mov	di,cx			; point back to packet's end.
nlkrnd:	test	di,3			; round up to a longword boundary
	jz	nlkalg
	stosb				; al = 0, nw order, DOS len < 12 chars
	jmp	nlkrnd
nlkalg:	mov	ax,size NFS_ATTRH	; how much to expect back...
	push	ax
	call	nfsreqst		; Do the request/verify thing...
	jnc	nlkcpy			; good data gets copied.
;
	cmp	ax,TXFAIL
	jz	lknogo
	cmp	ah,RPCSIZ		; If file isn't present don't retry.
	jz	lkno2			; (RPCSIZ => RX bytes < expected bytes)
	dec	[nettry]
	jnz	lkretr
lknogo: stc
lkno2:	sbb	ax,ax
	jmp short nlkupx
;
;------ Copy from the packet buffer to the user data on the stack.
;
nlkcpy:	mov	si,es
	mov	ds,si
	mov	si,di
	les	di,[bp+0ah]		; destination structure.
	mov	cx,NFSHANDLEN / 2
	rep movsw			; copy over the host handle
	push	ds		; now convert attributes to network
	push	si		; format. This copies source -> dest
	push	es		; as it converts!
	push	di
	mov	ax,((size NFS_ATTRH) - NFSHANDLEN) / 4
	push	ax
	call	htonds
	mov	ax,[bp+0ah]
	and	ax,ax
nlkupx:	pop	es
	pop	di
	pop	ds
	pop	si
	pop	cx

	pop	bp
	ret	0ah
nfs_lookup	ENDP

; This function will descend the directory tree, comparing two paths. The
; point where they differ is retained. Then it works up from the current
; directory until this point via nfs calls for the parent directory. It then
; moves down the new context until the end of the path is reached. For files
; the last item is NOT requested since it may contain global characters.
; Far pointers to the current and requested paths are passed, and a pointer
; to an NFS handle. This handle will be updated if the call succeeds.

; xxdescend(char far *CDS, char far *name, struct nfs_attrh far *);

CDdescend	PROC	NEAR
	push	bp
	mov	bp,sp		; frame pointer for params & local vars
	sub	sp,28		; char *i, *j, *m, *n, *p, c, string[13], x;
	push	si
	push	di
	push	es
	push	cx

	push	es
	les	di,[bp+8]	; name
	xor	cx,cx
	mov	al,cl
	dec	cx
	repnz scasb 		; pointer to end of string to go along with
	dec	di		; SCASB overshoots by one
	mov	[bp-0eh],al	; c = 0;
	mov	[bp-0ch],di	; p = end of name
	mov	ax,di
	pop	es
	jmp short laterstuff
;
;------ Entry point for file/directory searches. Last element in name skipped
;
descend:
	push	bp
	mov	bp,sp		; Get frame pointer for params & local vars.
	sub	sp,28		; char *i, *j, *m, *n, *p, c, string[13], x;
	push	si
	push	di
	push	es
	push	cx

	push	[bp+0ah]	; Get the new path & cut last entry off
	push	[bp+8]		; name for now...
	call	backup
	mov	[bp-0ch],ax	; p = backup(name);

laterstuff:
	sub	ax,[bp+8]	; p - name
	cmp	ax,[RootOffs]
	jnz	notroot
;
;------ The request puts us at root and this entry is always retained!
;
	lea	si,[mounthandle]
	les	di,[bp+0ch]		; the return vale for success
	mov	ax,di			; copy the value to the local var.
	mov	cx,size NFS_ATTRH	; and fill it in
	rep movsb
	pop	cx
	pop	es
	pop	di
	pop	si
	mov	sp,bp			; deallocate frame
	pop	bp
	ret	0ch

notroot:
	mov	al,[lowmask]		; Get mask out of data segment since
	mov	[bp-1dh],al		; We won't be able to reach it later.
	push	ds			; we'll need ds from time to time...
	lds	ax,dword ptr [bp+4]
	mov	[bp-4],ax		; i = CDSstr;
	les	ax,dword ptr [bp+8]
	mov	[bp-6],ax		; j = name;
	mov	si,[bp-0ch]
	mov	al,es:[si]
	mov	[bp-0eh],al		; c = *p;
	mov	byte ptr es:[si],0	; *p = '\0';

	mov	si,[bp-4]		; while (*i
	mov	di,[bp-6]		;     && *j) {
whlds1:	test	byte ptr [si],0ffh
	jz	diflvl
	test	byte ptr es:[di],0ffh
	jz	diflvl			; /* Next token or mis-match */
	mov	[bp-8],si		;     for (m = i,
	mov	[bp-0ah],di		;         n = j;
fds1a:	mov	al,[si]			;         *m == *n &&
	cmp	al,es:[di]
	jnz	dsfnd1		; Could optimize to "jnz diflvl"
	cmp	al,'\'			;         *m != '\\' &&
	jz	dsfnd1
	and	al,al			;         *m;
	jz	dsfnd1
	inc	si			;         m++,
	inc	di			;         n++)
	jmp	fds1a			;         continue;
dsfnd1:	mov	[bp-8],si		; restore coherence between m, n
	mov	[bp-0ah],di		; and registers
	mov	ah,es:[di]		;     if ((*m == '\\' && !*n) ||
	add	ah,al			;         (!*m && *n == '\\'))
	cmp	ah,'\'
	jz	whltok			;         goto newtok;
	cmp	al,es:[di]		;     if (*m != *n)
	jnz	diflvl			;         break;
	cmp	al,'\'			;     if (*m == '\\') {
	jnz	whltok			;   /* point to next token */
	inc	si			; 	    m++;
	inc	di			; 	    n++; }
whltok:	mov	[bp-4],si		; newtok: i = m; /* New token or \0 */
	mov	[bp-6],di		;     j = n;
	jmp	whlds1			; }
diflvl:
	pop	ds
	les	di,[bp+0ch]
	lea	si,[curdirh]		; lastdir = curdirh;
	mov	[bp-2],di
	mov	cx,size NFS_ATTRH
	rep movsb

goup:	mov	di,[bp-6]		; n = j;
	mov	[bp-0ah],di
	les	di,[bp+4]		; j = CDSstr
	mov	al,cl			; REMEMBER: scasb is es:[di]!!!!
	dec	cx			; CX already 0, make it -1
	repnz scasb			; while (*j) j++;
	dec	di			; scasb's compulsory post incr overshot
	cmp	byte ptr es:[di-1],'\'	; if (*(j - 1) == '\\')
	jnz	dswhl2			; /* Don't count token sep. twice */
	sub	di,2			;     j -= 2;
dswhl2:	mov	[bp-6],di		; while (j > i) {
	cmp	[bp-4],di
	jae	godwn
	mov	cx,di			; /* Back up to next FULL token */
	sub	cx,[bp-4]		; Don't back up over the root part!
	mov	al,'\'			;     while (j > i && *j != '\\')
	std
	repnz scasb			;         j--;
	cld
	push	[bp+0eh]		;         &lastdir);
	push	[bp+0ch]
	push	[bp+0eh]		;         &lastdir,
	push	[bp+0ch]
	mov	byte ptr [bp-0fh],0	;         ".."
	mov	word ptr [bp-11h],'..'
	lea	ax,[bp-11h]
	push	ax
	call	nfs_lookup		;     nfs_lookup(
	mov	[bp-2],ax		; save return value
	jbe	dshack			; bail out: Network error
	dec	di			;     j--;
	jmp	dswhl2			; }

godwn:	push	ds
	mov	ds,[bp+0ah]		; search from *name's segment
	mov	ax,ss			; address string dest. from stack.
	mov	es,ax
	mov	si,[bp-0ah]
	cmp	byte ptr [si],'\'	; if (*n == '\\')
	jnz	dswhl3
	inc	si			;     n++;
dswhl3:	test	byte ptr [si],0ffh	;     while (*n) {
	jz	dswnd2
	lea	di,[bp-1bh]		;         m = string
dswhl4:	cmp	byte ptr [si],'\'	;         while (*n != '\\'
	jz	dswnd4
	test	byte ptr [si],0ffh	;             && *n)
	jz	dswnd4
	movsb				;             *m++ = *n++;
	test	byte ptr [bp-1dh],0ffh		; /* force case conversion? */
	jz	dswhl4			;         if (!x) continue;
	cmp byte ptr [si-1],'A'		;         if (*(m - 1) >= 'A' &&
	jb dswhl4
	cmp byte ptr [si-1],'Z'		;             *(m - 1) <= 'Z')
	ja dswhl4			; /* Force to lowercase ASCII */
	or byte ptr es:[di-1],20h	;             *(m - 1) |= 0x20h;
	jmp	dswhl4
dswnd4:	mov	byte ptr ss:[di],0	;         *m = 0;
	pop	ds
	push	[bp+0eh]		;             &lastdir);
	push	[bp+0ch]	
	push	[bp+0eh]		;             &lastdir,
	push	[bp+0ch]
	lea	ax,[bp-1bh]		;             string,
	push	ax
	call	nfs_lookup		;         nfs_lookup(
	mov	[bp-2],ax		; return value
dshack:	push	ds			; /* Goup breaks in here if exiting */
	mov	ds,[bp+0ah]		; /* tweak DS & stack before exiting */
	jbe	dswnd2			; /* network error, just give up. */
	test	byte ptr [si],0ffh	;         if (*n)
	jz	dswhl3
	inc	si			;             n++;
	jmp	dswhl3			;     }
dswnd2:	mov	si,[bp-0ch]
	mov	al,[bp-0eh]
	mov	[si],al			; *p = c;
	pop	ds
	mov	ax,[bp-2]		; get back return value
	cmp	ax,-1
	jnz	rtout			; Don't be sending -1 = network error
	xor	ax,ax			; back. Calling fcts only know 0 = bad.

rtout:	pop	cx
	pop	es
	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	ret	0ch
CDdescend	ENDP

; Step back over last entry in a path but don't go back past the root entry.
; The name to be searched is passed on the stack but DOS' global data structures
; are assumed.

backup	PROC	NEAR
	push	bp
	mov	bp,sp
	push	cx
	push	di
	push	es
	push	si
	push	ds

	les	di,[OurCDS]
	mov	cx,[RootOffs]
	lds	si,dword ptr [bp+4]
	rep cmpsb
	jcxz	rtok
	xor	ax,ax		; host part didn't match, bail out.
	stc
	jmp short bkout

rtok:	mov	di,si	; save root offset (CX already zero from jump)
	mov	ax,ds
	mov	es,ax
	mov	al,cl
	mov	cl,MAXPTH
	repnz scasb		; locate end of string
	dec	di		; scasb's post-increment overshoots.
	mov	cx,di		; now back up to first '\'
	sub	cx,si		; if @ root we're done
	mov	al,'\'
	std
	repnz scasb
	cld
	inc	di
	jcxz	shbk
	inc	di		; clear post-decrement & point to the
shbk:	mov	ax,di		; first char *after* '\'
	clc
bkout:	pop	ds
	pop	si
	pop	es
	pop	di
	pop	cx
	pop	bp
	ret	4
backup	ENDP

; The DS and ES registers to be used are taken off the stack. ES is
; pushed first for a call. SI AND DI ARE ASSUMED TO BE SET, AS IS
; THE CX REGISTER. This function *MUST* copy the string whether it
; folds letter case or not!

public	tolower

tolower	PROC	NEAR
	push	bp
	mov	bp,sp
	push	ds		; We may not be able to test
	push	es		; lowmask if source segment
	push	ax		; isn't the same as Resdata
	mov	ax,ResGroup	; Save mask in AH instead.
	mov	ds,ax
	mov	ah,20h		; Mask to force lowercase ASCII
	test	[lowmask],0ffh	; Was case folding selected?
	jnz	bother		; YUP, don't clobber mask. Else
	mov	ah,0		; NULL mask leave letters alone.
bother:	mov	ds,[bp+4]	; Source segment of string
	mov	es,[bp+6]	; Destination segment of string
foldmo:	lodsb
	cmp	al,'A'	; if < A then it's a control char.
	jb	nofold
	cmp	al,'Z'	; If > Z we don't care what it is.
	ja	nofold
	or	al,ah	; set according to mask
nofold:	stosb
	loop	foldmo
	pop	ax
	pop	es
	pop	ds
	pop	bp
	ret	4
tolower	ENDP
Restext	ENDS
	END

