TITLE Network Drive Interface
SUBTTL Transient Module (Loader/Remover)
NAME   DCBNFS
PAGE   60,132

COMMENT @

	Agricon International Inc.  	July 17, 1992		David C. Brown IV

	See files COPYING and COPYWRT for copyright information. Copyright (C)
	Agricon International Inc. 1993

	This program is based on the PASCAL program PHANTOM.PAS as described in
	the book "Undocumented DOS". (A. Schulman, et. al. Addison-Wesley,
	Reading, MA, ISBN 0-201-63287-X) It is intended to provide an interface
	to NFS via TCP/IP using DOS' network redirector function. There is
	nothing in this design which would exclude Novell NetWare from working,
	however the TCP/IP driver may cause some limitations.

	The lower modules convert the DOS calls into NFS functions and finally into
	RPC calls. The lowest module uses TCP/IP protocol with UDP packets. It
	talks to a packet driver to actually transmit and receive the packets.

	Communication is via the multiplex interrupt. The program is a TSR that is
	removed from memory by calling the multiplex interrupt with a function code
	that is not presently used by DOS. Any other communication should be managed
	by DOS itself.

	This particular module deals with loading the TSR and setting it up. It
	then removes any extra code and data to save valuable memory. The modules
	after this are all resident. If development is desired, a test-bed program
	can be linked instead of this program. It simulates calls to the NFS
	functions and can be written in a high-level language without changing
	the code much.

	The /ML assembler option is because we want to support the HLL test-bed
	in the lower modules. Here is how to build the program:

	masm /ML nfsload;
	link nfsload+nfs+dosmap,/NOI,nfs/MAP,nfslib+netlib;

	********** BEWARE! BEWARE! BEWARE! BEWARE! BEWARE! BEWARE! ***************

	**************************************************************************
	* What follows is somewhat outdated but left for historical reasons. If  *
	* you make changes to FNFS such as re-naming segments it may be helpful. *
	* OTHERWISE, this is just historical. FNFS has been fixed up so that it  *
	* assembles and links correctly now.                                     *
	**************************************************************************

	Presently the Microsoft linker takes what we call 'HEAP' in ResGroup
	as the stack to use upon program entry. This is not what I intended.
	Changing the combine type has no effect. It seems to prefer the class
	'HEAP' over 'STACK' or else the first declaration of either such class
	as the entry stack. The problem is that using something like DEBUG will
	destroy data on the stack[1]. The only fixup is to rename the .EXE file
	and change offset 10E hex to the offset listed in the map file produced
	by LINK (drop the least-significant nybble), then write the file and
	re-name it back to .EXE so that COMMAND.COM will load it. (Rename is
	important to prevent DEBUG from loading the file with fixup information[2],
	we only want to use it as a binary editor. COMMAND.COM will only execute
	files with .BAT .COM or .EXE extensions so you need to rename it again
	after saving it.) If we didn't do the stack swapping this wouldn't be
	necessary. Oh well, the correct thing will be to rename 'HEAP' to
	something else.

	[1] Actually, DEBUG doesn't destroy the data, we switch stacks but since
	the segment is the same things get really hosed up. DEBUG uses space
	*below* the current stack when context swaps occur at breakpts etc. This
	is how the trouble starts. On its own, the program may execute w/o error
	or it may *sometimes* hang. Once you fix the stack the trouble is gone.

	[2] DEBUG loads .EXE files & then resolves the segment-relative data to
	actual memory addresses. It cannot write .EXE files from memory back
	to disk because it has discarded the header information it used to make
	the memory resolutions[3]. The info still exists in the file but DEBUG
	can't work backwards from memory and disk info. Therefore, to edit an
	.EXE format file, rename it to some other extension (.BIN for instance)
	to fool DEBUG. It will read in the entire disk image of the file and you
	may edit it as necessary, then write it back.

	[3] Actually, DEBUG calls DOS to do the loading but defers exection via
	a special call. This call is discussed in "Undocumented DOS."

	>>>>>> Additional info: Since the above was written, [Not anymore, see
	block of ****** above all this stuff!] I changed the
	combine type of the stack segment and the same problem emerged. It seems
	LINK is using something else to decide, perhaps an ASSUME statement.
	BEWARE that you may need to cut back the initial SP saved at offset
	110 in the PSP if it is different from the size of stack LINK is using
	by mistake. (If ResStack > transient_stack, for instance, actual SP will
	be overlaying something outside of the patched up SS.)

	@

;***** Equates *****************************************************************
;*******************************************************************************

ETN	equ	11		; Standard DOS name of 8 chars. + 3 char ext.
MAXPTH	equ	67		; Maximum path allowed, with 3 chars. overhead
MIN_VER	equ 	300h+10		; lowest DOS version supported

ASCBASE	equ	30h	; Base of ASCII numeric codes
BADF	equ	0feh	; Bad function code

MYCODE	equ	0dbh	; Signals FNFS is already resident
	PUBLIC	MYCODE

; System functions and calls

DOSCALL	equ	21h
GETVER	equ	30h		; Get DOS version
FCREAT	equ	3ch		; create file and return handle
FOPEN	equ	3dh		; open existing file & return handle
FCLOSE	equ	3eh		; close file & return handle
FREAD	equ	3fh		; read from handle
FWRITE	equ	40h		; write to handle
FUNLNK	equ	41h		; delete file
FSEEK	equ	42h		; seek handle
FATT	equ	43h		; manage attributes
EXIT	equ	4ch		; Exit with a return code
DOS_STR	equ	9		; DOS' most basic string printing function
MPX2F	equ	2fh		; DOS' multiplex interrupt.
TMRVCTR	equ	8		; Hardware timer interrupt vector.
GETPSP3	equ	62h
SETPSP	equ	50h
GETVECT	equ	35h
SETVECT	equ	25h
DOSFREE	equ	49h
TSR	equ	3100h
GETSDA	equ	5d06h		; Request the address of DOS' Swap. Data area
GETLOL	equ	5200h		; Request the address of DOS' List of Lists
NWREDIR	equ	11h		; Network redirector functions

; device handles

STDIN	equ	0
STDOUT	equ	1
STDERR	equ	2

; Other manifest constants

STRARRAY	equ	256	; A 256 byte string output buffer for starters
NEWLINE		equ	0ah	; standard UNIX newline char.
RETCHAR		equ	0dh	; the carriage return for our DOS console
TAB		equ	9
BEL		equ	7
BKSP		equ	8
cr		equ	RETCHAR
lf		equ	NEWLINE
FAIL		equ	2
DENTSIZ		equ	32	; size of each DOS directory entry

; Installable file system/Network redirector constants

IFSSEEK		equ	21h
IFSCLOSE	equ	6
IFSUNLCK	equ	0bh

;***** Structures **************************************************************
;*******************************************************************************

include DOSSTRUC.INC

;***** Records *****************************************************************
;*******************************************************************************

; Manage the flag bits in the current directory structure

flag	RECORD	NW:1,PH:1,JO:1,SB:1,SPARE:12=0	; Network, physical, join, subst

fleatr	RECORD	RES:2,ARC:1,DIR:1,VOL:1,SYS:1,HID:1,RO:1	; Flags for file

;***** Macros ******************************************************************
;*******************************************************************************

; Emulate 80186/188 & later proc. instruction for 8086/8088

pusha	MACRO
	push	ax
	push	bx
	push	di
	push	dx
	ENDM

popa	MACRO
	pop	dx
	pop	di
	pop	bx
	pop	ax
	ENDM

; Force uppercase text characters, leave other characters alone
; Note this only works for the ASCII collating sequence. NOT EBCDIC

toupper	MACRO		; The character is assumend to be in AL
	LOCAL	done
	cmp	al,'a'
	jl	done	;; Below lowercase a, leave it alone
	cmp	al,'z'
	jg	done	;; likewise if above a lowercase z
	and	al,0dfh
done:
	ENDM

; Copy the DS into the ES register

dses	MACRO
	push	es
	push	ds
	pop	es
	ENDM

;**** Offsets used in program data structures

parent	equ	16h	; Where DOS stores the parent's PSP in our PSP
ljump	equ	0ah	; where execution resumes upon our termination
ENV_SEG	equ	2ch	; The environment segment is stored here
PSPSTK	equ	2eh	; Where the SS:SP is saved for int 21h calls

;***** External Data/Functions *************************************************
;*******************************************************************************

	; You can sneak external fct. declarations out here because the
	; assembler is told they are near calls. Data doesn't always work
	; that well because the assembler may make the wrong decision in
	; computing the offsets or selecting a segment register. Only a
	; problem with multiple segments and GROUP directives.

	extrn	envchk:near, args:near, eargs:near
	extrn	altcfg:near, chkarg:near, chkenv:near
	extrn	opts:near

SUBTTL Segments
PAGE+

;**** Segments resident after TSR ********************************************
;*****************************************************************************

;**** Resident code **********************************************************
;	This segment is declared first so the linker will load it first. It is
;	where the routines that service the interrupts go. The TSR is started
;	only in the event of an interrupt. The startup code comes later and
;	is jettisoned.


Restext	SEGMENT	PARA	PUBLIC	'TEXT'
	extrn	mpx_isr:far,openmn:far,closemn:far
ifdef	BLINDALLEY
	extrn	tmrarp:far
endif
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
BUFFER	ENDS

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
	extrn	OldVect2F:dword,OurPSP:word,drive_no:byte
	extrn	OurCDS:dword,OurSDA:dword,DRV_LTR:byte
	extrn	INITLPATH:byte,INITLPATHLEN:abs,RootOffs:word
	extrn	OurOS:byte, cannedip:dword, hostid:dword
ifdef	BLINDALLEY
	extrn	OldVect8:dword
endif
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

;**** Resident data **********************************************************
;	This segment contains only the minimum data needed while the TSR is
;	active. This is to prevent hogging memory that is needed by other
;	programs. Since the TSR's typically are in low memory it is a valuable
;	commodity.

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'

	PUBLIC	fnm1ea,fcb1ea

;	Declare the external data in the segment it is known locally. This way
;	the Assembler will automaticaly generate segment overrides if needed.
;	It also ensures that the offsets are computed correctly based on the
;	segment register selected and whether that seg. reg. is associated
;	with a default segment or group based on the ASSUME directive.

OurLOL		dd	0	; DOS' List Of Lists

fnm1ea		dw	fname1	; Offsets inside DOS' swapable data area for
fcb1ea		dw	nm1fcb	; system fields. Compute & save here

Resdata	ENDS

SUBTTL Discardable section

;***** Data Segment ************************************************************
;*******************************************************************************

data	SEGMENT	WORD	PUBLIC	'DATA'

	PUBLIC	_psp,_os_major,_os_minor

MPXVECT		dd	mpx_isr
ifdef	BLINDALLEY
TMRVECT		dd	tmrarp
endif

_psp		dw	?	; save a record of our psp segment

_os_major	db	3	; What version of dos have we?
_os_minor	db	30

strbfr		db	STRARRAY dup (0)
		even
strptr		dw	offset strbfr

startstr	db	'UNIX to DOS disk mounting program',NEWLINE
		db	'Copyright (C) Agricon International Inc and',NEWLINE
		db	'DCB Farms 1992. All rights reserved',NEWLINE
		db	'FREE SOFTWARE: NO WARRANTY PROVIDED',NEWLINE
		db	'Read file COPYWRT and COPYING for more info.',NEWLINE,0

finistr		db	'\n\g\tProgram unloading!\n',0

ivecstr		db	'FNFS could not get required info from DOS.\n',0
pktstr		db	'FNFS was unable to find a packet driver.\n',0
portmstr	db	'FNFS failed finding an NFS port on the host.\n',0
moutdstr	db	'FNFS mount request denied or failed.\n',0

EXITMSG		db	'FNFS successfully unloaded',cr,lf
EXITLEN		dw	$-EXITMSG
STAYMSG		db	'FNFS cannot unload!',cr,lf
STAYLEN		dw	$-STAYMSG

;---- other misc. strings

END_MSG	db	'Requires DOS version 2.01 or later',cr,lf,'$'
REPORT	db	'You have version '
MAJOR	db	'n.'
MINOR	db	'nn',cr,lf,'$'

; switch label storage

lab1lst		db	'%\ '
lab1item	equ	$-lab1lst
labellist	db	'\xontrbg '	;1 padding char to make item count right
items		equ	$-labellist
data	ENDS

;***** Stack Segment ***********************************************************
;*******************************************************************************

stack	SEGMENT	PARA	STACK	'STACK'
	db	1024 dup (?)
tos	equ	$
stack	ENDS

;***** Code Segment ************************************************************
;*******************************************************************************

trans	SEGMENT	PARA	PUBLIC	'CODE'

	PUBLIC	main
	ASSUME	cs:trans,ds:data,ss:stack,es:ResGroup

main	PROC	FAR
	push	ds	; Should somebody start this program under DOS 1.x
	xor	ax,ax	; we need to put the PSP and offset 0 on the stack
	push	ax	; so that the old style terminate function will work.

	mov	ax,data		; on entry, ES & DS point to our PSP segment.
	mov	ds,ax		; get data segment addressability instead
	mov	ah,GETVER	; Now find out what version of DOS we're using.
	int	DOSCALL
	mov	[_os_major],al
	mov	[_os_minor],ah
	mov	[_psp],es	; save our PSP segment. We'll want it later

	xchg	al,ah
	cmp	ax,MIN_VER
	jge	OKVER
	call	NOTSUPP	; The next line ends the program. The far return will
	ret		; load PSP:0 -> int 20H, put on the stack @ startup.

OKVER:	call	envchk		; Look for any environment string about FNFS
	call	args		; Set up pointers to args while ES=PSP
	call	eargs		; Set up pointers to fields in environment too.
	call	altcfg		; See if path for config file is given
	call	opts		; Parse options file for parameter values.
	call	chkenv		; Set up any Environment options
	call	chkarg		; Allow command line args to override
	call	chkhostid	; Finally, give ourselves a unique ID.

	mov	ah,NWREDIR	; See if there is an instance of this program
	xor	al,al		; already running.
	int	MPX2F
	cmp	al,MYCODE
	jz	REMOVE		; Yes, set up a removal request

	call	puts		; simple banner to test things out.

	mov	ax,ResGroup
	mov	es,ax
	mov	ah,[_os_major]	; We need the DOS version later
	mov	es:[OurOS],ah
	call	getvars		; Get DOS global variables
	jc	die
;
;------ Mount the file system. If that fails don't bother setting intr vectors
;
	push	ds
	mov	ax,es				; Data needs to go into resident
	mov	ds,ax				; group. Routines assume DS.
	call	openmn				; Quit if can't mount or no packet
	jc	die				; (don't worry about stack; we're quitting.)
	call	docds				; Install drive while DS=ResGroup
	pop	ds				; driver is present.
	call	SET_VECT			; set up the vectors
	mov	ax,[_psp]
	mov	es:[OurPSP],ax
	call	FREE_ENV			; Release the environment space.

	mov	dx,data		; Tell DOS to leave this much memory.
	sub	dx,[_psp]		; (Data seg. and all after it get chucked.)
	inc	dx		; Round up to nearest paragraph, Incl. PSP.
	mov	ax,TSR		; (Segment math gives implicit paragraphs.)
	int	DOSCALL
die:	mov	ah,EXIT
	int	DOSCALL

REMOVE:	mov	ax,offset [finistr]
	push	ax
	call	printf
;
;------ File system is unmounted in TSR's context b/c ports values are STATIC.
;
	call	TermProc	; COMM vector in use is still in ax...
	jmp	die		; This code isn't reached.
main	ENDP

; Outputs a char to the console I/O buffer. If the buffer is full then flush is
; called to empty it. If a new-line is encountered the same is done.

putchar	PROC	NEAR
	push	di
	mov	di,[strptr]		; First copy the char. from AL
	dses				; into the buffer. Set ES
	stosb
	pop	es
	mov	[strptr],di
	cmp	al,NEWLINE		; Flush the buffer if a newline
	jnz	chklen			; Otherwise flush if full buffer
	mov	al,RETCHAR		; Force a carriage return too
	call	putchar			; Isn't recursion beauty?
	call	cflush
	pop	di
	ret
chklen:	mov	ax,di
	sub	ax,offset [strbfr]
	cmp	ax,STRARRAY-1		; 1 char fudge to allow newline
	jl	OK			; to cr-lf translation.
	call	cflush			; buffer was full. Empty it
OK:	pop	di
	ret
putchar	ENDP

; Flushes the output buffer with DOS' handle-based I/O functions.

cflush	PROC	NEAR
	lea	dx,[strbfr]		; the string to be written
	mov	cx,[strptr]		; compute how many characters go out
	sub	cx,dx
	mov	bx,STDOUT		; the handle for output
	mov	ah,FWRITE
	int	DOSCALL
	mov	word ptr strptr,offset strbfr
	ret
cflush	ENDP

; Just write a simple text string to stdout so that we know all's well

puts	PROC	NEAR
	lea	si,[startstr]		; work on the string char by char
charloop:
	lodsb
	test	al,0ffh		; null terminated string end this.
	jz	fini
	push	si		; preserve our array index
	call	putchar		; send out the letter
	pop	si
	jmp	charloop	; continue
fini:	ret
puts	ENDP

; Primordial printf. All arguments are on the stack, ENDING with the
; format string.

printf	PROC	NEAR
	push	bp
	mov	bp,sp
	mov	si,[bp]+4	; first arg pushed last.
nextch:	lodsb
	and	al,al		; stop upon string zero terminator
	jz	pfdone
; begin outer switch
	cmp	al,'\'		; escape character?
	jnz	write
	lodsb
; begin inner switch
	call	swt002
; end inner switch
	jmp	nextch
write:	call	putchar		; just put the character
	jmp	nextch
pfdone:
	pop	bp
	ret
printf	ENDP

; This procedure shows how to handle a switch statement. Care has
; been taken to avoid long jumps because the 8086 through 80286
; limits the range to 128 bytes. Instead, tight code can be obtained
; by using a call table. That table is resident in the CS to protect
; it from inadvertent changes. (Allowing compatibility with protected
; mode systems as well.) The labels themselves are defined as
; sequential procedures. If fallthrough is desired it is simply
; accomplished by not returing from the case label. This procedure will
; return to its caller however, once all the labels have been exhausted.

; It is assumed that the label to be matched is supplied in AL
; The DI,CX,AX registers are modified and not restored. String
; increments are assumed. The statements called by the case label
; may modify other registers.

swt002	PROC	near
	push	es			; Give ES DATA addr. for SCASB
	mov	cx,ds			; now get DS into ES
	mov	es,cx			; we're ready.
	mov	cx,items		; how many labels exist? Don't
	lea	di,[labellist]		; go past this. Get labels
	repnz scasb			; The scanning code is fast & tight.
	sub	di,offset labellist + 1	; Postincrement makes us off by 1.
	pop	es			; retrieve the ES used before
	jcxz	def002			; Was count exhausted?
	shl	di,1			; compute word index into table
	call	word ptr cs:table[di]
	ret				; all done, go back.
def002:	call	putchar			; go with what's in ax as default
	ret				; Switch statement complete

; Here is the table we use for our indirect call.

	even
table:	dw	offset trans:casesl	; escape char.
	dw	offset trans:casex	; hex char
	dw	offset trans:caseo	; octal char
	dw	offset trans:casen	; newline
	dw	offset trans:caset	; tab
	dw	offset trans:caser	; return
	dw	offset trans:caseb	; backspace
	dw	offset trans:caseg	; bel
swt002	ENDP

casesl	PROC	NEAR
	call	putchar	; Two slashes in a row means write a slash
	ret
casesl	ENDP

; Registers al,dl,cl,bx,si changed and not saved

casex	PROC	NEAR	; convert hex to ASCII character.
	xor	dl,dl	; assumes 2 digits max & si points to string.
	lea	bx,cs:[xtab]	; convert via table lookup
nextx:	lodsb		
	toupper
	sub	al,'0'	; adjust ASCII base to fit our table
	jl	notx	; if it went negative the number is done
	cmp	al,16h	; don't index past table!
	jg	notx
	xlat	byte ptr cs:[0]
	cmp	al,0		; bytes in between aren't hex...
	jl	notx
	mov	cl,4	; building number in dl, shift what's there
	shl	dl,cl	; over 1 nybble and add in the next value
	add	dl,al
	jmp	nextx
notx:
	mov	al,dl
	dec	si	; restore pointer
	call	putchar
	ret

xtab:	db	0,1,2,3,4,5,6,7,8,9,128,128,128,128,128,128,128,0ah
	db	0bh,0ch,0dh,0eh,0fh
casex	ENDP

caseo	PROC	NEAR
	xor	dl,dl	; assumes 3 digits max & si points to string.
next8:	lodsb		
	toupper
	sub	al,'0'
	jl	not8	; if it went negative the number is done
	cmp	al,7	; if it's > 7 the char isn't octal.
	jg	not8
	mov	cl,3
	shl	dl,cl	; convert digit and add it in.
	add	dl,al
	jmp	next8
not8:
	mov	al,dl	; restore the pointer
	dec	si
	call	putchar
	ret
caseo	ENDP

casen	PROC	NEAR		; real simple, just write the newline
	mov	al,NEWLINE
	call	putchar
	ret
casen	ENDP

caset	PROC	NEAR		; same for tab...
	mov	al,TAB
	call	putchar
	ret
caset	ENDP

caser	PROC	NEAR		; carriage return w/o newline
	mov	al,RETCHAR
	call	putchar
	ret
caser	ENDP

caseb	PROC	NEAR		; step backwards one char
	mov	al,BKSP
	call	putchar
	ret
caseb	ENDP

caseg	PROC	NEAR		; ring the bell
	mov	al,BEL
	call	putchar
	ret
caseg	ENDP


; NFS provides the option of giving a unique host ID. (Perhaps it's handy since
; the IP address is buried in the socket.) If no value was specified in the
; configuration file then just stick in the IP address.

chkhostid	PROC	NEAR
	test	word ptr [hostid+2],-1	; Did somebody already set host id?
	jnz	isset
	test	word ptr [hostid],-1
	jnz	isset
	mov	ax,word ptr [cannedip]	; just use IP address, but convert it
	xchg	ah,al			; from network order first.
	mov	word ptr [hostid+2],ax
	mov	ax,word ptr [cannedip+2]
	xchg	ah,al
	mov	word ptr [hostid],ax
isset:	ret
chkhostid	ENDP

; Inform user that this DOS won't do for FNFS

NOTSUPP	PROC	NEAR
	mov	ax,ds			; ES still points to PSP. Make it point
	mov	es,ax			; to our data segment.
	lea	dx,[END_MSG]		; inform user of the problem, then exit.
	mov	ah,DOS_STR		; Request the most basic DOS print fct.
	int	DOSCALL			; to be sure it can be completed.

;**** Convert the DOS binary version number to ASCII

	mov	ax,word ptr [_os_major]
	and	al,al			; DOS version 1 returns 0 so fix that up.
	jnz	PLUS1
	mov	al,1
PLUS1:	add	al,ASCBASE	; convert the BCD value to ASCII
	mov	di,offset MAJOR	; point to the first "n" in our report string.
	stosb
	mov	al,ah		; convert binary minor version number to BCD
	xor	ah,ah
	mov	di,offset MINOR	; points to the "nn" in our report string.
	mov	cl,0ah
	div	cl
	add	al,ASCBASE	; convert quotient to ASCII.
	stosb
	mov	al,ah		; now the remainder gets converted
	add	al,ASCBASE
	stosb
	mov	ah,DOS_STR
	lea	dx,[REPORT]
	int	DOSCALL
	ret
NOTSUPP	ENDP

; Let DOS know we want to set some interrupt vectors to point to us.

SET_VECT	PROC	NEAR
	push	es
	mov	ah,GETVECT	; Ask DOS for the old vector and then save that
	mov	al,MPX2F	; for when we go to exit
	int	DOSCALL
	mov	dx,es		; preserve value while we use ES to point
	pop	es
	mov	word ptr es:[OldVect2F],bx
	mov	word ptr es:[OldVect2F+2],dx
	push	ds				; save DS. DOS needs it right now
	lds	dx,dword ptr [MPXVECT]
	mov	ah,SETVECT		; segment addressability.
	mov	al,MPX2F
	int	DOSCALL
	pop	ds
ifdef	BLINDALLEY
	push	es
	mov	ah,GETVECT
	mov	al,TMRVCTR
	int	DOSCALL
	mov	dx,es
	pop	es
	mov	word ptr es:[OldVect8],bx
	mov	word ptr es:[OldVect8+2],dx
	push	ds
	lds	dx,dword ptr [TMRVECT]
	mov	ah,SETVECT
	mov	al,TMRVCTR
	int	DOSCALL
	pop	ds
endif
	ret
SET_VECT	ENDP

; Here we attempt to de-install ourselves. If some other routine has hooked our
; vectors, we cannot. We must wait until the other routine has gone if we are
; to be successful.
; If de-installation is possible, reset the vectors and remove the program,
; freeing up all memory associated with it.

TermProc	PROC	NEAR

COMMENT	@

	This code works for MS-DOS versions 3.3-6.x however DR DOS doesn't
	use offset PSPSTK in the same way. Thus we don't bother. It's just
	left here for informational purposes.

	mov	es,[_psp]	; update the stack DOS saves in the PSP and
	mov	bx,PSPSTK	; use this to restore the stack upon successful
	mov	es:[bx],sp	; termination.
	mov	es:[bx+2],ss

	@

	mov	ax,cs
	mov	es,ax			; ES:BX points to the line we resume
	lea	bx,[ReEnter]		; execution upon successful termination.
	mov	ah,NWREDIR
	mov	al,0ffh
	int	MPX2F			; Now let's give it a shot...
	lea	dx,[STAYMSG]		; since we're here the prog could NOT end
	mov	cx,STAYLEN		; so let the world know :-(
	mov	ax,1			; failure flag
	push	ax			; We borrow somebody's stack...
	jmp short Bypass
ReEnter:
	mov	ax,data		; We did it! Restore data segment addressability
	mov	ds,ax

COMMENT	@
	The balance of how this was handled under MS DOS

	mov	es,[_psp]
	mov	bx,PSPSTK
	mov	ss,es:[bx+2]
	mov	sp,es:[bx]

	@

	lea	dx,[EXITMSG]	; Now print out our success story.
	mov	cx,EXITLEN
	xor	ax,ax		; success flag
	push	ax
Bypass:	mov	ax,ds
	mov	es,ax
	mov	bx,STDOUT
	mov	ah,FWRITE
	int	DOSCALL
	pop	ax		; Indicate result
	jmp	die		; Hack supports DR DOS & MS DOS w/o stack.
TermProc	ENDP

; Tells DOS to release the environment variables that we were given

FREE_ENV	PROC	NEAR
	push	es
	mov	es,[_psp]	; have ES point to the PSP so that we can
	mov	ax,es:[ENV_SEG]	; load the environment segment, then save that
	mov	es,ax		; in the ES for DOS.
	mov	ah,DOSFREE
	int	DOSCALL
	pop	es
	ret
FREE_ENV	ENDP

; Get the addresses of essential DOS regions that control disk and other
; functions

getvars	PROC	NEAR

	ASSUME	ds:ResGroup

	mov	ax,ResGroup
	push	ds
	mov	ds,ax
	push	es
	mov	ax,GETLOL	; LOL holds current drive info & other
	int	DOSCALL		; needed addresses.
	mov	ax,es
	add	ax,bx			; used to ensure valid ptr.
	mov	word ptr [OurLOL],bx	
	mov	word ptr [OurLOL+2],es
	pop	es
	jz	hosed			; was ptr valid?

	push	ds
	mov	ax,GETSDA	; SDA contains FCBs, path names & other
	int	DOSCALL		; goodies.
	mov	ax,ds
	pop	ds
	jc	hosed
	mov	word ptr [OurSDA],si
	mov	word ptr [OurSDA+2],ax	; Now set up the drive's CDS
	pop	ds
	ret

hosed:	stc
	pop	ds
	ret

	ASSUME	ds:data

getvars	ENDP

; Track down the CDS for our particular drive. Carry is set in the event
; of some trouble. No parameters are passed.

docds	PROC	NEAR

	ASSUME	ds:ResGroup

	push	es
	les	di,[OurLOL]		; CDS' address is in the LOL
	mov	ah,es:[di].lastdrv	; what's the limit?
	les	di,es:[di].cds		; Get the CDS chain
	mov	al,[drive_no]		; Ensure we have room
	cmp	ah,al
	jge	gooddrv
beendone:
	stc
	pop	es
	ret
gooddrv:
	add	[DRV_LTR],al	; Drives zero-based, but saved as 1-based
	dec	al		; because 0 usually => default drive. Calc	
	mov	ah,size	cds3	; offset for this CDS in CDS chain.
	cmp	[OurOS],3
	jbe	not4
	mov	ah,size cds4
not4:	mul	ah
	add	di,ax
	mov	word ptr [OurCDS],di	; save this result for ourselves
	mov	word ptr [OurCDS+2],es

	test	es:[di].flags,(MASK NW) OR (MASK PH)
	jnz	beendone
	or	es:[di].flags,(MASK NW) OR (MASK PH)	; set Nework & Phys.
	mov	ax,[RootOffs]				; bits.
	mov	es:[di].rootoff,ax		; and offset from root portion

	mov	cx,[INITLPATHLEN]		; copy root path to CDS &
	mov	si,offset ResGroup:INITLPATH	; this is our current
	push	di				; directory.
	lea	di,es:[di].path	
	rep	movsb
	mov	al,'\'		; Root canonically ends with '\'
	stosb
	xor	al,al		; Terminate with null to make ASCIIZ
	stosb

	mov	di,word ptr [OurSDA]	; To save time & make routines
	cmp	[OurOS],3		; clear, resolve the addresses
	jg	doDOS4			; of fname1 and nm1fcb fields
	lea	ax,[di].fname1		; now. (The offset changes with
	mov	[fnm1ea],ax		; DOS versions.) Save this so
	lea	ax,[di].nm1fcb		; we don't have to test & compute
	mov	[fcb1ea],ax		; each time. (Especially bothersome
	jmp short DOSvi			; if trying to use [di+bx].offs
doDOS4:	lea	ax,[di].fname14		; style addressing.) Trading 4
	mov	[fnm1ea],ax		; bytes of code is much better
	lea	ax,[di].nm1fcb4		; than tons of if/then/else steps.
	mov	[fcb1ea],ax

DOSvi:	pop	di
	pop	es
	ret

	ASSUME	ds:data

docds	ENDP
trans	ENDS
	END	main

