TITLE	Phase III Network testing
SUBTTL	NFS low-level interface
PAGE	55,132
NAME	NFSlow

COMMENT	@

	Agricon International Inc	David C. Brown IV	October 22,1992

	See files COPYING and COPYWRT for copyright information. Copyright (C)
	Agricon International Inc. 1993

	Here we have the remaining calls to the RPC functions from the NFS
	intermediaries. The functions here worry about unix credit groups
	for RPC calls and so on. They take large bodies of data and convert
	them into network order. This data is not known until run time but
	then remains static.

	@

;***** Equates *****************************************************************
;*******************************************************************************

;***** Manifest constants ******************************************************

DOSCALL	equ	21h	; DOS function interface
DOSPRT	equ	9	; DOS primative print function
DOSTRM	equ	4ch	; DOS program terminate request

cr	equ	0dh
lf	equ	0ah

OUR_MOUNTPRT	equ	28eh
OUR_NFSPORT	equ	2049

NFSHANDLEN	equ	20h
TXFAIL		equ	-1
RXFAIL		equ	-2
RPCVFL		equ	-3
RPCSIZ		equ	-4

	PUBLIC	TXFAIL, RXFAIL, RPCVFL, RPCSIZ

;***** NFS constants **********************************************************

VDIR	equ	2	; Directory flag
VREG	equ	1	; file flag

AUTH_UNIX	equ	1	; RPC authority ID flags
AUTH_NULL	equ	0
MOUNTD		equ	100005	; RPC mount request
MOUNTDH		equ	1
MOUNTDL		equ	34469
MD_VER		equ	1	; version 1 of the mount daemon
MD_MOU		equ	1	; function mount
MD_UMO		equ	3	; unmount request
NFS_PROG	equ	100003	; RPC request for NFS
NFS_PROGH	equ	1	; see remark above regarding portmap
NFS_PROGL	equ	34467
NFS_VER		equ	2
NFS_PORT	equ	2049	; nfs daemon's port
NFS_NULL	equ	0
NFS_GETATTR	equ	1
NFS_SETATTR	equ	2
NFS_LOOKUP	equ	4
NFS_READ	equ	6
NFS_WRITE	equ	8
NFS_CREATE	equ	9
NFS_REMOVE	equ	10
NFS_RENAME	equ	11
NFS_MKDIR	equ	14
NFS_RMDIR	equ	15
NFS_RDDIR	equ	16
NFS_STAT	equ	17


;***** Structures **************************************************************
;*******************************************************************************

NFS_ATTRH	STRUC
NFS_HANDLE	db	32 dup (?)
nfspad1		db	0,0,0		; network order data
nfstype		db	VDIR
nfspad2		dw	0		; network order high part of mode
nfsmode		dw	0
nfslinks	dd	1		; unsed
nfsids		dd	0,0		; uid/gid unused
nfssize		dd	0		; file size in bytes
nfsbsize	dd	0		; blocksize unused
nfsrdev		dd	0		; raw device id unused
nfsfsid		dd	0,0		; file system quadword unused
nfsinode	dd	0		; inode unused
nfsatime	dd	63c0190fh	; Access time unused.
		dd	0
nfsmtime	dd	63c0190fh	; August 15, 1992 @ 12:30pm
		dd	0
nfsctime	dd	63c0190fh	; creation time unused
		dd	0
NFS_ATTRH	ENDS

; outgoing RPC request structure

RPCSND	STRUC
RPCXID	dd	?
RPCCALL	dd	?
RPCVER	dd	?
RPCPROG	dd	?
PRGVER	dd	?
PRGFCT	dd	?
NULL1	dd	?
NULL2	dd	?
NULL3	dd	?
NULL4	dd	?
RPCSND	ENDS

SUBTTL	Segments
PAGE+

;***** Segments ****************************************************************
;*******************************************************************************

Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
	extrn	TXpktb:byte
BUFFER	ENDS

; Static credit group and host ID/name information. Later this will be
; changable at load time.

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'

	extrn	mountport:word,nfsport:word
	PUBLIC	hostid,hostname,credits,mountp

ourmprt		dw	OUR_MOUNTPRT
ournfsp		dw	OUR_NFSPORT

hostid		dd	0			; arbitrary ID

	extrn mounthandle:byte,curdirh:byte

hostname	db	'megalon.agricon.com'	; Null Terminated!
		db	256 - ($-offset hostname) dup (0)

credits		dd	100			; UID = david
		dd	0			; GID = wheel
		dd	0			; Number of groups
		dd	0, 0, 20, 31
		dd	0, 0, 0, 0		; Up to 8 groups allowed.

		dd	AUTH_NULL, 0
CREDLEN		EQU	$-offset credits

mountp		db	'/usr'
		db	64 - ($-offset mountp) dup (0)
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

; Discardable data segment. Place strings and other things we
; won't need after initialization here.

data	SEGMENT	WORD	PUBLIC	'DATA'
succmnt	db	'The file system was mounted!',0dh,0ah,'$'
failmnt	db	'The mount request was rejected.',0dh,0ah,'$'
data	ENDS

	extrn	pktinit:far,pkthang:near,ippkttx:near,ippktrx:near
	extrn	mapmountd:near,mapnfsd:near,rpcvrfy:near
	extrn	htonds:near,rpcsetup:near

; Now we deal with starting up the protocol and parsing it into remote
; calls. The layer below will actually worry about port mapping. Here we
; mount and dismount the file system. Further calls provide access to it.
; At this level we are talking to mountd for mounts/dismounts, and nfsd
; for all other transactions. The layer above us just maps system calls into
; NFS calls. We packetize them and call the apropriate RPC services to get
; it done.

Restext	SEGMENT	PARA	PUBLIC	'TEXT'

	ASSUME	cs:ResGroup,ds:ResGroup,SS:ResStack,es:BUFFER

	PUBLIC	mountfsreq,umountfsreq,openmn,closemn
	PUBLIC	nfsreqst,nfsheader

; Open up the packet drivers, mount the file system requested. Return carry
; clear if all was OK, and set up the global mount handle with the data.

openmn	PROC	FAR
	push	di
	push	es

	mov	di,BUFFER
	mov	es,di
	call	pktinit		; register ourself with the packet driver
	jnc	gomore
	jmp short opndie
notyet:	call	pkthang		; Hang up our packet handles unless we
	stc			; never had any.
opndie:	pop	es
	pop	di
	ret
gomore:	lea	di,es:[TXpktb]
	call	mapmountd	; get our ports mapped out for
	jc	notyet
	call	mapnfsd		; the other calls.
	jc	notyet
;
;------ Now we can mount the file system
;
	push	word ptr [credits]	; save original UID
	mov	byte ptr [credits],0	; force UID root
	call	mountfsreq
	pop	word ptr [credits]	; restore UID
	push	dx
	push	ds
	mov	dx,data
	mov	ds,dx
	mov	ah,DOSPRT
	jnc	samp4
	lea	dx,[failmnt]
	int	DOSCALL
	pop	ds
	pop	dx
	jmp	notyet
samp4:	lea	dx,[succmnt]
	int	DOSCALL
	pop	ds
	pop	dx
	pop	es
	pop	di
	ret
openmn	ENDP

; Release the mounted file system and then close down the packet driver.

closemn	PROC	NEAR
	push	di
	push	es
	mov	byte ptr [credits],0	; force UID root
	call	umountfsreq
	call	pkthang		; release the packet driver for other things.
	xor	ax,ax		; ALWAYS release it! Otherwise it may call us
	pop	es		; when we're no longer there!
	pop	di
	ret
closemn	ENDP

; Because mount & unmount are so similar (and painful due to the auth. groups)
; we try to keep them with a common body routine and just specialize the initial
; code.	This function returns with a pointer to the mount handle.

mountfsreq	PROC	NEAR
	mov	ax,0
	push	ax
	mov	ax,MD_MOU
	push	ax
	call	mainline	; do all the work in one place.
	jnc	gwanmnt
mntrqf:	stc			; other branches here need carry set.
	ret
gwanmnt:
	cmp	ax,24		; make sure we have enough bytes.
	jb	mntrqf
	mov	ax,es:[di]	; check for zero return code
	or	ax,es:[di+2]
	jnz	mntrqf
	mov	ax,es:[di+4]	; Check that NFSOK was sent.
	or	ax,es:[di+6]
	jnz	mntrqf
;
;------ Now copy to our mount point
;
	lea	di,[di+8]	; skip over return code fields.
	push	cx
	push	si
	push	ds
	mov	si,es
	mov	ds,si			; some segment footwork.
	pop	es
	push	di
	mov	si,di			; get addressability from
	lea	di,[mounthandle]	; packet buffer to bss storage.
	mov	cx,NFSHANDLEN / 2	; now copy the structure over
	rep movsw
	pop	si			; recover data address
	lea	di,[curdirh]		; update current directory handle
	mov	cx,NFSHANDLEN / 2
	rep movsw
	push	es
	mov	si,ds			; restore segments
	mov	es,si
	pop	ds
	pop	si
	pop	cx
	lea	di,[mounthandle]	; return pointing to our new handle.
	clc
	ret
mountfsreq	ENDP

; Here we will do the unmount but there's very little to check upon return.

umountfsreq	PROC	NEAR
	xor	ax,ax
	push	ax
	mov	ax,MD_UMO
	push	ax
	call	mainline
	jnc	gwanumt
	ret
gwanumt:
	cmp	ax,4		; make sure we have enough bytes.
	ret			; return code = CY set by CMP!
umountfsreq	ENDP

; This is the common interface for mount and unmount. This avoids duplicating
; code that is very repetitious. The Mount function is on the stack so that
; we can distinguish the two operations.

mainline	PROC	NEAR
	push	bp
	mov	bp,sp
	push	si
	push	bx
	mov	di,BUFFER	; first we must point to the buffer...
	mov	es,di
	lea	di,es:[TXpktb]

	push	[bp+6]		; will either be mount or unmount
	push	[bp+4]		; the longword for completeness
	xor	ax,ax		; what style mount interface?
	push	ax
	mov	ax,MD_VER
	push	ax
	mov	ax,MOUNTDH	; the actual RPC program to call
	push	ax
	mov	ax,MOUNTDL
	push	ax
	call	rpcsetup	; first set up the XID and call info
	lea	di,[di].NULL1	; step into the RPC fields
	call	docreds		; now the beastly part! At least it's canned!
	push	di		; points back to mount point size
	lea	di,[di+4]	; reference where we will want to mount
	lea	si,[mountp]
cpymnt:	lodsb
	and	al,al
	jz	mntcpd
	stosb
	jmp	cpymnt
mntcpd:	pop	bx		; recover name destination
	mov	ax,di
	sub	ax,bx		; calculate name length
	sub	ax,4		; account for di's offset
	xchg	ah,al		; into network format
	mov	es:[bx+2],ax
	mov	word ptr es:[bx],0	; save it into packet

	sub	ah,4			; pad out to nearest
	and	ah,3			; longword as usual.
	push	cx
	mov	cx,ax
	xchg	ch,cl			; (Name < 256 bytes always)
	rep stosb			; Intelisms
	pop	cx

	push	[mountport]		; now pass destination
	push	[ourmprt]		; and source ports, as
	lea	ax,es:[TXpktb]	; well as packet length...
	sub	ax,di
	neg	ax
	push	ax
	call	ippkttx		; and transmit it!
	jc	mainlxit
	call	ippktrx
	jc	mainlxit
	call	rpcvrfy
mainlxit:
	pop	bx
	pop	si
	pop	bp
	ret	4
mainline	ENDP

; Stuff in all the gory details of an NFS call. Use the RPC setup and docredits
; functions for help. This just avoids much inline stack parameter setting in
; each NFS function, cutting the potential for error by that number.
;
; It takes a longword as the NFS function to execute, and a far pointer to the
; appropriate NFS handle to put on the request stack. NFS calls always have some
; type of handle --a file handle, directory handle or mount point handle.
;
; ASSUMES that ES:DI now points to the packet we are filling!

nfsheader	PROC	NEAR
	push	bp
	mov	bp,sp
	push	cx
	push	si
	push	ds
;
;------ First set the RPC part of the call into the packet buffer.
;
	push	[bp+6]		; High word of NFS request
	push	[bp+4]
	xor	ax,ax		; Not likely this will be > 65536 soon.
	push	ax
	mov	ax,NFS_VER
	push	ax
	mov	ax,NFS_PROGH
	push	ax
	mov	ax,NFS_PROGL
	push	ax
	call	rpcsetup
	lea	di,[di].NULL1	; step into the RPC fields
	call	docreds		; now the beastly part! At least it's canned!
	lds	si,[bp+8]	; copy over the given handle
	mov	cx,NFSHANDLEN / 2
	rep movsw			; es:[di] already points to user data.

	pop	ds
	pop	si
	pop	cx
	pop	bp
	ret	8
nfsheader	ENDP

; This function sends off the given packet. It then manages checking for transmit
; timeouts, calling the receiver, checking receive timeouts, RPC verify. It checks
; the number of bytes received against the parameter given to be sure enough came.
; It will set carry & an error code in AX if there's trouble. 
; NO LONGER TRUE: BX will have the RPC return code if there is trouble.

nfsreqst	PROC	NEAR
	push	bp
	mov	bp,sp

	push	[nfsport]	; the listener port
	push	[ournfsp]	; our mouthpiece
	lea	ax,es:[TXpktb]	; size of the packet needs to be figured...
	sub	ax,di
	neg	ax
	push	ax
	call	ippkttx		; send off that packet. Not much else to
	jnc	nfsrx		; do here.
	mov	ax,TXFAIL
	jmp short fvfxit

nfsrx:	call	ippktrx		; If we timed out or something then we must
	jnc	chkrpc		; drop the packet & see what the caller wants
	mov	ax,RXFAIL	; to do
	jmp short fvfxit

chkrpc:	call	rpcvrfy		; Now see if the remote procedure worked...
	jnc	vrfyok
	mov	ax,RPCVFL
vrfyf:
;mov	bx,es;[di+2]	; RPC return code
fvfxit:	stc
	pop	bp
	ret	2
vrfyok:	cmp	ax,[bp+4]	; Did we get enough back in the packet?
	lea	di,[di+8]	; skip over return code & NFSOK
	jae	vrfaok		; UNSIGNED! if packet > 32k (TCP/IP)
	mov	ah,RPCSIZ
	jmp	vrfyf

vrfaok:	clc			; allright! We can go home.
	pop	bp
	ret	2
nfsreqst	ENDP

; This function copies the nightmare of credit groups into the RPC request
; header. The problem is that longwords and longword alignment are used, and
; this must be in host order. Right in the middle of this is the text host name
; which should not be re-ordered. Since these structures are dynamic wrt the
; installation, a structure isn't powerful enough to represent them. They are
; computed on the fly from copies of the hostname and credit groups, trading
; some execution time for memory savings.
;
; Because the namelength is padded to a longword, computing the ending address
; is a little involved, especially once things are in network order. The ES:DI
; points to the next available byte. Use that!

docreds	PROC	NEAR
	push	bx
	push	cx
	push	si

	mov	ax,AUTH_UNIX	; cheat: we know AUTH_UNIX < 65536 so
	stosw			; work around the assembler's funny
	xor	ax,ax		; support of long constants
	stosw
	push	di		; mark our place for credit length field.
	lea	di,[di+4]		; skip for later.
	mov	ax,word ptr [hostid]
	stosw
	mov	ax,word ptr [hostid+2]
	stosw
	lea	di,[di+4]	; defer name length assignment till it's known
	mov	bx,di		; mark our place
	lea	si,[hostname]
movhnm:	lodsb			; do *m++ = *n++;
	and	al,al		; do-while ensures a null-terminated name
	jz	didhnm		; ensures null in AL for later padding too!
	stosb			; while (*m);
	jmp	movhnm
didhnm:	mov	cx,di
	sub	cx,bx		; prelimin. name length --for longword align.
	mov	ah,cl		; Host name will be < 256 chars.
	and	cl,3		; put things just where we need them. Now the
	jz	frick
	sub	cl,4
	neg	cl
	rep stosb		; microcode will test/decrement/move as needed!
frick:
;
;------ Now calculate name length
;
	xchg	ah,al		; convert byte name length to word
	mov	es:[bx-4],ax	; save name length
	mov	es:[bx-2],cx	; still has zero from above
;
;------ convert fields up to name into network order
;
	lea	ax,es:[TXpktb]
	push	es		; char far *source);
	push	ax
	push	es		; char far *dest,
	push	ax
	sub	ax,bx
	neg	ax
	shr	ax,1
	shr	ax,1		; short longwords,
	push	ax
	call	htonds		; htonds(
	push	di		; mark our place for credit converts later.
	lea	si,[credits]
	mov	cx,word ptr [credits+8]	; how many groups? (lwords)
	shl	cx,1			; Convert to words
	add	cx,3 * 2		; Don't forget UID/GID & count (lwords)
	rep movsw
	xor	ax,ax		; Now size of next field (0) and
	mov	cx,2 * 2	; final AUTH_NULL terminator.
	rep stosw
;
;------ Now convert credits to net format
;
	pop	ax		; recover their offset into packet
	push	es		; char far *source)
	push	ax
	push	es		; char far *dest,
	push	ax
	sub	ax,di		; short count,
	neg	ax
	shr	ax,1		; convert to longword count!
	shr	ax,1
	push	ax
	call	htonds		; htonds(
	pop	bx		; finally, recover offset of credit struct len.
	mov	ax,di		; current pos - starting pos = total bytes
	sub	ax,bx
	sub	ax,12		; account for AUTH_NULL, 0 and bx's offset
	xchg	ah,al		; into network order, this range was already
	mov	es:[bx+2],ax		; converted.
	mov	word ptr es:[bx],0	; we leave with DI pointing to next byte.

	pop	si
	pop	cx
	pop	bx
	ret
docreds	ENDP
Restext	ENDS
	END
