PAGE	63,132
TITLE	HELPER ROUTINES FOR COMMAND LINE ARGUMENTS
SUBTTL	GENERAL DATA STRUCTURES
NAME	HELPER

;		David C. Brown
;		May 1990, Modified June 15, 1992, April 5, 1994

COMMENT	*

	This program will simply scan the command tail and then return a count
	of all command line arguments it found, along with a pointer to pointers
	of the values. It will also terminate the command line parameters with
	a null byte.

	Data space from the default data segment is used, and enough memory for
	64 arguments is used, assuming 128 bytes per command tail and one blank,
	tab, or newline between each argument.

	It assumes that ES points to the Program Segment Prefix,
	and that DS points to the default Data Segment.

		*

;******** EQUATES *************************************************************
;******************************************************************************

	newline	EQU	0AH	; newline symbol
	retchar	EQU	0DH	; carriage return symbol
	blank	EQU	' '	; blank space
	tab	EQU	9	; tab

	C_TAIL	EQU	81H	; location of command parameters
	C_END	EQU	80H	; count of command parameters

	ENVOFS	EQU	2ch	; Offset of environment's segment in PSP

	PUBLIC	ENVOFS

;******************************************************************************
;******************************************************************************

data	SEGMENT	word	PUBLIC	'DATA'

	extrn	_psp:word

	PUBLIC	argc, argv, eargc, eargv

envstr	DW	0		; Pointer to first parameters of environment string
envlen	DB	0

argc	DB	1
argv	DW	$+2		; Rather than an offset constant, make it var.
	DW	64 DUP(?)
eargc	DB	1		; Same idea as argc/argv but for the environ.
eargv	DW	$+2
	DW	64 DUP(?)

ENVFLG	DB	'FNFS'
ENVFLGL	EQU	$-ENVFLG
data	ENDS

stack	SEGMENT	PARA	STACK	'STACK'
stack	ENDS

trans	SEGMENT	PARA	PUBLIC	'CODE'

	PUBLIC	args, eargs, envchk
	ASSUME	cs:trans,ds:data,ss:stack

; Interface stub for general argc/argv/envp seperator program. It sets up the
; stack frame for arguments needed to process the command tail. These things
; are DOS specific and won't change across version. The interface simplifies
; the argument call by dealing with pointers and parameters here. The actual
; routine that does the work consults the environment as well so that's why
; we need all the parameter passing.

args	PROC	NEAR
	push	[_psp]		; Far address of command tail
	mov	ax,C_TAIL
	push	ax
	mov	al,es:[C_END]	; How many bytes in command tail.
	cbw
	push	ax
	xor	ax,ax		; Cause command to "tokenize" argument strings
	push	ax
	lea	ax,[argc]	; Near address of argument count
	push	ax
	lea	ax,[argv]	; Near address of argument variables pointer
	push	ax
	call	getargs
	ret
args	ENDP

eargs	PROC	NEAR
	cmp	[envlen],0	; Don't bother with this if there's nothing for us!
	jnz	isenv
	ret
isenv:	push	es:[ENVOFS]	; Pass the segment of the environment string
	push	[envstr]	; And the pointer to the first argument
	mov	al,[envlen]
	cbw
	push	ax		; Pass length of environment string.
	mov	ax,-1
	push	ax		; Pass flag as DON'T TOKENIZE
	lea	ax,[eargc]	; Near pointer to the environment argc
	push	ax
	lea	ax,[eargv]	; Near pointer to the environment argv.
	push	ax
	call	getargs

	ret
eargs	ENDP

; Dig out pointers to arguments from either command tail or environment string. Return
; pointers to each new run of arguments, and a count of the arguments. Also, may
; tokenize each run of arguments with a terminating '\0' character. Parameters are passed
; on the stack as follows:
;	SEG:OFFSET of command tail/environmet to be searched
;	Length of command tail/environment
;	Flag for tokenization (word). Yes = 0, No = -1
;	OFFSET of argument count variable
;	OFFSET of argument variables pointer array

getargs	PROC	NEAR
	push	bp			; Set up stack frame
	mov	bp,sp
	sub	sp,2			; Temporary variable: argct
	push	es			; Preserve ES.
	cld
	push	bx			; save the registers for others
	push	cx
	push	si
	xor	cx,cx			; clear high part of register
	mov	byte ptr [bp-2],1	; Initialize argument counts
	mov	cx,[bp+0ah]		; How long is the field?
	jcxz	FINISH			; if no arguments, bail out!
	les	si,[bp+0ch]		; Far pointer to command string
	mov	bx,[bp+4]
	mov	bx,[bx]
	add	bx,2			; we don't get argv[0] in this version.
	mov	ah,[bp+8]		; mask for tokenization
BLNK:	lods	byte ptr es:[si]
	cmp	al,blank		; skip over intervening blanks and
	jz	SKIP			; the like, being sure to remain within
	cmp	al,tab			; the command tail
	jz	SKIP
	cmp	al,retchar
	jz	SKIP
	cmp	al,newline
	jnz	CHAR			; here's a an argument so save its addr.
SKIP:	loop	BLNK
	jmp	short FINISH	; we've run out of command line so end now!
CHAR:	dec	si		; The post-increment is not very helpful here...
	mov	[bx],si		; argv[argc++] = ptr
	inc	si		; The dec/inc si seems quicker than push/pop si
	add	bx,2
	inc	byte ptr [bp-2]	; argct++
	dec	cx		; update the tail count
	jcxz	FINISH		; make sure we're not at the end of the line
NBLNK:	lods	byte ptr es:[si]
	cmp	al,blank	; now skip over everything until the end of
	jz	HOP		; the command line or another divider
	cmp	al,tab
	jz	HOP
	cmp	al,retchar
	jz	HOP
	cmp	al,newline
	jnz	MORE
HOP:	and	es:[si-1],ah	; *ptr++ &= flag /* flag = 0 or 0xff */
	loop	BLNK
	jmp	short FINISH	; that's the end
MORE:	loop	NBLNK		; we're still skipping over words...
	and	es:[si],ah	; Tokenize or not? (Yes:AH = 0, No: AH = -1)
FINISH:	mov	ax,[bp-2]	; recover the temp. argc and
	mov	si,[bp+6]	; set up the real argc
	mov	[si],al		; BEWARE: argc is only 1 word long!
	pop	si
	pop	cx
	pop	bx
	pop	es
	mov	sp,bp		; Deallocate temporary variables
	pop	bp
	ret	12		; Deallocate stack frame & parameters then return.
getargs	ENDP

; Check the program's environment space for any strings that control it.

envchk	PROC	NEAR
	push	es
	push	di
	push	si
	push	cx
	push	bx

	mov	ax,[_psp]	; The environment's segment is at PSP + 2ch
	mov	es,ax
	mov	es,es:[ENVOFS]

	xor	di,di		; Offset 0 into env. seg.
	mov	ax,di
	lea	si,[ENVFLG]	; String we want to find.
	mov	bl,[si]
thisit:	cmp	bl,es:[di]	; Matches so far...
	jz	chkme
skipmo:	mov	cx,ax		; run past this string in environment
	dec	cx		; (Allow 64K of search)
	repnz scasb		; Look for NULL at end of string
	jcxz	ended			; Wrapped around segment, give up.
	test	byte ptr es:[di],0ffh	; Two NULLs mean environment ended
	jz	ended
	jmp	thisit
chkme:	mov	cx,ENVFLGL
	repz cmpsb			; Make sure it matches
	jcxz	gotem			; Found it!
	test	byte ptr es:[di],0ffh	; At name's end?
	jnz	skipmo			; No, find end
	inc	di			; Yup, get to next one.
	jmp	thisit
gotem:	cmp	byte ptr es:[di],' '
	jz	nxtec
	cmp	byte ptr es:[di],tab
	jz	nxtec
	cmp	byte ptr es:[di],'='
	jz	skipsp
	jmp	skipmo
nxtec:	inc	di
	jmp	gotem
skipsp:	inc	di
	cmp	byte ptr es:[di],'-'
	jz	allok			; Found first environment argument
	cmp	byte ptr es:[di],'/'
	jz	allok
	test	byte ptr es:[di],0ffh	; Same precautions about termination
	jz	ended
	jmp	skipsp
allok:	mov	[envstr],di		; Set pointer to arguments
	xor	cx,cx
	mov	ax,cx			; Get 0  into AX to look for terminating
	dec	cx			; NULL, set CX = -1
	repnz scasb
	inc	cx			; Don't count the terminating NULL.
	neg	cx			; Convert count to positive
	dec	cx
	mov	[envlen],cl		; BYTE length only!

ended:	pop	bx
	pop	cx
	pop	si
	pop	di
	pop	es
	ret
envchk	ENDP
trans	ENDS
	END


