
COMMENT @

	Agricon International Inc.  	July 17, 1992		David C. Brown IV

	See files COPYING and COPYWRT for copyright information. Copyright (C)
	Agricon International Inc. 1993

	This file contains DOS-specific data structures so that editing may be
	done consistantly

	@

; The DOS find first/next directory entry block

sdb	STRUC
	drive	db	'A'		; The letter of the search drive
	patt	db	ETN dup(' ')	; Initial search pattern
	fndattr	db	0		; desired search attributes
	dirent	dw	0
	clutr	dw	0
		db	4 dup (?)
sdb	ENDS

; Found file directory entry block

fouent	STRUC
	founame	db	ETN dup(' ')	; result of query
	fouattr	db	0		; resulting attributes
	extr	db	10 dup(?)
	m_time	dw	0		; last modification time DOS FORMAT!
	m_date	dw	0		; last modification date DOS FORMAT!
	clust	dw	0		; starting cluster number
	fousize	dd	0		; size in bytes
fouent	ENDS

; DOS' List-of-Lists data structure

LOL	STRUC
	dpb1	dd	?		; Pointer to first disk parameter block
	dft	dd	?		; pointer to the file table
	clock$	dd	?		; pointer to the clock device driver
	con	dd	?		; segment for console input strings
	maxbb	dw	?		; max # of bytes/block
	dskbf1	dd	?		; pointer to the first disk buffer
	cds	dd	?		; points to current directory structure
	fcb	dd	?		; pointer to file control blocks
	fcbno	dw	?		; number of file control blocks allowed
	blkdvno	db	?		; number of block devices
	lastdrv	db	?		; ordinal # of the last drive DOS has
	NULDVR	dw	9 dup (0)	; An actual device, not a pointer.
	joindrv	db	?		; number of drives under a JOIN
LOL	ENDS

; System file table entries

sft	STRUC
	handles	dw	1		; Number of handles on THIS file
	o_mode	dw	?		; mode the file was opened
	sf_attr	db	?		; attributes reserved for this file
	dev	dw	?
	devdrv	dd	?		; pointer to the file's device driver
	strclst	dw	?		; starting cluster for the file
	sf_time	dw	?		; last modification in DOS time format
	sf_date	dw	?		; last modification in DOS date format
	sf_size	dd	?		; file size in bytes
	pos	dd	?		; file read/write pointer's position
	relclst	dw	?		; relative cluster location
	absclst	dw	?		; absolute cluster location
	dirsect	dw	?		; sector of directory entry
	sf_dir	db	?		; number of file in directory
	sf_name	db	ETN dup(' ')
sft	ENDS

; Current directory structures, DOS VERSION SPECIFIC !!!!!

cds3	STRUC
	path	db	MAXPTH dup(' ')	; Path incl. drive spec, colon & null.
	flags	dw	?
	dpb	dd	?
	redir	dd	?
	reqpar	dw	?
	rootoff	dw	2		; character count to root \ in path.
cds3	ENDS

cds4	STRUC
	std_pt	db size cds3 dup(?)	; Instance of DOS 3 cds + more fields
	extra	db	7 dup(?)
cds4	ENDS

; DOS 3.3 swapable data area (These are used to simplify handle/FCB/name references

sda3	STRUC			; use function 5D06 to get ptr for this
	cef	db	0		; Critical error flag
	inDOS	db	0		; Signals that DOS is busy, don't pop up
	errdrv	db	0		; Drive that had current critical error
	locus	db	?		; locus of last critical error
	exterr	dw	?		; extended error code of last error
	act	db	?		; suggested action for last error
	errcls	db	?		; class of last error
	errptr	dd	?		; pointer of last error
	curdta	dd	?		; current disk transfer buffer
	curpsp	dw	?		; current psp (process)
	spon23	dw	?		; current SP during INT 23h
	retcod	dw	?		; last proc's return code.
	curdrv	db	?		; current drive
	xbrflg	db	?		; extended break flag
	bfd1	db	22 dup(?)	; we don't care about this stuff
	dayom	db	?		; day of the month
	month	db	?
	yr80	dw	?		; year - 1980
	elday	dw	?		; days elapsed from 1980
	dow	db	?		; day of week, Sunday = 0
	bfd2	db	93 dup(?)	; skip over device driver stuff
	fname1	db	128 dup(' ')	; Filename buffer 1
	fname2	db	128 dup(' ')	; filename buffer 2
	fffn	db size sdb dup (?)	; buffer for find first/next
	ffile	db size fouent dup (?)	; buffer for found file
	drvcds	db size cds3 dup (?)	; drive's CDS
	nm1fcb	db	11 dup(' ')	; buffer for FCB style name 1
	pad1	db	?
	nm2fcb	db	11 dup(' ')	; buffer for FCB style name 2
	bfd3	db	9 dup(?)
	dirsrch	db	?		; search attr. FOR DIRECTORIES
	fcbtype	db	0		; ff => extended FCB
	lookatt	db	?		; search attribute, FOR FINDFIRST/NEXT
	fo_mod	db	?		; file open mode
	bfd4	db	44 dup(?)
	cursft	dd	?		; pointer to the current SFT
	cdrvcds	dd	?		; cds for drive being accessed
	clrfcb	dd	?		; pointer to caller's FCB
	bfd5	dw	?
	tmphnd	dw	?		; temporary handle storage
	jftent	dd	?		; job file table in process handle
	nm1cso	dw	?		; offset into DOS CS for first file name
	nm2cso	dw	?		; offset into DOS CS for 2nd file name
	bfd6	db	18 dup(?)
	curofs	dd	?		; current offset into current file
	bfd7	db	12 dup(?)
	apnd	dd	?		; number of bytes appended to file
	dskbf	dd	?		; pointer to a disk buffer
	sftptr	dd	?		; pointer to a system fule table
	savbx	dw	?		; bx and dx saves during INT 21h calls
	savdx	dw	?
	regtmp	dw	?		; caller's temp reg storage
	reent	dd	?		; caller's prev frame on INT 21h re-ent
	srcren	db size sdb dup (?)	; rename operations find first/next data
	setren	db size dirent dup (?)	; file being renamed
;
;	criterr	db	331 dup(?)	; DOS' critical error stack
;	diskstk	db	384 dup(?)	; DOS' disk I/O stk (NOT ALL DSK CALLS!)
;	charstk	db	384 dup(?)	; DOS' character I/O stack (fct 1 - 0Ch)
;
sda3	ENDS

; DOS 4 and later swapable data area (These are used to simplify handle/FCB/name references

sda4	STRUC			; use function 5D06 to get ptr for this
	cef4	db	0		; Critical error flag
	inDOS4	db	0		; Signals that DOS is busy, don't pop up
	errdrv4	db	0		; Drive that had current critical error
	locus4	db	?		; locus of last critical error
	exterr4	dw	?		; extended error code of last error
	act4	db	?		; suggested action for last error
	errcls4	db	?		; class of last error
	errptr4	dd	?		; pointer of last error
	curdta4	dd	?		; current disk transfer buffer
; offs 10h
	curpsp4	dw	?		; current psp (process)
	spon234	dw	?		; current SP during INT 23h
	retcod4	dw	?		; last proc's return code.
	curdrv4	db	?		; current drive
	xbrflg4	db	?		; extended break flag
	bfd14	db	24 dup(?)	; we don't care about this stuff
; offs 30h
	dayom4	db	?		; day of the month
	month4	db	?
	yr804	dw	?		; year - 1980
	elday4	dw	?		; days elapsed from 1980
	dow4	db	?		; day of week, Sunday = 0
	bfd24	db	103 dup(?)	; skip over device driver stuff
	fname14	db	128 dup(' ')	; Filename buffer 1
	fname24	db	128 dup(' ')	; filename buffer 2
	fffn4	db size sdb dup (?)	; buffer for find first/next
	ffile4	db size fouent dup (?)	; buffer for found file
	drvcds4	db size cds4 dup (?)	; drive's CDS
	nm1fcb4	db	11 dup(' ')	; buffer for FCB style name 1
	pad14	db	?
	nm2fcb4	db	11 dup(' ')	; buffer for FCB style name 2
	bfd34	db	9 dup(?)
	dirsrch4 db	?		; search attr. FOR DIRECTORIES
	fcbtype4 db	0		; ff => extended FCB
	lookatt4 db	?		; search attribute, FOR FINDFIRST/NEXT
	fo_mod4	db	?		; file open mode
	bfd44	db	47 dup(?)
; offs 27eh
	cursft4	dd	?		; pointer to the current SFT
	cdrvcds4 dd	?		; cds for drive being accessed
	clrfcb4	dd	?		; pointer to caller's FCB
	bfd54	dw	?
	tmphnd4	dw	?		; temporary handle storage
	jftent4	dd	?		; job file table in process handle
	nm1cso4	dw	?		; offset into DOS CS for first file name
	nm2cso4	dw	?		; offset into DOS CS for 2nd file name
	bfd64	db	24 dup(?)
	curofs4	dd	?		; current offset into current file
	bfd74	db	12 dup(?)
	apnd4	dd	?		; number of bytes appended to file
	dskbf4	dd	?		; pointer to a disk buffer
	sftptr4	dd	?		; pointer to a system fule table
	savbx4	dw	?		; bx and ds saves during INT 21h calls
	savds4	dw	?
	regtmp4	dw	?		; caller's temp reg storage
	reent4	dd	?		; caller's prev frame on INT 21h re-ent
	bfd8	db	9 dup (?)
	spopnop	dw	?		; Special open operation
	spopnat	dw	?		; Special open attribute
	spopnmo	dw	?		; Special open mode
	bfd9	db	29 dup (?)

	srcren4	db size sdb dup (?)	; rename operations find first/next data
	setren4	db size dirent dup (?)	; file being renamed
;
;	criterr4 db	331 dup(?)	; DOS' critical error stack
;	diskstk4 db	384 dup(?)	; DOS' disk I/O stk (NOT ALL DSK CALLS!)
;	charstk4 db	384 dup(?)	; DOS' character I/O stack (fct 1 - 0Ch)
;
sda4	ENDS
