PAGE 55,132
TITLE Command line parsing routines
SUBTTL Description/Documentation
NAME ARGPARSE

COMMENT @

	June 13, 1992, Modified April 5, 1994; June 17, 1994

	Agricon International Inc.

	David C. Brown IV

	Copyright 1992, 1993, 1994 Agricon International Inc. See file
	COPYING and COPYWRT for details.

	This module contains routines that manage parsing the input
	values obtained from the command line or environment. In particular
	a standard C format of parameters is allowed. The different options
	are signalled by flags preceded by '-' or '/' characters. Flags
	may be grouped after a single - or / character. Typically the
	values for the switches are expected to follow the flags. The values
	can have an intervening space or spaces, or be delimited by the
	':' or '=' characters. No great restriction is placed on the
	ordering of the flags in the command line.

	Near calls are coded because this program is intended for the DOS
	environment. The total number of arguments is limited to below
	64 by the helper program that locates these arguments. DOS itself
	allows only 128 bytes for a command tail. The environment can occupy
	a segment, giving a possible limit of 64KB. It is easy to generalize
	this program for longer command tails, and possibly command strings
	exceeding 64KB in length, however this will probably never be
	necessary.

	Access to the global varaible argc, containing the count of arguments
	found by the helper program, and the global array of pointers to
	those command strings is also required. Argv is the address of the
	array of strings, as opposed to a pointer containing the base address
	of the array of strings.

	@

SUBTTL	Constants/Definitions/Declarations
PAGE

;**** Equates & other program constants **************************
;*****************************************************************

MAXFLEN	equ	64	; Most chars allowed for file name & path

tab	equ	9

;**** Declarations for resident data ******************************
;******************************************************************

Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
BUFFER	ENDS

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
Resdata	ENDS

ResGroup	group	Restext,ResStack,BUFFER,Resdata

;**** Transient segments ******************************************
;******************************************************************

data	SEGMENT	WORD	PUBLIC	'DATA'
data	ENDS

stack	SEGMENT	PARA	PUBLIC	'STACK'
stack	ENDS

trans	SEGMENT	PARA	PUBLIC	'CODE'
trans	ENDS

;**** Data ********************************************************
;******************************************************************

; Any data here will be released after we go resident so it doesn't
; affect resident size.

data	SEGMENT	WORD	PUBLIC	'DATA'

; Case labels defined, and the quantity of them.

arglabels	db	'SDMdmugUlYy'
argitems	equ	$-arglabels

data	ENDS

;**** External variables ******************************************
;******************************************************************

	extrn	ENVOFS:abs

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
	extrn	cannedip:dword,credits:dword,hostname:byte
	extrn	drive_no:byte,mountp:byte
	extrn	workflg:byte,lowmask:byte
Resdata	ENDS

data	SEGMENT	WORD	PUBLIC	'DATA'
	extrn	argc:BYTE,argv:WORD
	extrn	eargc:BYTE,eargv:WORD
	extrn	_psp:WORD
	extrn	cfgfile:BYTE
	extrn	grptr:word,grnums:byte
data	ENDS

trans	SEGMENT	PARA	PUBLIC	'CODE'
	extrn	strcpy:near, atoi:near, cvtip:near
trans	ENDS

SUBTTL Discardable code
PAGE

;**** Code *******************************************************
;*****************************************************************

trans	SEGMENT	PARA	PUBLIC	'CODE'

	ASSUME	cs:trans,ds:data,es:NOTHING,ss:stack

	PUBLIC 	altcfg
	PUBLIC	chkarg, chkenv

altcfg	PROC	NEAR
	push	es:[ENVOFS]	; First check environment for an
	push	[eargv]		; alternative configuration file
	mov	al,[eargc]	; specification
	cbw
	push	ax
	call	cmdscn
	push	es		; FAR pointer to command line args
	push	[argv]		; is from PSP inside ES
	mov	al,[argc]
	cbw
	push	ax		; Pass the number of arguments
	call	cmdscn
	ret
altcfg	ENDP

; Scan the command line for a name to be used for the configuration
; file, if different than CONFIG.NFS

cmdscn	PROC	NEAR
	push	bp		; Allocate a stack frame to get parameters
	mov	bp,sp
	push	ds		; Preserve segment registers
	push	es
	mov	ds,[bp+8]	; Get the parameter space we're searching
	mov	di,data		; The argument pointers are in the data seg.
	mov	es,di
	xor	cx,cx		; clear high part of CX
	mov	cl,[bp+4]
	dec	cx		; argc-- because argv[0] isn't an option.
	jcxz	nowork
	mov	di,[bp+6]
	add	di,2		; Skip argv[0]
nxtop:	mov	si,es:[di]
	cmp	byte ptr [si],'-'
	jz	pass
	cmp	byte ptr [si],'/'
	jz	pass
skipo:	add	di,2		; Go to next argument
	loop	nxtop		; until all are checked
nowork:	pop	es
	pop	ds		; Recover segment registers
	mov	sp,bp
	pop	bp		; Deallocate stack frame, pop off arguments
	ret	6
pass:	inc	si			; point to any possible text
	cmp	byte ptr [si],'C'	; Flag for config file?
	jnz	skipo			; Naw... keep checking
	inc	si
	cmp	byte ptr [si],' '	; Option follows flag directly?
	jz	nxto
	cmp	byte ptr [si],tab
	jz	nxto
	test	byte ptr [si],0ffh
	jnz	nameav
nxto:	add	di,2			; Nope, it's another argv...
	mov	si,es:[di]
nameav:	lea	di,[cfgfile]		; Point to where we save new name
	mov	cx,MAXFLEN - 1		; Don't allow names that are too long.
xfr:	movsb
	cmp	byte ptr [si],tab
	jz	namend
	cmp	byte ptr [si],' '
	jz	namend
	test	byte ptr [si],0ffh	; Quit at '\0'
	loopnz	xfr			; or when we've moved too many chars.
namend:	mov	byte ptr es:[di],0	; Ensure name is NULL terminated
	pop	es
	pop	ds
	mov	sp,bp
	pop	bp
	ret	6
cmdscn	ENDP

; Pass the pointers to deal with command line options.

chkarg	PROC	NEAR
	push	[_psp]
	push	[argv]
	mov	al,[argc]
	cbw
	push	ax
	call	chkopt
	ret
chkarg	ENDP

; Set up arguments for environment options.

chkenv	PROC	NEAR
	push	es:[ENVOFS]
	push	[eargv]
	mov	al,[eargc]
	cbw
	push	ax
	call	chkopt
	ret
chkenv	ENDP

; First we process the argument list until it is exhausted. We
; preserve the contents of argv and argc by doing this. If desired
; the routine can be modified to use different values.
;
; Registers AX,BX,CX are used. SI is assumed to point to the current
; command line argument. The direction flag is cleared. Other
; registers may be changed by the case labels triggered from the
; arguments.
;
; Beware that ES needs to be pointing to the PSP. We set it here.

chkopt	PROC	NEAR
	push	bp
	mov	bp,sp		; Set up stack frame to get parameters
	push	es
	mov	es,[bp+8]	; Use proper segment registers
	mov	bx,[bp+6]
whl001:	dec	byte ptr [bp+4]	; while (--argc)
	jg	continue	; don't wrap around if we go negative!
	pop	es
	pop	bp		; Deallocate stack frame, remove parameters
	ret	6
continue:
	add	bx,2			; Note that this is pre-increment
	mov	si,[bx]			; since argv[0] = program name.
	lods	byte ptr es:[si]	; check for the leading '-' or '/'
	cmp	al,'/'
	jz	match
	cmp	al,'-'
	jnz	whl001		; change to "jz match" if "else" needed.
match:	lods	byte ptr es:[si]; while (*(++avp)) --go until string exhausted
	and	al,al		; end of string?
	jz	whl001		; get next flag
	cmp	al,' '
	jz	whl001
	cmp	al,tab
	jz	whl001
	push	si		; save our pointer in the argument list
	call	swt001		; manage a switch block.
	pop	si
	jmp	match		; Check for more flags in this argument.
chkopt	ENDP

; This procedure shows how to handle a switch statement. Care has
; been taken to avoid long jumps because the 8086 through 80286
; limit the range to 128 bytes. Instead, tight code can be obtained
; by using a call table. That table is resident in the CS to protect
; it from inadvertent changes. (Allowing compatibility with protected
; mode systems as well.) The labels themselves are defined as
; sequential procedures. If fallthrough is desired it is simply
; accomplished by not returing from the case label. This procedure will
; return to its caller however, once all the labels have been exhausted.

; It is assumed that the label to be matched is supplied in AL
; The DI,CX,AX registers are modified and not restored. String
; increments are assumed. The statements called by the case label
; may modify other registers.

swt001	PROC	near
	push	es			; Give ES DATA addr. for SCASB
	mov	cx,ds			; now get DS into ES
	mov	es,cx			; we're ready.
	mov	cx,argitems		; how many labels exist? Don't
	lea	di,[arglabels]		; go past this. Get labels
	repnz scasb			; The scanning code is fast & tight.
	sub	di,offset arglabels + 1	; Postincrement makes us off by 1.
	pop	es			; retrieve the ES used before
	jcxz	onward			; Was count exhausted?
	shl	di,1			; compute word index into table
	call	word ptr cs:table[di]
onward:	ret				; Switch statement complete

; Here is the table we use for our indirect call.

table:	dw	offset trans:caseS	; Set our IP address
	dw	offset trans:caseD	; Set destination IP address
	dw	offset trans:caseM	; Set the mount point name
	dw	offset trans:cased	; Set network drive ID letter
	dw	offset trans:casem	; Set my name
	dw	offset trans:caseu	; Set my effective user ID
	dw	offset trans:caseg	; Set my effective group ID
	dw	offset trans:caseU	; Files to NFS host in uppercase
	dw	offset trans:casel	; Files mapped to lowercase for NFS
	dw	offset trans:caseY	; Always succeed on non-supported calls
	dw	offset trans:caseY	; Allow 'Y' or 'y' for above option.
swt001	ENDP

; Set the IP address we will use for ourself.

caseS	PROC	near
	call	argfrmswt	; Step to actual argument after flag
	mov	ax,Resdata		; Far pointer to destination
	push	ax
	lea	ax,Resdata:[cannedip]
	push	ax
	push	es			; Far pointer to text IP address
	push	si
	call	cvtip			; Convert to IP address
	ret
caseS	ENDP

; Set the IP address we will use to reach our NFS host.

caseD	PROC	near
	call	argfrmswt	; Step to actual argument after flag
	mov	ax,Resdata		; Far pointer to destination
	push	ax
	lea	ax,Resdata:[cannedip+4]
	push	ax
	push	es			; Far pointer to text IP address
	push	si
	call	cvtip			; Convert to IP address
	ret
caseD	ENDP

; Set the host's path that will be used to mount the NFS file system.

caseM	PROC	near
	mov	ax,Resdata		; Far pointer to destination
	push	ax
	lea	ax,Resdata:[mountp]
	push	ax
	push	es			; Far pointer to new mount point
	push	si
	call	strcpy
	ret
caseM	ENDP

; Pick the letter to be used for our Network drive

	ASSUME	ds:Resdata	; Make sure assembler knows
				; what we want when it gives
				; us an offset!
cased	PROC	near
	call	argfrmswt
	push	ds
	mov	ax,Resdata
	mov	ds,ax
	mov	al,es:[si]
	and	al,NOT 20h	; Force to upper case.
caseok:	cmp	al,'A'		; If below A or above Z
	jb	baddrv		; It's not valid so exit
	cmp	al,'Z'
	ja	baddrv
	sub	al,'@'
	mov	Resdata:[drive_no],al
baddrv:	pop	ds
	ret
cased	ENDP

; Set the name we would like to call ourself for NFS operations

casem	PROC	near
	call	argfrmswt
	mov	ax,Resdata
	push	ax
	lea	ax,Resdata:[hostname]
	push	ax
	push	es
	push	si
	call	strcpy
	ret
casem	ENDP

	ASSUME	ds:data

; Set user ID used for NFS requests

	ASSUME	ds:Resdata	; Proper offsets from assembler

caseu	PROC	near
	call	argfrmswt
	push	ds		; atoi changes DS:SI
	push	es
	push	si
	call	atoi		; Convert to binary IP address
	push	cx
	mov	cx,Resdata	; Save it in proper segment.
	mov	ds,cx
	mov	word ptr Resdata:[credits],ax
	mov	word ptr Resdata:[credits+2],dx
	pop	cx
	pop	ds
	ret
caseu	ENDP

	ASSUME	ds:data

; Add the following argument to the "Groups Belonged" parameter for
; this user under NFS. There is a limit to "Groups Belonged" and if
; too many groups are requested the excess ones are quietly dropped.

caseg	PROC	near
	cmp	[grnums],0
	jnz	cando
	ret
cando:	dec	[grnums]
	call	argfrmswt
	push	ds		; atoi changes DS:SI
	push	es
	push	si
	call	atoi
	pop	ds
	push	es
	push	di
	mov	di,Resdata
	mov	es,di
	mov	di,[grptr]
	mov	word ptr es:[di],ax
	mov	word ptr es:[di+2],dx
	add	[grptr],4
	pop	di
	pop	es
	ret
caseg	ENDP

; Do nothing. By default names are sent to the NFS host in uppercase

caseU	PROC	near
	ret
caseU	ENDP

; Force names to NFS host to be lower case. (Map lower case name to
; uppercase on return to keep DOS happy.)

	ASSUME	es:Resdata

casel	PROC	near
	push	es
	mov	ax,Resdata
	mov	es,ax
	dec	es:[lowmask]	; Just set flag so we know to do it.
	pop	es
	ret
casel	ENDP

; Send back success or failure for unsupported functions? (Y means success.)

caseY	PROC	near
	push	es
	mov	ax,Resdata
	mov	es,ax
	mov	[workflg],1	; Handler will compare this to 1. This causes
	pop	es		; the carry flag to be set if Y isn't chosen.
	ret
caseY	ENDP

	ASSUME	es:NOTHING

; This function assumes 3 things:
;	argc is found from BP+4
;	The current argv pointer is in BX and stays that way
;	SI points to the current argument.
;
; It returns with SI adjusted to the current value after the
; arguments flag and any possible delimiter.

argfrmswt	PROC	near
	lods	byte ptr es:[si]
	cmp	al,' '
	jz	hasgap
	cmp	al,tab
	jz	hasgap
	and	al,al		; If there is a gap the parameter is next
	jnz	nospace 	; otherwise it has a delimiter
hasgap:	dec	byte ptr [bp+4]	; Decrement argc
	add	bx,2    	; Update argv pointer
	mov	si,[bx]		; update argument
	ret
nospace:
	cmp	al,':'		; if either of these test match then we are
	jz	fini		; now pointing at the parameter, otherwise
	cmp	al,'='		; we will need to adjust si down one byte
	jz	fini		; to compensate for the post increment of our
	dec	si		; string instruction.
fini:	ret
argfrmswt	ENDP
trans	ENDS
	END

