NAME	SneakyIO
TITLE	BIOS Level output program
SUBTTL	Functions available
PAGE	60,132

COMMENT	@

	Agricon International Inc	February 17, 1993
	David C. Brown IV

	These modules provide output directly via BIOS so that we can
	report status whilst still in the middle of DOS calls or other
	non-reentrant operations.

	@

;****** Manifest Constants ***************************************************
;*****************************************************************************

BIOS_TTY	equ	0eh
BIOS_CRT	equ	10h
cr		equ	0dh
lf		equ	0ah

;****** Structures and Records ***********************************************
;*****************************************************************************


; Access processor flags

FLREC RECORD U0:4,OVF:1,DIF:1,INF:1,TF:1,SIF:1,ZRF:1,U2:1,AXF:1,U3:1,PAF:1,U4:1,CYF:1

;****** Macros ***************************************************************
;*****************************************************************************

; Prints a string preceeding the register and then the register's contents
; AX modified and not preserved.

FMTreg	MACRO	textstr,register
	lea	ax,[textstr]	;; register's "format string" dress up output
	push	ax
	call	barflin		;; do the string
	mov	ax,register	;; Now do the contents of the register
	call	barfwrd
	ENDM

;****** Segments *************************************************************
;*****************************************************************************

Restext	SEGMENT	PARA	PUBLIC	'TEXT'
Restext	ENDS

ResStack	SEGMENT	WORD	'RSTACK'
ResStack	ENDS

BUFFER	SEGMENT	PARA	PUBLIC	'BUFR'
BUFFER	ENDS

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
Resdata	ENDS

	ResGroup	GROUP	Restext,ResStack,BUFFER,Resdata

; Print the given FAR string (passed on the stack) directly to the CRT via
; BIOS calls. String must be null terminated. Printable characters assumed.

Restext	SEGMENT	PARA	PUBLIC	'TEXT'

	PUBLIC	barfstr,barfhex,barfchr,barflin
	PUBLIC	barflf,barfcpu,barfwrd,barfflg

	ASSUME	cs:Restext,ds:ResGroup,ss:ResStack,es:BUFFER

barfstr	PROC	NEAR
	push	bp
	mov	bp,sp
	push	dx
	push	si
	push	ds

	mov	al,0afh		; Set string off from any other text
	call	barfchr
	lds	si,[bp+4]	; The string to be printed
	xor	dx,dx		; default attributes, video page 0
strwrt:	mov	ah,BIOS_TTY
	lodsb
	and	al,al
	jz	didstr
	int	BIOS_CRT
	jmp	strwrt

didstr:	mov	al,0aeh		; close string "highlight"
	call	barfchr
	pop	ds
	pop	si
	pop	dx
	pop	bp
	ret	4
barfstr	ENDP

; Used for printing NEAR strings, string NOT offset from text by special
; characters.

barflin	PROC	NEAR
	push	bp
	mov	bp,sp
	push	dx
	push	si

	mov	si,[bp+4]	; The string to be printed
	xor	dx,dx		; default attributes, video page 0
strlin:	mov	ah,BIOS_TTY
	lodsb
	and	al,al
	jz	didlin
	int	BIOS_CRT
	jmp	strlin

didlin:	pop	si
	pop	dx
	pop	bp
	ret	2
barflin	ENDP

; Print the character in AL directly to the screen via a BIOS call. Registers
; preserved.

barfchr	PROC	NEAR
	push	dx		; video page 0
	xor	dx,dx
	mov	ah,BIOS_TTY
	int	BIOS_CRT
	pop	dx
	ret
barfchr	ENDP

; Write cr,lf sequence directly to the screen via a BIOS call.

barflf	PROC	NEAR
	mov	al,cr
	call	barfchr
	mov	al,lf
	call	barfchr
	ret
barflf	ENDP

; Convert the given byte (in AX) into ASCII HEX and print it.

barfhex	PROC	NEAR
	push	cx
	mov	ah,al
	and	ax,0ff0h	; isolate low & high nybbles
	mov	cl,4
	shr	al,cl		; move high nybble to low nybble spot
	pop	cx
	add	ax,'00'		; convert to ASCII
	cmp	al,'9'		; adjust number as needed
	jle	hynbok
	add	al,'a' - ':'
hynbok:	push	ax		; save low nybble for later
	call	barfchr		; send out MSN first...
	pop	ax
	cmp	ah,'9'		; adjust LSN as needed
	jle	lonbok
	add	ah,'a' - ':'
lonbok:	mov	al,ah		; AL is printed
	call	barfchr
	ret
barfhex	ENDP

; Write the word given in AX as ASCII hex to the screen with BIOS

barfwrd	PROC	NEAR
	push	ax	; preserve accumulator
	push	ax
	xchg	ah,al	; need to write the high word first...
	call	barfhex
	pop	ax
	call	barfhex
	pop	ax	; recover accumulator
	ret
barfwrd	ENDP

; Dump the CPU contents as ASCII hex, formatted, to screen with BIOS

barfcpu	PROC	NEAR
	push	ax		; preserve accum. value
	pushf
	push	ax
	lea	ax,[axregstr]
	push	ax
	call	barflin
	pop	ax		; recover accum.
	call	barfwrd		; print it
	popf
	call	barfflg		; flag status
	FMTreg	bxregstr,bx
	FMTreg	bpregstr,bp
	FMTreg	cxregstr,cx
	lea	ax,[spregstr]	; Now SP
	push	ax
	call	barflin
	mov	ax,sp
	add	ax,4		; compensate for fct call.
	call	barfwrd
	FMTreg	dxregstr,dx
	FMTreg	ssregstr,ss
;
;------ The string primative & addressing registers
;
	FMTreg	esregstr,es
	mov	al,':'		; separate fields w/ a colon
	call	barfchr
	mov	ax,di
	call	barfwrd
	mov	al,'='		; Show what it will be addressing too
	call	barfchr
	mov	ax,es:[di]	; best we can do is assume a word.
	call	barfwrd
;
;------ General addressing/string primative registers
;
	FMTreg	dsregstr,ds
	mov	al,':'		; again, with a colon separator.
	call	barfchr
	mov	ax,si
	call	barfwrd
	mov	al,'='		; Show what it will be addressing too
	call	barfchr
	mov	ax,[si]		; best we can do is assume a word.
	call	barfwrd
	call	barflf		; And move to another line.
;
	pop	ax		; recover the accumulator for good.
	ret
barfcpu	ENDP

; Display the state of the CPU flags. Because other routines may affect
; flags, we use a copy of them and test the bit fields manually.

barfflg	PROC	NEAR
	push	cx
	pushf
	pop	cx		; save flags here to avoid many push/pops
	lea	ax,[novstr]	; prepare for string printing
	test	cx,MASK OVF
	jz	flgnov
	lea	ax,[ovstr]
flgnov:	push	ax
	call	barflin
;
;------ Now work on the direction flag
;
	lea	ax,[ndistr]
	test	cx,MASK DIF
	jz	flgndi
	lea	ax,[distr]
flgndi:	push	ax
	call	barflin
;
;------ Now the Interrupt flag
;
	lea	ax,[ninstr]
	test	cx,MASK INF
	jz	flgnin
	lea	ax,[intstr]
flgnin:	push	ax
	call	barflin
;
;------ Now the sign flag
;
	lea	ax,[nsistr]
	test	cx,MASK SIF
	jz	flgnsi
	lea	ax,[sistr]
flgnsi:	push	ax
	call	barflin
;
;------ Now the Zero flag
;
	lea	ax,[nzrstr]
	test	cx,MASK ZRF
	jz	flgnzr
	lea	ax,[zrstr]
flgnzr:	push	ax
	call	barflin
;
;------ Now the AUX flag
;
	lea	ax,[naxstr]
	test	cx,MASK AXF
	jz	flgnax
	lea	ax,[axstr]
flgnax:	push	ax
	call	barflin
;
;------ Now the Parity flag
;
	lea	ax,[npastr]
	test	cx,MASK PAF
	jz	flgnpa
	lea	ax,[pastr]
flgnpa:	push	ax
	call	barflin
;
;------ Finally, the carry flag
;
	lea	ax,[ncystr]
	test	cx,MASK	CYF
	jz	flgncy
	lea	ax,[cystr]
flgncy:	push	ax
	call	barflin
	pop	cx
	ret
barfflg	ENDP
Restext	ENDS

; Strings to format the dump of the processor registers/flags. The strings
; are coded so that when printed in the proper sequence everything lines up
; neatly.

Resdata	SEGMENT	WORD	PUBLIC	'STATIC'
axregstr	db	cr,lf,'AX: ',0		; AX & flags on first line
bxregstr	db	cr,lf,'BX: ',0		; BX/BP on next line
bpregstr	db	'       BP: ',0
cxregstr	db	cr,lf,'CX: ',0		; CX/SP on subsequent line
spregstr	db	'       SP: ',0
dxregstr	db	cr,lf,'DX: ',0		; DX/SS --last line of GP regs
ssregstr	db	'       SS: ',0
esregstr	db	cr,lf,cr,lf,'ES:DI ',0	; ES:DI printed together
dsregstr	db	cr,lf,'DS:SI ',0	; DS:SI printed next
ovstr		db	'       OV',0		; Overflow flag
novstr		db	'       NV',0
distr		db	' DN',0			; Direction flag (string moves)
ndistr		db	' UP',0
intstr		db	' EI',0			; Interrupt flag (EN/DIsable)
ninstr		db	' DI',0
sistr		db	' NG',0			; Sign flag (NeGative/PLus)
nsistr		db	' PL',0
zrstr		db	' ZR',0			; Zero flag (ZeRo/NotZero)
nzrstr		db	' NZ',0
axstr		db	' AF',0			; Aux flag (carry across nybbles)
naxstr		db	' NA',0
pastr		db	' PE',0			; Parity flag (Even/Odd)
npastr		db	' PO',0
cystr		db	' CY',0			; Carry flag
ncystr		db	' NC',0

Resdata	ENDS
	END
