#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

extern int errno;

struct {
	int    size;
	struct timeval start;
	struct timeval stop;
	u_long p_tcp;
	u_long p_udp;
} h120;

struct {
	u_long	sa, da;
	u_char	proto;
	u_short	port;
	u_long	bytes;
} d120;

struct {
	int    size;
	struct timeval start;
	struct timeval stop;
} h130;

struct {
	u_long	sa, da;
	u_char	proto;
	u_char	who_srv;
	u_short	port;
	u_long	psize;
	u_long	bytes;
} d130;

main(argc, argv)
	int argc;
	char **argv;
{
	int i;
	FILE *ifd, *ofd;

	if (argc < 3) {
		fprintf(stderr, "BPFT traffic file converter from v1.20 to v1.30\n");
		fprintf(stderr, "usage: myself file_v120 file_v130\n");
		exit(1);
	}

	if ((ifd = fopen(argv[1], "r")) == NULL) {
		fprintf(stderr, "'%s' %s\n", argv[1], strerror(errno));
		exit(1);
	}
	if ((ofd = fopen(argv[2], "w")) == NULL) {
		fprintf(stderr, "'%s' %s\n", argv[2], strerror(errno));
		exit(1);
	}
	while(fread(&h120, sizeof(h120), 1, ifd)) {
		if (feof(ifd))
			break;
		h130.size = h120.size;
		h130.start = h120.start;
		h130.stop = h120.stop;
		fwrite(&h130, sizeof(h130), 1, ofd);
		for (i = 0; i < h120.size; i++) {
			if (fread(&d120, sizeof(d120), 1, ifd) != 1)
				break;
			d130.sa = d120.sa;
			d130.da = d120.da;
			d130.proto = d120.proto;
			d130.who_srv = 3;
			d130.port = d120.port;
			d130.bytes = d130.psize = d120.bytes;
			fwrite(&d130, sizeof(d130), 1, ofd);
		}
	}
	exit(0);
}
