/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: trafshow.h,v 1.2 1994/01/14 11:42:01 bob Exp $
 *
 *	$Log: trafshow.h,v $
 * Revision 1.2  1994/01/14  11:42:01  bob
 * MAX_ENTRIES set to 21 lines instead 22
 *
 * Revision 1.1  1993/11/20  12:15:59  bob
 * Initial revision
 *
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/*
 * Maximum number of the buffered entries for screening.
 */
#define	MAX_ENTRIES	21

/*
 * Size of table for cache resolved addresses.
 */
#define	ADDR_TABLE	MAX_ENTRIES * 4

/*
 * Screen refresh interval in seconds.
 */
#define	REFRESH		5

/*
 * Offset on screen for ferst line.
 */
#define	SCR_OFFS	2

extern unsigned char *snapend;
extern char *device_name;
extern int nflag;
extern int Nflag;

typedef struct t_entry *p_entry;
static struct t_entry t, *entries1;
struct t_addr {
	struct in_addr ina;
	char astr[MAXHOSTNAMELEN+1];
	struct t_addr *prev;
} *atable;
