/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: main.c,v 1.1 1993/11/20 12:15:59 bob Exp $
 *
 *	$Log: main.c,v $
 * Revision 1.1  1993/11/20  12:15:59  bob
 * Initial revision
 *
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/*	main.c - show tcp/udp network data traffic	*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <net/bpf.h>

#include "../include/interface.h"

/*
 * Command line switches.
 * Left - default value, right - action, if switch has been used.
 */
int dflag;	/* dump to compiled packet-matching code to stdout and stop */
int Oflag = 1;	/* don't run the packet-matching code optimizer if have bug */
int pflag;	/* don't put the interface into promiscuous mode */
int nflag;
int Nflag;

/* Global variables */
char *program_name;	/* myself */
char *device_name = 0;	/* interface name */

/* Length of saved portion of packet */
int snaplen = DEFAULT_SNAPLEN;

static int if_fd = -1;

void
main(argc, argv)
	int argc;
	char **argv;
{
	struct bpf_program *parse();
	void bpf_dump(), usage();

	int op, cnt = -1, fflag = 0;
	struct bpf_program *fcode;
	char *infile = 0;
	char *cmdbuf;
	FILE *fd;
	extern char *optarg;
	extern int optind, opterr, errno;

	program_name = stripdir(argv[0]);

	opterr = 0;
	while ((op = getopt(argc, argv, "c:dfF:i:nNOp")) != EOF)
		switch (op) {
		case 'c':
			cnt = atoi(optarg);
			break;
		case 'd':
			++dflag;
			break;
		case 'f':
			++fflag;
			break;
		case 'F':
			infile = optarg;
			break;
		case 'i':
			device_name = optarg;
			break;
		case 'n':
			++nflag;
			break;
		case 'N':
			++Nflag;
			break;
		case 'O':
			Oflag = 0;
			break;
		case 'p':
			++pflag;
			break;
		default:
			usage();
		}

	/* Find network interface */
	if (device_name == 0)
		if ((device_name = getenv("IFF_LISTEN")) == NULL)
			if ((device_name = lookup_device()) == 0)
				error("can't find any interfaces");

	/* Attach bpf interface to the network interface */
	if_fd = bpf_init(device_name, pflag);

	if (infile) 
		cmdbuf = read_infile(infile);
	else
		cmdbuf = copy_argv(&argv[optind]);

	fcode = parse(cmdbuf, Oflag);
	if (dflag) {
		bpf_dump(fcode, dflag);
		exit(0);
	}

	/* Start read from bpf */
	if (!traf_init(fflag)) {
		if (bpf_readloop(cnt, if_fd, fcode))
			/* Clear exit */
			exit(0);
	} else
		errno = ENOMEM;

	/* Abnormal termination */
	perror("Abnormal termination");
	exit(1);
}

void
usage()
{
	extern char version[];

	fprintf(stderr, "trafshow v%s - show tcp/udp network data traffic\n", version);
	fprintf(stderr,
"Usage: %s [-dfnNOp] [-c count] [-i iface] [-F file | expr]\n", program_name);
	exit(-1);
}
