c
c $Id: roll2.f,v 1.1 1993/08/07 19:57:24 munro Exp $
c Copyright (c) 1994.  The Regents of the University of California.
c               All rights reserved.
c
      subroutine roll2(a, ioff, istd, n, n2, ws)
      integer ioff, istd, n, n2
      double precision a(istd,n,n2),ws(n)
c
c     a      double precision a(istd,n,n2)
c            to be "rolled", in place, on its middle dimension
c
c     ioff   the offset by which to "roll" a (iabs(ioff) .lt. n)
c            for ioff>0:
c               output a(1+ioff)=  input a(1)
c               output a(2+ioff)=  input a(2)
c                      ...         ...
c               output a(n-1)=     input a(n-ioff-1)
c               output a(n)=       input a(n-ioff)
c               output a(1)=       input a(n-ioff+1)
c               output a(2)=       input a(n-ioff+2)
c                      ...         ...
c               output a(ioff-1)=  input a(n-1)
c               output a(ioff)=    input a(n)
c            for ioff<0:
c               output a(1)=        input a(1-ioff)
c               output a(2)=        input a(2-ioff)
c                      ...          ...
c               output a(n+ioff-1)= input a(n-1)
c               output a(n+ioff)=   input a(n)
c               output a(n+ioff+1)= input a(1)
c               output a(n+ioff+2)= input a(2)
c                      ...          ...
c               output a(n-1)=      input a(-ioff-1)
c               output a(n)=        input a(-ioff)
c
c     istd   stride of values in a, that is, length of dimensions
c            of a before the one of length n
c
c     n2     length of dimensions of a after the one of length n
c
c     ws     double precision ws(n) of working space
c
c
c     internal variables
c
      integer i, i2, j, joff
c
      if (ioff .eq. 0) goto 100
      if (ioff .lt. 0) goto 50
         joff= n-ioff
         do 40 i2 = 1, n2
            do 30 i = 1, istd
               do 10 j = 1, joff
                  ws(j+ioff)= a(i, j, i2)
 10            continue
               do 15 j = 1, ioff
                  ws(j)= a(i, j+joff, i2)
 15            continue
               do 20 j = 1, n
                  a(i, j, i2)= ws(j)
 20            continue
 30         continue
 40      continue
         goto 100
c
 50   continue
         joff= n+ioff
         do 90 i2 = 1, n2
            do 80 i = 1, istd
               do 60 j = 1, -ioff
                  ws(j+joff)= a(i, j, i2)
 60            continue
               do 65 j = 1, joff
                  ws(j)= a(i, j-ioff, i2)
 65            continue
               do 70 j = 1, n
                  a(i, j, i2)= ws(j)
 70            continue
 80         continue
 90      continue
c
 100  continue
      return
      end
