*  -- Yorick wrappers for LAPACK routines:
*      dgecon - estimates matrix condition number
*      dgels  - QR or LQ decomposition least square matrix solver
*      dgesvd - SVD decomposition routine
*     plus XERBLA routine appropriate to Yorick
*
      SUBROUTINE DGECOX( NORM, N, A, LDA, ANORM, RCOND, WORK, IWORK,
     $                   INFO )
*
*  Purpose
*  =======
*
*  DGECOX is a wrapper for DGECON, more easily callable from non-FORTRAN
*  language routines (no gratuitous string argument).
*
*  Arguments
*  =========
*
*  NORM    (input) INTEGER
*          Specifies whether the 1-norm condition number or the
*          infinity-norm condition number is required:
*          = 1:           1-norm;
*          = 0:           Infinity-norm.
*
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER NRM
      IF ( NORM.NE.0 ) THEN
         NRM = '1'
      ELSE
         NRM = 'I'
      ENDIF
      CALL DGECON( NRM, N, A, LDA, ANORM, RCOND, WORK, IWORK, INFO )
      RETURN
      END
      SUBROUTINE DGELX( ITRN, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK,
     $                  INFO )
*
*  Purpose
*  =======
*
*  DGELX is a wrapper for DGELS, more easily callable from non-FORTRAN
*  language routines (no gratuitous string argument).
*
*  Arguments
*  =========
*
*  ITRN    (input) INTEGER
*          Specifies whether A is to be transposed:
*          = 1:           transpose (TRANS == 'T' in DGELS);
*          = 0:           (TRANS == 'N' in DGELS).
*
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER TRN
      IF ( ITRN.NE.0 ) THEN
         TRN = 'T'
      ELSE
         TRN = 'N'
      ENDIF
      CALL DGELS( TRN, M, N, NRHS, A, LDA, B, LDB, WORK, LWORK, INFO )
      RETURN
      END
      SUBROUTINE DGESVX( JOB, M, N, A, LDA, S, U, LDU, VT, LDVT,
     $                   WORK, LWORK, INFO )
*
*  Purpose
*  =======
*
*  DGESVX is a wrapper for DGESVD, more easily callable from non-FORTRAN
*  language routines (no gratuitous string arguments).
*
*  Arguments
*  =========
*
*  JOB     (input) INTEGER
*          Specifies whether min(m,n) or full matrix output:
*          = 1:           JOBU= JOBVT= 'A' in DGESVD;
*          = 0:           JOBU= JOBVT= 'S' in DGESVD.
*
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER JB
      IF ( JOB.NE.0 ) THEN
         JB = 'A'
      ELSE
         JB = 'S'
      ENDIF
      CALL DGESVD( JB, JB, M, N, A, LDA, S, U, LDU, VT, LDVT,
     $     WORK, LWORK, INFO )
      RETURN
      END
      SUBROUTINE XERBLA( SRNAME, INFO )
*
*  -- LAPACK auxiliary routine (version 1.1) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
*     .. Scalar Arguments ..
      CHARACTER*6        SRNAME
      INTEGER            INFO
*     ..
*
*  Purpose
*  =======
*
*  XERBLA  is an error handler for the LAPACK routines.
*  It is called by an LAPACK routine if an input parameter has an
*  invalid value.  A message is printed and execution stops.
*
*  Installers may consider modifying the STOP statement in order to
*  call system-specific exception-handling facilities.
*
*  Modified for use with Yorick.  Calls FBLOWUP, unless these are the
*  calls used to determine the workspace size for DGELS, DGELSS, or DGESVD.
*
*  Arguments
*  =========
*
*  SRNAME  (input) CHARACTER*6
*          The name of the routine which called XERBLA.
*
*  INFO    (input) INTEGER
*          The position of the invalid parameter in the parameter list
*          of the calling routine.
*
*     .. Executable Statements ..
*
      IF ( SRNAME.EQ.'DGELS ' .AND. INFO.EQ.10 ) THEN
         RETURN
      ELSE IF ( SRNAME.EQ.'DGELSS' .AND. INFO.EQ.12 ) THEN
         RETURN
      ELSE IF ( SRNAME.EQ.'DGESVD' .AND. INFO.EQ.13 ) THEN
         RETURN
      ELSE
         CALL FBLOWUP('(BUG) LAPACK input error -- XERBLA called')
         RETURN
      ENDIF
*     WRITE( *, FMT = 9999 )SRNAME, INFO
*
*     STOP
*
*9999 FORMAT( ' ** On entry to ', A6, ' parameter number ', I2, ' had ',
*    $      'an illegal value' )
*
*     End of XERBLA
*
      END
