/*
 * GTEXT.C
 *
 * $Id: gtext.c,v 1.1 1993/08/27 17:08:43 munro Exp $
 *
 * Define GIST text utilities
 *
 */
/*    Copyright (c) 1994.  The Regents of the University of California.
                    All rights reserved.  */

#include "gtext.h"

extern long strcspn(const char *, const char *);

/* Return t->alignH, t->alignV, guaranteed not TH_NORMAL or TV_NORMAL */
void GtGetAlignment(const GpTextAttribs *t, int *alignH, int *alignV)
{
  *alignH= t->alignH;
  *alignV= t->alignV;
  if (*alignH==TH_NORMAL) {
    if (t->path==T_RIGHT) *alignH= TH_LEFT;
    else if (t->path==T_LEFT) *alignH= TH_RIGHT;
    else if (t->path==T_UP) *alignH= TH_CENTER;
    else *alignH= TH_CENTER;
  }
  if (*alignV==TV_NORMAL) {
    if (t->path==T_RIGHT) *alignV= TV_BASE;
    else if (t->path==T_LEFT) *alignV= TV_BASE;
    else if (t->path==T_UP) *alignV= TV_BASE;
    else *alignV= TV_TOP;
  }
}

/* Get shape of text input to GdText, given a function Width which can
   compute the width of a simple text string (no imbedded \n).  Returns
   largest value of Width for any line, and a line count.  */
int GtTextShape(const char *text, const GpTextAttribs *t,
		WidthFunction Width, GpReal *widest)
{
  int path= t->path;
  GpReal wdest, thisWid;
  int nLines, nChars;

  /* Count lines in this text, find widest line */
  nLines= 0;
  wdest= 0.0;
  while ((text= GtNextLine(text, &nChars, path))) {
    nLines++;
    if (Width) thisWid= Width(text, nChars, t);
    else thisWid= (GpReal)nChars;
    if (thisWid>wdest) wdest= thisWid;
    text+= nChars;
  }

  *widest= wdest;
  return nLines;
}

/* Return the next line of text-- if text[0] is not '\n' and path not
   T_UP or T_DOWN, returns text and a count of the characters in the
   line, nChars (always 1 if T_UP or T_DOWN).  If text is '\0', or '\n'
   with path T_UP or T_DOWN, returns 0.  Otherwise, returns text+1 and
   a count of the number of characters to the next '\n' or '\0'.  */
const char *GtNextLine(const char *text, int *nChars, int path)
{
  int isHorizontal= path < T_UP;
  char first= text[0];

  if (!first || (!isHorizontal && first=='\n')) {
    *nChars= 0;
    return 0;
  }

  if (first=='\n') text+= 1;
  if (isHorizontal) *nChars= strcspn(text, "\n");
  else *nChars= 1;

  return text;
}
