/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * write the manufacturers bad sector file onto the last
 * track of an rl02 disk
 */
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <fcntl.h>
# include <errno.h>
# include <unistd.h>

# include "../system.h"

# define MDBSF	20460		/* starting lbn of file */
# define BLOCKS	20		/* size in blocks of file */

u_short	buf[256];

u_short
little_endian(u_short u)
{
	u_short	n = htons(u);
	return ((n & 0377) << 8) | ((n & 0177400) >> 8);
}


main(int argc, char *argv[])
{
	int	i, b, fd;
	long	serial;

	if(argc <= 1) {
		fprintf(stderr, "usage: rl2fmt file serial-no\n");
		exit(1);
	}
	serial = strtol(argv[2], 0, 0);

	memset(buf, 0377, sizeof(buf));
	buf[0] = little_endian((u_short)(serial >> 16));
	buf[1] = little_endian((u_short)serial);
	buf[2] = 0;
	buf[3] = 0;

	if((fd = open(argv[1], O_WRONLY | O_CREAT, 0666)) < 0) {
		fprintf(stderr, "%s: %s\n", argv[1], strerror(errno));
		exit(2);
	}
	lseek(fd, MDBSF * 512L, SEEK_SET);
	for(b = 0; b < BLOCKS; b++) {
		if(write(fd, buf, sizeof(buf)) != sizeof(buf)) {
			fprintf(stderr, "%s: %s\n", argv[1], strerror(errno));
			exit(2);
		}
	}
	close(fd);
	return 0;
}
