/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * driver for lp
 *
 * this program is usually piped from p11 trough a command line for
 * the lp driver like
 *	p11lp 'ofile%d' [pid-file]
 * %d is substituted by a number which is incremented by each USR1 signal
 */
# include <stdio.h>
# include <stdlib.h>
# include <limits.h>
# include <unistd.h>
# include <signal.h>
# include <errno.h>

# define DEFNAME	"p11-lp.%03d"

/*
 * sunos defines _POSIX_PATH_MAX but only 255 (r.a. (rad ab))
 */
# ifndef PATH_MAX
#  define PATH_MAX	1024
# endif

int	sig;

void
nextpage()
{
	sig++;
}


int
main(int argc, char **argv)
{
	char	*fname = DEFNAME;
	char	path[PATH_MAX];
	int	fnum = 0;
	char	c;
	int	got;
	FILE	*fp;
	struct sigaction sa;
	sigset_t set;

	if(argc > 1)
		fname = argv[1];
	if(argc > 2) {
		if((fp = fopen(argv[2], "w")) != NULL) {
			fprintf(fp, "%d", (int)getpid());
			fclose(fp);
		}
	}

	sigemptyset(&set);
	sa.sa_flags = 0;
	sa.sa_handler = nextpage;
	sa.sa_mask = set;
	sigaction(SIGUSR1, &sa, 0);

	fp = NULL;
	for(;;) {
		sig = 0;
		while(!sig) {
			if((got = read(0, &c, 1)) == 1) {
				if(fp == NULL) {
					sprintf(path, fname, fnum++);
					if((fp = fopen(path, "w")) == NULL)
						exit(1);
				}
				putc(c, fp);
			} else if(got == 0)
				exit(0);
			else if(errno != EINTR)
				exit(2);
		}
		if(fp != NULL) {
			fclose(fp);
			fp = NULL;
		}
	}
}
