/*
 * java.net.InetAddress.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include <assert.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include <native.h>
#include "../../kaffevm/itypes.h"
#include "java.net.stubs/InetAddress.h"
#include "nets.h"

#define	HOSTNMSZ	80

/*
 * Get localhost name.
 */
struct Hjava_lang_String*
java_net_InetAddress_getLocalHostName(struct Hjava_net_InetAddress* none)
{
	char hostname[HOSTNMSZ];

	if (gethostname(hostname, HOSTNMSZ-1) < 0) {
		strcpy("localhost", hostname);
	}
	return (makeJavaString(hostname, strlen(hostname)));
}

/*
 * Provide one of my local address (I guess).
 */
void
java_net_InetAddress_makeAnyLocalAddress(struct Hjava_net_InetAddress* none, struct Hjava_net_InetAddress* this)
{
	unhand(this)->hostName = 0;
	unhand(this)->address = htonl(INADDR_ANY);
	unhand(this)->family = AF_INET;
}

/*
 * Convert a hostname to the primary host address.
 */
HArrayOfByte*
java_net_InetAddress_lookupHostAddr(struct Hjava_net_InetAddress* none, struct Hjava_lang_String* str)
{
	char name[MAXHOSTNAME];
	struct hostent* ent;
	object* obj;

	javaString2CString(str, name, sizeof(name));

	ent = gethostbyname(name);
	if (ent == 0) {
		SignalError(0, "java.net.UnknownHostException", SYS_HERROR);
	}

	/* Copy in the network address */
	obj = AllocArray(sizeof(jint), TYPE_Byte);
	assert(obj != 0);
	*(jint*)(obj+1) = *(jint*)ent->h_addr_list[0];

	return ((HArrayOfByte*)obj);
}

/*
 * Convert a hostname to an array of host addresses.
 */
HArrayOfArray* /* HArrayOfArrayOfBytes */
java_net_InetAddress_lookupAllHostAddr(struct Hjava_net_InetAddress* none, struct Hjava_lang_String* str)
{
	char name[MAXHOSTNAME];
	struct hostent* ent;
	object* obj;
	object* array;
	int i;
	int alength;

	javaString2CString(str, name, sizeof(name));

	ent = gethostbyname(name);
	if (ent == 0) {
		SignalError(0, "java.net.UnknownHostException", SYS_HERROR);
	}

	for (alength = 0; ent->h_addr_list[alength]; alength++)
	  ;

	array = AllocObjectArray(alength, "[[B");
	assert(array != 0);

	for (i = 0; i < alength; i++) {
		/* Copy in the network address */
		obj = AllocArray(sizeof(jint), TYPE_Byte);
		assert(obj != 0);
		*(jint*)(obj+1) = *(jint*)ent->h_addr_list[i];
		((object**)(array+1))[i] = obj;
	}

	return ((HArrayOfArray*)array);
}

/*
 * Convert a network order address into the hostname.
 */
struct Hjava_lang_String*
java_net_InetAddress_getHostByAddr(struct Hjava_net_InetAddress* none, jint addr)
{
	struct hostent* ent;

	addr = htonl(addr);
	ent = gethostbyaddr((char*)&addr, sizeof(jint), AF_INET);
	if (ent == 0) {
		SignalError(0, "java.net.UnknownHostException", SYS_HERROR);
	}

	return (makeJavaString((char*)ent->h_name, strlen(ent->h_name)));
}

/*
 * Return the inet address family.
 */
jint
java_net_InetAddress_getInetFamily(struct Hjava_net_InetAddress* none)
{
	return (AF_INET);
}
