/*
 * java.net.DatagramSocket.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <native.h>
#include "../native/java.io.stubs/FileDescriptor.h"
#include "java.net.stubs/DatagramPacket.h"
#include "java.net.stubs/DatagramSocket.h"
#include "nets.h"
#include "kthread.h"

/*
 * Create a datagram socket.
 */
void
java_net_DatagramSocket_datagramSocketCreate(struct Hjava_net_DatagramSocket* this)
{
	int fd;

	fd = threadedSocket(AF_INET, SOCK_DGRAM, 0);
	unhand(unhand(this)->fd)->fd = fd;
	if (fd < 0) {
		SignalError(0, "java.net.SocketException", SYS_ERROR);
	}
}

/*
 * Bind a port to the socket.
 */
jint
java_net_DatagramSocket_datagramSocketBind(struct Hjava_net_DatagramSocket* this, jint port)
{
	int r;
	struct sockaddr_in addr;

#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = port;
	addr.sin_addr.s_addr = INADDR_ANY;

	r = bind(unhand(unhand(this)->fd)->fd, (struct sockaddr*)&addr, sizeof(addr));
	if (r < 0) {
		SignalError(0, "java.net.SocketException", SYS_ERROR);
	}

	return (addr.sin_port);
}

void
java_net_DatagramSocket_datagramSocketSend(struct Hjava_net_DatagramSocket* this, struct Hjava_net_DatagramPacket* pkt)
{
	abort();
}

jint
java_net_DatagramSocket_datagramSocketPeek(struct Hjava_net_DatagramSocket* this, struct Hjava_net_InetAddress* addr)
{
	abort();
}

void
java_net_DatagramSocket_datagramSocketReceive(struct Hjava_net_DatagramSocket* this, struct Hjava_net_DatagramPacket* pkt)
{
	abort();
}

/*
 * Close the socket.
 */
void
java_net_DatagramSocket_datagramSocketClose(struct Hjava_net_DatagramSocket* this)
{
	int r;

	if (unhand(unhand(this)->fd)->fd != -1) {
		r = close(unhand(unhand(this)->fd)->fd);
		unhand(unhand(this)->fd)->fd = -1;
		if (r < 0) {
			SignalError(0, "java.net.SocketException", SYS_ERROR);
		}
	}
}
