/*
 * object.h
 * Object representation.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __object_h
#define __object_h

#include "gtypes.h"
#include "locks.h"
#include "gc.h"

struct _dispatchTable;
struct _classes;

typedef struct _object {
	gcHead			gc;
	struct _dispatchTable*	dtable;
	uint32			size;
	iMux			mux;
	iCv			cv;
	/* Data follows on immediately */
} object;

/*
 * These bizzare casts provide various offset into the object structure.
 */
#define	OBJECT_DTABLE		((int)&(*(object*)0).dtable)
#define	OBJECT_IDX		((int)&(*(object*)0).gc.colour)
#define	OBJECT_SIZE		((int)&(*(object*)0).size)
#define	OBJECT_DATA		((int)(((object*)0)+1))

#define	alloc_object(c, p) \
	(object*)newObject((c)->fsize * sizeof(u4), (c), 0, (p))
#define	alloc_class() \
	(classes*)newObject(sizeof(classes)-sizeof(object), ClassClass, 0, true)

object*	alloc_array(int, int);
object*	alloc_objectarray(int, char*);
object*	alloc_multiarray(int*, char*);

#endif
