/*
 * object.c
 * Handle create and subsequent garbage collection of objects.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "gtypes.h"
#include "itypes.h"
#include "access.h"
#include "object.h"
#include "constants.h"
#include "classMethod.h"
#include "baseClasses.h"
#include "errors.h"
#include "exception.h"
#include "gc.h"

extern struct itypes types[];

/*
 * Create a new array of data items (not objects).
 */
object*
alloc_array(int sz, int type)
{
	object* obj;
	classes* class;

	assert(type < MAXTYPES);
	assert(TYPE_SIZE(type) != 0);

	class = lookupArray(TYPE_ARRAYSIG(type));

	/* Allocate new object - we add an extra jint of space to avoid
	 * any possible page faults when accessing the last elements
	 */
	obj = newObject(sz*TYPE_SIZE(type)+sizeof(jint), class, sz, false);
	return (obj);
}

/*
 * Create a new array of objects.
 */
object*
alloc_objectarray(int sz, char* csig)
{
	char sig[CLASSMAXSIG];
	object* obj;
	classes* class;

	/* Build signature for array type */
	strcpy(sig, "[");
	strcat(sig, csig);

	class = lookupArray(addString(sig));

	/* Allocate new array of objects - we add an extra jint of space to
	 * avoid any possible page faults when accessing the last elements
	 */
	obj = (object*)newObject(sz * TYPE_SIZE_C(csig[0]) + sizeof(jint), class, sz, false);
	return (obj);
}

/*
 * Build a multi-dimensional array.
 */
object*
alloc_multiarray(int* dims, char* cname)
{
	object* obj;
	object** array;
	int i;

	obj = alloc_objectarray(dims[0], cname+1);
	if (dims[1] > 0) {
		array = (object**)(obj+1);
		for (i = 0; i < dims[0]; i++) {
			array[i] = alloc_multiarray(dims+1, cname+1);
		}
	}

	return (obj);
}
