/* slots.h
 * Slots.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __slots_h
#define __slots_h

#define	USE_NO_SLOTS		0
#define	USE_SLOT_1		1
#define	USE_SLOT_2		2
#define	USE_SLOT_12		(USE_SLOT_1 | USE_SLOT_2)
#define	SLOT_1(_s)		((_s) & USE_SLOT_1)
#define	SLOT_2(_s)		((_s) & USE_SLOT_2)

#define	Tcomplex		0
#define	Tnull			Tcomplex
#define	Tconst			1
#define	Tcopy			2
#define	Taddregconst		3
#define	Tstore			4
#define	Tload			5

#define	MAXSLOT			64
#define	NOSLOT			0

/* Return slots */
#define	returnInt		0
#define	returnRef		0
#define	returnLong		0 /* 1 */
#define	returnFloat		2
#define	returnDouble		2 /* 3 */
#define	MAXRETURNS		4

struct _slots;

typedef struct _slots {
	union {
		jint		tint;
		jlong		tlong;
		jdouble		tdouble;
		void*		taddr;
		char*		tstr;
	} v;
	struct _sequence*	insn;
	int			regno;
	int			modified;
} slots;

extern slots* slotinfo;
extern slots* returninfo;
extern slots* localinfo;
extern slots* stackinfo;
extern slots* tempinfo;
extern int tmpslot;
extern int stackno;

void initSlots(void);
void markReturns(void);

/* Slot access macros */

#define	stack(_s)		(&stackinfo[stackno+(_s)])
#define	local(_s)		(&localinfo[(_s)])
#define	local_long(_s)		(&localinfo[(_s)])
#define	local_float		local
#define	local_double		local_long

#define	slot_return(_s)		((_s) >= &returninfo[0] &&		\
				 (_s) < &returninfo[MAXRETURNS])

#define	slot_value(_s)		((_s)->v.tint)
#define	slot_fvalue(_s)		((_s)->v.tdouble)
#define	slot_type(_s)		(flag_optimise && (_s)->insn ? (_s)->insn->type : Tnull)
#define	slot_insn(_s)		((_s)->insn)
#define	slot_ref(_s)		((_s)->insn->ref)
#define	slot_pop(_s)		(seq_pop(slot_insn(_s)))

#define	slot_alloctmp(t)	(t) = &tempinfo[tmpslot],		\
				tmpslot += 1
#define	slot_alloc2tmp(t)	(t) = &tempinfo[tmpslot],		\
				tmpslot += 2
#define	slot_invalidate(_s)	(_s)->regno = NOREG;			\
				(_s)->modified = 0
#define	slot_nowriteback(_s)	if (flag_optimise) {			\
					slot_slot_const(0, 0, (uintp)(_s), invalSlot, Tcomplex); \
				}

#endif
