/* machine.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __machine_h
#define __machine_h

/* -------------------------------------------------------------------- */

/* Instructions */
#define	define_insn(code)	break;					\
				case code :

/* Stack */
#define	push(_i)		stackno -= (_i)
#define	pop(_i)			stackno += (_i)

/* PC */
#define	getpc(_p)		base[pc+1+(_p)]
#define	getcode(_p)		base[(_p)]
#define	adjustpc(_p)		npc = pc + (_p)

/* -------------------------------------------------------------------- */
/* Constants */

#define	constants()		(meth->constants)
#define	constant(idx)						\
		(slot_alloctmp(cnst),				\
		move_int_const(cnst,				\
		(constants()->tags[idx] == CONSTANT_Chararray ?	\
			makeStringObject(idx, constants()) :	\
			&constants()->data[idx])->v.tint),	\
		cnst)
#define	constant_long(idx)					\
		(slot_alloc2tmp(cnst),				\
		move_long_const(cnst, constants()->data[idx].v.tlong),\
		cnst)

/* -------------------------------------------------------------------- */
/* Methods */

#define	get_method_info(cnst, idx)				\
	getMethodSignatureClass(idx, cnst, &cinfo)

#define	method_name()						\
			(slot_alloctmp(cnst),			\
			move_ref_const(cnst, cinfo.mtag),	\
			cnst)
#define	method_tag()	(cinfo.mtag)
#define	method_hash()	(cinfo.offset)
#define	method_idx()	(cinfo.idx)
#define	get_dispatch_table(mtable)				\
			move_ref_const(mtable, cinfo.dtable)

#define	method_nargs()		(cinfo.in)
#define	method_dtable_offset	(OBJECT_DTABLE)
#define	method_mtable_offset	(DTABLE_MTABLEOFFSET)
#define	method_returntype()	(cinfo.rettype)
#define	method_arg(_a)		(cinfo.type[(_a)])

/* -------------------------------------------------------------------- */
/* Fields */

#define	get_field_info(cnst, idx)				\
		getField(idx, false, cnst, &flinfo)

#define	get_static_field_info(cnst, idx)			\
		getField(idx, true, cnst, &flinfo)

#define	field_data()		(OBJECT_DATA)
#define	field_statics()		((uintp)flinfo.class->staticFields)
#define	field_size()		(flinfo.size)
#define	field_offset()		(flinfo.offset * 4)
#define	field_isref()		(flinfo.isref)

/* -------------------------------------------------------------------- */
/* Classes */

#define	get_class_info(cnst, idx)				\
		getClass(idx, cnst, &crinfo)

#define	class_object()						\
			(slot_alloctmp(cnst),			\
			move_ref_const(cnst, crinfo.class),	\
			cnst)

/* -------------------------------------------------------------------- */
/* Objects */

#define	object_array_offset	(OBJECT_DATA)
#define	object_array_length	(OBJECT_SIZE)
#define	object_colour()		(OBJECT_IDX)
#define	object_white()		(COLOUR_WHITE)

/* -------------------------------------------------------------------- */
/* Switches */

#define	switchpair_size		8
#define	switchpair_addr		4
#define	switchtable_shift	2

struct _methods;
void translate(struct _methods*);

#endif
