/* codeinfo.h
 * Defines the info we hold on code while translating it.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __codeinfo_h
#define __codeinfo_h

#define IBBSTART		1
#define IEBSTART		2

#define	SET_BASICBLOCK_START(meth, pc)					\
	code[pc].block |= IBBSTART
#define	IS_BASICBLOCK_START(meth, pc)					\
	(code[pc].block & IBBSTART)

#define	SET_EXCEPTIONBLOCK_START(meth, pc)				\
	code[pc].block |= IEBSTART
#define	IS_EXCEPTIONBLOCK_START(meth, pc)				\
	(code[pc].block & IEBSTART)

#define	SET_STACKVAL(pc, depth)						\
	code[pc].stackdepth = (depth)
#define	STACKVAL(pc)							\
	code[pc].stackdepth
#define	STACK_NOT_SET(pc)						\
	(code[pc].stackdepth == -1)

typedef struct {
	uint8	block;
	int16	stackdepth;
	uintp	pc;
} codes;

extern codes* code;

#endif
