/* basecode.h
 * Define the base instructions macros.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __basecode_h
#define __basecode_h

extern int argcount;

/* -------------------------------------------------------------------- */
/* Branches */

#define	ba			0	/* Always */
#define	beq			1	/* Equal */
#define	blt			2	/* Less than */
#define	ble			3	/* Less than or equal */
#define	bgt			4	/* Greater than */
#define	bge			5	/* Greater than or equal */
#define	bne			6	/* Not equal */
#define	bn			7	/* Never */

#define	invert_branch(b)	(7-(b))

#define	bindirect		8	/* Indirect */

/* -------------------------------------------------------------------- */
/* Basic blocks and instructions */

#define	start_instruction()	_start_instruction(pc)
#define	start_function()	prologue()
#define	start_basic_block()	_start_basic_block(npc, stackno)
#define	end_basic_block()	_end_basic_block(stackno, tmpslot)
#define	end_function()		epilogue()
#define	start_exception_block()	_start_exception_block(stackno)
#define	cancel_insn(_s)		overwrite_optimise(slot_insn(_s))

/* -------------------------------------------------------------------- */
/* Conditional monitors */

#define	monitor_enter()		mon_enter(meth, local(0))
#define	monitor_exit()		mon_exit(meth, local(0))

/* -------------------------------------------------------------------- */
/* Instruction formats */

#define	slot_const_const(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_const_const((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_const(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_slot_const((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_fconst(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_slot_fconst((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_slot(dst, src, src2, func, t)				\
	{								\
		void func(sequence*);					\
		_slot_slot_slot((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_slot_lconst(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_slot_lconst((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_slot_fconst(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_slot_fconst((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_lslot_lslot(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_lslot_lslot((dst), (src), (src2), (func), (t));	\
	}

#define	lslot_lslot_slot(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_lslot_lslot_slot((dst), (src), (src2), (func), (t));	\
	}

#define	slot_slot_lslot(dst, src, src2, func, t)			\
	{								\
		void func(sequence*);					\
		_slot_slot_lslot((dst), (src), (src2), (func), (t));	\
	}

/* -------------------------------------------------------------------- */

#endif
