/*
 * machine.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __machine_h
#define	__machine_h

#define	constants()		(meth->constants)
#define	constant(_idx)							\
	(constants()->tags[_idx] == CONSTANT_Chararray ?		\
		makeStringObject(_idx, constants()) :			\
		&constants()->data[_idx])
	
#define	constant_long(_idx)						\
		&constants()->data[_idx]

#define getpc(n)		(code[pc+1+(n)])
#define getcode(n)		(code[(n)])

#define	object_array_offset	(OBJECT_DATA)
#define	object_array_length	(OBJECT_SIZE)
#define object_colour()		(OBJECT_IDX)
#define object_white()		(COLOUR_WHITE)

#define	get_method_info(_cnst, _idx) \
	getMethodSignatureClass(_idx, _cnst, &cinfo)

#define	get_dispatch_table(mtable) \
	move_ref(mtable, ((slots*)&cinfo.dtable))

#define	method_name()		((strpair*)cinfo.mtag)
#define method_tag()		(cinfo.mtag)
#define method_hash()		(cinfo.offset)
#define method_idx()		(cinfo.idx)
#define	method_nargs()		(cinfo.in)
#define	method_dtable_offset	OBJECT_DTABLE
#define	method_mtable_offset	DTABLE_MTABLEOFFSET
#define	method_returntype()	(cinfo.rettype)

#define	get_field_info(_cnst, _idx) \
	getField(_idx, false, _cnst, &flinfo)

#define	get_static_field_info(_cnst, _idx) \
	getField(_idx, true, _cnst, &flinfo)

#define	field_size()		(flinfo.size)
#define	field_data()		(OBJECT_DATA)
#define	field_offset()		(flinfo.offset * 4)
#define	field_isref()		(flinfo.isref)
#define	field_statics()		((uintp)flinfo.class->staticFields)

#define	get_class_info(_cnst, _idx) \
	getClass(_idx, _cnst, &crinfo)

#define	class_object()		((slots*)&crinfo.class)

#define	switchpair_size		8
#define	switchpair_addr		4
#define	switchtable_shift	2

struct _methods;
void virtualMachine(struct _methods*, slots*);

#endif
