/*
 * gc-simple.h
 * The garbage collector.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __gc_h
#define __gc_h

/* When's a good time to run the GC?
 * Run after allocation X bytes of objects.
 */
#define	GCTRIGSIZE	(64 * 1024)

#define	GC_FREE		0	/* Object free */
#define	GC_MARK		1	/* Object reachable, never been finalised */
#define	GC_UNMARK	2	/* Object unreachable, never been finalised */
#define	GC_GARBAGE	3	/* Object garbaged, never been finalised */
#define	GC_UNMARK2	4	/* Object unreachable, been finalied */
#define	GC_GARBAGE2	5	/* Object garbaged, been finalised */

struct _object;
typedef struct _gcRef {
	int		flags;			/* State of this entry */
	int		idx;			/* This entry index */
	struct _object*	obj;			/* Used - the object */
	struct _gcRef*	next;			/* Free - the next free */
	struct _gcRef*	walk;			/* Next object in walk */
} gcRef;

typedef struct _gcHead {
	uint32		idx;
} gcHead;

#define	INITGC(_o)	(_o).gc.idx = 0

#define	GCREFTABLESZ		1024
#define	GCREFMAX		1024

struct _classes;
void*	newObject(int, struct _classes*, int, bool);
void	invokeGarbageCollector(void);

#endif
