/*
 * java.lang.Object.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <assert.h>
#include <memory.h>
#include <native.h>
#include "../../kaffevm/classMethod.h"	/* Don't need java.lang.Object.h */
#include "../../kaffevm/locks.h"

extern object* alloc_object(classes*);

/*
 * Generate object hash code.
 */
long
java_lang_Object_hashCode(struct Hjava_lang_Object* o)
{
	return (o->idx);
}

/*
 * Return class object for this object.
 */
struct Hjava_lang_Class*
java_lang_Object_getClass(struct Hjava_lang_Object* o)
{
	return (o->mtable->class);
}

/*
 * Notify threads waiting here.
 */
void
java_lang_Object_notifyAll(struct Hjava_lang_Object* o)
{
	broadcastCond(o);
}

/*
 * Notify a thread waiting here.
 */
void
java_lang_Object_notify(struct Hjava_lang_Object* o)
{
	signalCond(o);
}

/*
 * Clone me.
 */
struct Hjava_lang_Object*
java_lang_Object_clone(struct Hjava_lang_Object* o)
{
	object* obj;

	obj = alloc_object(o->mtable->class);
	memcpy(obj->data, o->data, obj->mtable->class->fsize * 4);

	return (obj);
}

/*
 * Wait for this object to be notified.
 */
void
java_lang_Object_wait(struct Hjava_lang_Object* o, long long timeout)
{
	waitCond(o, timeout);
}
