/*
 * java.lang.Class.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <assert.h>
#include <native.h>
#include "../../kaffevm/gtypes.h"
#include "../../kaffevm/classMethod.h"
#include "defs.h"

extern char* addString(char*);
extern object* alloc_object(struct Hjava_lang_Class*);
extern object* alloc_objectarray(int, char*);
extern struct Hjava_lang_Class*	lookupClass(char*);

/*
 * Convert string name to class object.
 */
struct Hjava_lang_Class*
java_lang_Class_forName(struct Hjava_lang_String* str)
{
	struct Hjava_lang_Class* c;
	char* s;
	char buf[MAXNAMELEN];
	int i;

	/* Get string and convert '.' to '/' */
	javaString2CString(str, buf, sizeof(buf));
	classname2pathname(buf, buf);

	c = lookupClass(addString(buf));
	assert(c != 0);

	return (c);
}

/*
 * Convert class to string name.
 */
struct Hjava_lang_String*
java_lang_Class_getName(struct Hjava_lang_Class* c)
{
	return (makeJavaString(c->name, strlen(c->name)));
}

/*
 * Create a new instance of the derived class.
 */
struct Hjava_lang_Object*
java_lang_Class_newInstance(struct Hjava_lang_Class* this)
{
	return (execute_java_constructor(0, 0, this, "()V"));
}

/*
 * Return super class.
 */
struct Hjava_lang_Class*
java_lang_Class_getSuperclass(struct Hjava_lang_Class* this)
{
	return (this->superclass);
}

HArray* /* [Ljava.lang.Class; */
java_lang_Class_getInterfaces(struct Hjava_lang_Class* this)
{
	object* obj;
	struct Hjava_lang_Class** ifaces;
	int i;

	obj = alloc_objectarray(this->interface_len, this->name);
	ifaces = (struct Hjava_lang_Class**)obj->data;
	for (i = 0; i < this->interface_len; i++) {
		ifaces[i] = this->interface[i];
	}

	return ((HArray*)obj);
}

/*
 * Return the class loader which loaded me.
 * Not currently supported.
 */
struct Hjava_lang_ClassLoader*
java_lang_Class_getClassLoader(struct Hjava_lang_Class* this)
{
	return (0);
}

/*
 * Is the class an interface?
 */
long /* bool */
java_lang_Class_isInterface(struct Hjava_lang_Class* this)
{
	return ((this->accflags & ACC_INTERFACE) ? 1 : 0);
}
